/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

final class ThemeJsonSchemaProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @NonNls
    private static final String THEME_SCHEMA = "/schemes/theme.schema.json";

    ThemeJsonSchemaProviderFactory() {
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            ThemeJsonSchemaProviderFactory.$$$reportNull$$$0(0);
        }
        List<JsonSchemaFileProvider> list = Collections.singletonList(new JsonSchemaFileProvider(){

            public boolean isAvailable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ThemeJsonUtil.isThemeFilename(file.getName());
            }

            @NotNull
            public String getName() {
                String string = DevKitThemesBundle.message("theme.json.display.name", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public VirtualFile getSchemaFile() {
                return JsonSchemaProviderFactory.getResourceFile(this.getClass(), (String)ThemeJsonSchemaProviderFactory.THEME_SCHEMA);
            }

            @NotNull
            public SchemaType getSchemaType() {
                SchemaType schemaType = SchemaType.embeddedSchema;
                if (schemaType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return schemaType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/themes/ThemeJsonSchemaProviderFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeJsonSchemaProviderFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemaType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        if (list == null) {
            ThemeJsonSchemaProviderFactory.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/themes/ThemeJsonSchemaProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeJsonSchemaProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

