/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.xml.DomFileElement;
import java.util.Properties;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/devkit/themes/actions/NewThemeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "THEME_JSON_TEMPLATE", "", "THEME_PROVIDER_EP_NAME", "Lorg/jetbrains/annotations/NonNls;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "createThemeJson", "Lcom/intellij/psi/PsiFile;", "themeName", "isDark", "", "project", "Lcom/intellij/openapi/project/Project;", "dir", "Lcom/intellij/psi/PsiDirectory;", "module", "Lcom/intellij/openapi/module/Module;", "getThemeJsonFileName", "getThemeColorSchemeFileName", "registerTheme", "file", "getSourceRootRelativeLocation", "getRandomId", "intellij.devkit.themes"})
public final class NewThemeAction
extends AnAction {
    @NotNull
    private final String THEME_JSON_TEMPLATE;
    @NotNull
    private final String THEME_PROVIDER_EP_NAME = UIThemeProvider.EP_NAME.getName();

    public NewThemeAction() {
        this.THEME_JSON_TEMPLATE = "ThemeJson.json";
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (ideView == null) {
            return;
        }
        IdeView view = ideView;
        PsiDirectory psiDirectory = view.getOrChooseDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory dir = psiDirectory;
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            return;
        }
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Ref.ObjectRef name = new Ref.ObjectRef();
        Ref.ObjectRef isDark = new Ref.ObjectRef();
        DialogPanel panel = BuilderKt.panel(arg_0 -> NewThemeAction.actionPerformed$lambda$3(name, isDark, arg_0));
        String string = DevKitThemesBundle.message("new.theme.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DialogWrapper dialog = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)panel), (boolean)false, null, (boolean)false, (Project)project2, null, null, null, null, null, (int)2012, null);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Cell cell;
            Cell cell2;
            if (name.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"name");
                cell2 = null;
            } else {
                cell2 = (Cell)name.element;
            }
            String string2 = ((JBTextField)cell2.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (isDark.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"isDark");
                cell = null;
            } else {
                cell = (Cell)isDark.element;
            }
            PsiFile file = this.createThemeJson(string2, ((JBCheckBox)cell.getComponent()).isSelected(), project2, dir, module2);
            view.selectElement((PsiElement)file);
            FileEditorManager.getInstance((Project)project2).openFile(file.getVirtualFile(), true);
            this.registerTheme(dir, file, module2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        e.getPresentation().setEnabled(module != null && (PluginModuleType.get((Module)module) instanceof PluginModuleType || PsiUtil.isPluginModule(module)));
    }

    private final PsiFile createThemeJson(String themeName, boolean isDark, Project project, PsiDirectory dir, Module module) {
        String fileName = this.getThemeJsonFileName(themeName);
        String colorSchemeFilename = this.getThemeColorSchemeFileName(themeName);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(this.THEME_JSON_TEMPLATE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        Properties editorSchemeProps = new Properties();
        editorSchemeProps.setProperty("NAME", themeName);
        editorSchemeProps.setProperty("PARENT_SCHEME", isDark ? "Darcula" : "Default");
        FileTemplate fileTemplate2 = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("ThemeEditorColorScheme.xml");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"getJ2eeTemplate(...)");
        FileTemplate editorSchemeTemplate = fileTemplate2;
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)editorSchemeTemplate, (String)colorSchemeFilename, (Properties)editorSchemeProps, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
        PsiElement colorScheme = psiElement;
        Properties props = new Properties();
        props.setProperty("NAME", themeName);
        props.setProperty("IS_DARK", String.valueOf(isDark));
        props.setProperty("COLOR_SCHEME_NAME", this.getSourceRootRelativeLocation(module, (PsiFile)colorScheme));
        PsiElement psiElement2 = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createFromTemplate(...)");
        PsiElement created = psiElement2;
        boolean bl = created instanceof PsiFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (PsiFile)created;
    }

    private final String getThemeJsonFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".theme.json";
    }

    private final String getThemeColorSchemeFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".xml";
    }

    private final void registerTheme(PsiDirectory dir, PsiFile file, Module module) {
        String relativeLocation = this.getSourceRootRelativeLocation(module, file);
        XmlFile xmlFile = DevkitActionsUtil.choosePluginModuleDescriptor(dir);
        if (xmlFile == null) {
            return;
        }
        XmlFile pluginXml = xmlFile;
        DescriptorUtil.checkPluginXmlsWritable(module.getProject(), pluginXml);
        DomFileElement<IdeaPlugin> domFileElement = DescriptorUtil.getIdeaPluginFileElement(pluginXml);
        PsiFile[] psiFileArray = new PsiFile[]{pluginXml};
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])psiFileArray).run(() -> NewThemeAction.registerTheme$lambda$4(domFileElement, this, relativeLocation));
    }

    private final String getSourceRootRelativeLocation(Module module, PsiFile file) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] virtualFileArray = rootManager.getSourceRoots(false);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
        VirtualFile[] sourceRoots = virtualFileArray;
        VirtualFile virtualFile = file.getVirtualFile();
        String relativeLocation = null;
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)virtualFile, (boolean)true)) continue;
            String string = VfsUtil.getRelativeLocation((VirtualFile)virtualFile, (VirtualFile)sourceRoot);
            if (string == null) continue;
            relativeLocation = string;
            break;
        }
        return "/" + relativeLocation;
    }

    private final String getRandomId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean actionPerformed$lambda$3$lambda$1$lambda$0(Ref.ObjectRef $name, JBTextField it) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($name.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            cell = null;
        } else {
            cell = (Cell)$name.element;
        }
        String string = ((JBTextField)cell.getComponent()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string);
    }

    private static final Unit actionPerformed$lambda$3$lambda$1(Ref.ObjectRef $name, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = TextFieldKt.columns((Cell)$this$row.textField().focused(), (int)30);
        String string = DevKitThemesBundle.message("new.theme.dialog.name.empty", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $name.element = cell.addValidationRule(string, arg_0 -> NewThemeAction.actionPerformed$lambda$3$lambda$1$lambda$0($name, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$3$lambda$2(Ref.ObjectRef $isDark, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DevKitThemesBundle.message("new.theme.dialog.is.dark.checkbox.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $isDark.element = ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)true);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$3(Ref.ObjectRef $name, Ref.ObjectRef $isDark, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = DevKitThemesBundle.message("new.theme.dialog.name.text.field.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> NewThemeAction.actionPerformed$lambda$3$lambda$1($name, arg_0));
        $this$panel.row("", arg_0 -> NewThemeAction.actionPerformed$lambda$3$lambda$2($isDark, arg_0));
        return Unit.INSTANCE;
    }

    private static final void registerTheme$lambda$4(DomFileElement $domFileElement, NewThemeAction this$0, String $relativeLocation) {
        Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)$domFileElement, this$0.THEME_PROVIDER_EP_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)extensions, (String)"findOrCreateExtensionsForEP(...)");
        Extensions extensions2 = extensions;
        XmlTag xmlTag = extensions2.addExtension(this$0.THEME_PROVIDER_EP_NAME).getXmlTag();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getXmlTag(...)");
        XmlTag extensionTag = xmlTag;
        extensionTag.setAttribute("id", this$0.getRandomId());
        extensionTag.setAttribute("path", $relativeLocation);
    }
}

