/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

final class ThemeEditorToolbar
implements EditorNotificationProvider,
DumbAware {
    ThemeEditorToolbar() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ThemeEditorToolbar.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ThemeEditorToolbar.$$$reportNull$$$0(1);
        }
        return fileEditor -> {
            if (ThemeJsonUtil.isThemeFilename(file.getName())) {
                JBColor bg = JBColor.lazy(() -> ExperimentalUI.isNewUI() ? EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground() : JBColor.PanelBackground);
                EditorNotificationPanel panel = new EditorNotificationPanel((Color)bg);
                panel.removeAll();
                panel.setBorder(null);
                DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("DevKit.ThemeEditorToolbar");
                ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ThemeEditor", (ActionGroup)group, true);
                actionToolbar.setTargetComponent((JComponent)panel);
                JComponent toolbarComponent = actionToolbar.getComponent();
                toolbarComponent.setBackground((Color)bg);
                panel.add((Component)toolbarComponent);
                return UiDataProvider.wrapComponent((JComponent)panel, sink -> sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)fileEditor.getFile()));
            }
            return null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/themes/actions/ThemeEditorToolbar";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

