/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.metadata;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/themes/metadata/ThemeMetadataJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "DOT_EXTENSION", "", "THEME_METADATA_SCHEMA", "intellij.devkit.themes"})
public final class ThemeMetadataJsonSchemaProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @NonNls
    @NotNull
    private final String DOT_EXTENSION;
    @NonNls
    @NotNull
    private final String THEME_METADATA_SCHEMA;

    public ThemeMetadataJsonSchemaProviderFactory() {
        this.DOT_EXTENSION = ".themeMetadata.json";
        this.THEME_METADATA_SCHEMA = "/schemes/themeMetadata.schema.json";
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<JsonSchemaFileProvider> list = Collections.singletonList(new JsonSchemaFileProvider(this){
            final /* synthetic */ ThemeMetadataJsonSchemaProviderFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public String getName() {
                String string = DevKitThemesBundle.message("theme.metadata.json.display.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean isAvailable(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                CharSequence charSequence = file.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                return StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)ThemeMetadataJsonSchemaProviderFactory.access$getDOT_EXTENSION$p(this.this$0), (boolean)false, (int)2, null);
            }

            public VirtualFile getSchemaFile() {
                URL uRL = this.getClass().getResource(ThemeMetadataJsonSchemaProviderFactory.access$getTHEME_METADATA_SCHEMA$p(this.this$0));
                Intrinsics.checkNotNull((Object)uRL);
                return VfsUtil.findFileByURL((URL)uRL);
            }

            public SchemaType getSchemaType() {
                return SchemaType.embeddedSchema;
            }
        });
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        return list;
    }

    public static final /* synthetic */ String access$getDOT_EXTENSION$p(ThemeMetadataJsonSchemaProviderFactory $this) {
        return $this.DOT_EXTENSION;
    }

    public static final /* synthetic */ String access$getTHEME_METADATA_SCHEMA$p(ThemeMetadataJsonSchemaProviderFactory $this) {
        return $this.THEME_METADATA_SCHEMA;
    }
}

