/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.LightColors;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.uiDesigner.DevKitUIDesignerBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/uiDesigner/ConvertFormNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.devkit.uiDesigner"})
public final class ConvertFormNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile formPsiFile = psiFile;
        return ConvertFormNotificationProvider::collectNotificationData$lambda$3;
    }

    private static final Unit collectNotificationData$lambda$3$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.BalloonError;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        String string = DevKitUIDesignerBundle.message("convert.form.editor.notification.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)Integer.MAX_VALUE, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectNotificationData$lambda$3$lambda$1(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ConvertFormNotificationProvider::collectNotificationData$lambda$3$lambda$1$lambda$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final DialogPanel collectNotificationData$lambda$3(FileEditor fileEditor) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (!(fileEditor instanceof UIFormEditor)) {
            return null;
        }
        String string = ((UIFormEditor)fileEditor).getEditor().getRootContainer().getClassToBind();
        if (string == null) {
            return null;
        }
        String classToBind = string;
        DialogPanel $this$collectNotificationData_u24lambda_u243_u24lambda_u242 = dialogPanel = BuilderKt.panel(ConvertFormNotificationProvider::collectNotificationData$lambda$3$lambda$1);
        boolean bl = false;
        $this$collectNotificationData_u24lambda_u243_u24lambda_u242.setBorder(JBUI.Borders.empty((Insets)((Insets)JBUI.CurrentTheme.Editor.Notification.borderInsets())));
        $this$collectNotificationData_u24lambda_u243_u24lambda_u242.setBackground(LightColors.RED);
        return dialogPanel;
    }
}

