/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormToDslActionKt;
import org.jetbrains.idea.devkit.uiDesigner.DevKitUIDesignerBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/uiDesigner/ConvertFormToDslAction;", "", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.devkit.uiDesigner"})
public final class ConvertFormToDslAction {
    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        PsiJavaFile psiJavaFile = object instanceof PsiJavaFile ? (PsiJavaFile)object : null;
        if (psiJavaFile == null) {
            return;
        }
        PsiJavaFile psiFile = psiJavaFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiElement element = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null) {
            ConvertFormToDslAction $this$actionPerformed_u24lambda_u240 = this;
            boolean bl = false;
            HintManager.getInstance().showErrorHint(editor2, DevKitUIDesignerBundle.message("convert.form.hint.caret.not.in.form.bound.class", new Object[0]));
            return;
        }
        PsiClass psiClass2 = psiClass;
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return;
        }
        String qName = string;
        List list = FormClassIndex.findFormsBoundToClass((Project)project2, (String)qName);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFormsBoundToClass(...)");
        PsiFile psiFile2 = (PsiFile)CollectionsKt.singleOrNull((List)list);
        if (psiFile2 == null) {
            ConvertFormToDslAction $this$actionPerformed_u24lambda_u241 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{qName};
            HintManager.getInstance().showErrorHint(editor2, DevKitUIDesignerBundle.message("convert.form.hint.class.not.bound.to.form", objectArray));
            return;
        }
        PsiFile formFile = psiFile2;
        ConvertFormToDslActionKt.convertFormToUiDsl(psiClass2, formFile);
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PSI_FILE) instanceof PsiJavaFile && e.getData(CommonDataKeys.EDITOR) != null);
    }
}

