/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.uiDesigner.ComponentBinding;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormDialog;
import org.jetbrains.idea.devkit.uiDesigner.FormCall;
import org.jetbrains.idea.devkit.uiDesigner.FormToDslConverter;
import org.jetbrains.idea.devkit.uiDesigner.UiForm;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a\u001f\u0010\u001f\u001a\u00020\u0001*\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0000\u00a2\u0006\u0002\u0010\"\u001a\u001f\u0010#\u001a\u00020$*\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0002\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"convertFormToUiDsl", "", "boundClass", "Lcom/intellij/psi/PsiClass;", "formFile", "Lcom/intellij/psi/PsiFile;", "findBoundInstanceUClass", "Lorg/jetbrains/uast/UClass;", "project", "Lcom/intellij/openapi/project/Project;", "boundInstanceType", "", "convertRootContainer", "Lorg/jetbrains/idea/devkit/uiDesigner/UiForm;", "module", "Lcom/intellij/openapi/module/Module;", "rootContainer", "Lcom/intellij/uiDesigner/lw/LwRootContainer;", "boundInstanceUClass", "generateOptionDescriptors", "call", "Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;", "optionDescriptors", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "buildTypeParametersString", "className", "getPropertyValue", "", "Lcom/intellij/uiDesigner/lw/IComponent;", "name", "checkConvertButtonGroup", "ids", "", "(Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;[Ljava/lang/String;)V", "isRadioButtonRow", "", "(Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;[Ljava/lang/String;)Z", "intellij.devkit.uiDesigner"})
@SourceDebugExtension(value={"SMAP\nConvertFormToDslAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFormToDslAction.kt\norg/jetbrains/idea/devkit/uiDesigner/ConvertFormToDslActionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,482:1\n1#2:483\n1755#3,3:484\n360#3,7:487\n388#3,7:494\n*S KotlinDebug\n*F\n+ 1 ConvertFormToDslAction.kt\norg/jetbrains/idea/devkit/uiDesigner/ConvertFormToDslActionKt\n*L\n461#1:484,3\n462#1:487,7\n463#1:494,7\n*E\n"})
public final class ConvertFormToDslActionKt {
    public static final void convertFormToUiDsl(@NotNull PsiClass boundClass, @NotNull PsiFile formFile) {
        StringBuilder stringBuilder;
        String string;
        Intrinsics.checkNotNullParameter((Object)boundClass, (String)"boundClass");
        Intrinsics.checkNotNullParameter((Object)formFile, (String)"formFile");
        Project project = boundClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = boundClass.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        PsiJavaFile psiFile2 = (PsiJavaFile)psiFile;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        ConvertFormDialog dialog = new ConvertFormDialog(project2, boundClass.getName() + "Ui");
        if (!dialog.showAndGet()) {
            return;
        }
        UClass boundInstanceUClass = ConvertFormToDslActionKt.findBoundInstanceUClass(project2, dialog.getBoundInstanceType());
        LwRootContainer rootContainer = Utils.getRootContainer((String)formFile.getText(), (PropertiesProvider)((PropertiesProvider)new PsiPropertiesProvider(module2)));
        Intrinsics.checkNotNull((Object)rootContainer);
        UiForm form = ConvertFormToDslActionKt.convertRootContainer(module2, rootContainer, boundInstanceUClass);
        LinkedHashSet<String> imports = new LinkedHashSet<String>(form.getImports());
        Object object = boundInstanceUClass;
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object it = object;
            boolean bl = false;
            imports.add((String)it);
        }
        if (dialog.getGenerateDescriptors()) {
            imports.add("com.intellij.application.options.editor.*");
        }
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            imports.add("com.intellij.openapi.options.BoundConfigurable");
            imports.add("com.intellij.openapi.ui.DialogPanel");
        }
        if (dialog.getGenerateDescriptors()) {
            StringBuilder stringBuilder2;
            StringBuilder $this$convertFormToUiDsl_u24lambda_u241 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            ConvertFormToDslActionKt.generateOptionDescriptors(form.getRoot(), $this$convertFormToUiDsl_u24lambda_u241);
            String string2 = stringBuilder2.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = "";
        }
        String optionDescriptors = string;
        String uiName = dialog.getClassName();
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension("kt");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType ktFileType = fileType;
        StringBuilder $this$convertFormToUiDsl_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string3 = psiFile2.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPackageName(...)");
        if (((CharSequence)string3).length() > 0) {
            $this$convertFormToUiDsl_u24lambda_u242.append("package " + psiFile2.getPackageName() + "\n\n");
        }
        $this$convertFormToUiDsl_u24lambda_u242.append("import com.intellij.ui.layout.*\n");
        Iterator iterator = imports.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String usedImport = (String)iterator2.next();
            $this$convertFormToUiDsl_u24lambda_u242.append("import " + usedImport + "\n");
        }
        $this$convertFormToUiDsl_u24lambda_u242.append("\n");
        if (((CharSequence)optionDescriptors).length() > 0) {
            $this$convertFormToUiDsl_u24lambda_u242.append("private val model = " + dialog.getBoundInstanceExpression());
            $this$convertFormToUiDsl_u24lambda_u242.append(optionDescriptors);
            $this$convertFormToUiDsl_u24lambda_u242.append("\n");
        }
        $this$convertFormToUiDsl_u24lambda_u242.append("class " + uiName);
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            $this$convertFormToUiDsl_u24lambda_u242.append(" : BoundConfigurable(TODO(), TODO())");
        } else if (boundInstanceUClass != null) {
            $this$convertFormToUiDsl_u24lambda_u242.append("(val model: " + StringsKt.substringAfterLast$default((String)dialog.getBoundInstanceType(), (char)'.', null, (int)2, null) + ")");
        }
        $this$convertFormToUiDsl_u24lambda_u242.append(" {");
        for (ComponentBinding binding : form.getComponentBindings()) {
            String typeParameters = ConvertFormToDslActionKt.buildTypeParametersString(module2, binding.getType());
            $this$convertFormToUiDsl_u24lambda_u242.append("lateinit var " + binding.getName() + ": " + StringsKt.substringAfterLast$default((String)binding.getType(), (char)'.', null, (int)2, null) + typeParameters + "\n");
        }
        if (dialog.getBaseClass() == ConvertFormDialog.FormBaseClass.Configurable) {
            $this$convertFormToUiDsl_u24lambda_u242.append("override fun createPanel(): DialogPanel {\n");
            if (((CharSequence)dialog.getBoundInstanceExpression()).length() > 0) {
                $this$convertFormToUiDsl_u24lambda_u242.append("val model = " + dialog.getBoundInstanceExpression() + "\n");
            } else if (boundInstanceUClass != null) {
                $this$convertFormToUiDsl_u24lambda_u242.append("val model: " + StringsKt.substringAfterLast$default((String)dialog.getBoundInstanceType(), (char)'.', null, (int)2, null) + " = TODO()\n");
            }
            $this$convertFormToUiDsl_u24lambda_u242.append("return panel {\n");
            form.getRoot().render($this$convertFormToUiDsl_u24lambda_u242);
            v9 = $this$convertFormToUiDsl_u24lambda_u242.append("}\n");
        } else {
            $this$convertFormToUiDsl_u24lambda_u242.append("val panel = panel {\n");
            form.getRoot().render($this$convertFormToUiDsl_u24lambda_u242);
            v9 = $this$convertFormToUiDsl_u24lambda_u242.append("}\n");
        }
        $this$convertFormToUiDsl_u24lambda_u242.append("}");
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String ktFileText = string4;
        PsiFile psiFile3 = PsiFileFactory.getInstance((Project)project2).createFileFromText(uiName + ".kt", ktFileType, (CharSequence)ktFileText);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"createFileFromText(...)");
        PsiFile ktFile = psiFile3;
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> ConvertFormToDslActionKt.convertFormToUiDsl$lambda$3(psiFile2, ktFile, project2));
    }

    private static final UClass findBoundInstanceUClass(Project project, String boundInstanceType) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(boundInstanceType, ProjectScope.getAllScope((Project)project));
        if (psiClass == null) {
            return null;
        }
        return (UClass)UastContextKt.toUElement((PsiElement)psiClass.getNavigationElement(), UClass.class);
    }

    private static final UiForm convertRootContainer(Module module, LwRootContainer rootContainer, UClass boundInstanceUClass) {
        FormCall call = new FormToDslConverter(module, boundInstanceUClass).convertContainer((LwContainer)rootContainer);
        Iterator iterator = ArrayIteratorKt.iterator((Object[])rootContainer.getButtonGroups());
        while (iterator.hasNext()) {
            IButtonGroup buttonGroup = (IButtonGroup)iterator.next();
            String[] stringArray = buttonGroup.getComponentIds();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getComponentIds(...)");
            ConvertFormToDslActionKt.checkConvertButtonGroup(call, stringArray);
        }
        return new UiForm(module, call);
    }

    private static final void generateOptionDescriptors(FormCall call, StringBuilder optionDescriptors) {
        String propertyName = call.getBinding();
        int size = call.getArgs().size();
        if (Intrinsics.areEqual((Object)call.getCallee(), (Object)"checkBox") && propertyName != null && size >= 1) {
            optionDescriptors.append("val " + propertyName + " = CheckboxDescriptor(" + call.getArgs().get(0) + ", ");
            String propertyBindingArg = switch (size) {
                case 1 -> "TODO()";
                case 2 -> call.getArgs().get(1) + ".toBinding()";
                default -> "PropertyBinding(" + call.getArgs().get(1) + ", " + call.getArgs().get(2) + ")";
            };
            optionDescriptors.append(propertyBindingArg).append(")\n");
            call.getArgs().clear();
            call.getArgs().add(propertyName);
        }
        for (FormCall content : call.getContents()) {
            ConvertFormToDslActionKt.generateOptionDescriptors(content, optionDescriptors);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String buildTypeParametersString(Module module, String className) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass componentClass = javaPsiFacade.findClass(className, module.getModuleWithDependenciesScope());
        if (componentClass == null) return "";
        PsiTypeParameter[] psiTypeParameterArray = componentClass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        if (((Object[])psiTypeParameterArray).length == 0) {
            return "";
        }
        boolean bl = false;
        if (bl) return "";
        boolean bl2 = true;
        if (!bl2) return "";
        int n = 0;
        int n2 = componentClass.getTypeParameters().length;
        Object[] objectArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = "Any";
        }
        String string = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, null, (int)56, null);
        return string;
    }

    private static final Object getPropertyValue(IComponent $this$getPropertyValue, String name) {
        Object object;
        block2: {
            IProperty[] iPropertyArray = $this$getPropertyValue.getModifiedProperties();
            Intrinsics.checkNotNullExpressionValue((Object)iPropertyArray, (String)"getModifiedProperties(...)");
            for (Object object2 : (Object[])iPropertyArray) {
                IProperty it = (IProperty)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        IProperty iProperty = (IProperty)object;
        if (iProperty == null) {
            return null;
        }
        IProperty prop = iProperty;
        return prop.getPropertyValue($this$getPropertyValue);
    }

    public static final void checkConvertButtonGroup(@NotNull FormCall $this$checkConvertButtonGroup, @NotNull String[] ids) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$checkConvertButtonGroup, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Iterable $this$any$iv = $this$checkConvertButtonGroup.getContents();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FormCall it = (FormCall)element$iv;
                    boolean bl2 = false;
                    if (!ConvertFormToDslActionKt.isRadioButtonRow(it, ids)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            int n;
            int firstIndex;
            block10: {
                int n2;
                block9: {
                    List<FormCall> $this$indexOfFirst$iv = $this$checkConvertButtonGroup.getContents();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object e : $this$indexOfFirst$iv) {
                        FormCall it = (FormCall)e;
                        boolean bl3 = false;
                        if (ConvertFormToDslActionKt.isRadioButtonRow(it, ids)) {
                            n2 = index$iv;
                            break block9;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                firstIndex = n2;
                List<FormCall> $this$indexOfLast$iv = $this$checkConvertButtonGroup.getContents();
                boolean $i$f$indexOfLast = false;
                ListIterator<FormCall> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FormCall formCall = iterator$iv.previous();
                    boolean bl4 = false;
                    if (!ConvertFormToDslActionKt.isRadioButtonRow(formCall, ids)) continue;
                    n = iterator$iv.nextIndex();
                    break block10;
                }
                n = -1;
            }
            int lastIndex = n;
            FormCall buttonGroupNode = new FormCall("buttonGroup", null, null, null, null, null, false, 126, null);
            List<FormCall> buttonGroupControls = $this$checkConvertButtonGroup.getContents().subList(firstIndex, lastIndex + 1);
            buttonGroupNode.getContents().addAll((Collection<FormCall>)buttonGroupControls);
            $this$checkConvertButtonGroup.getContents().removeAll((Collection)buttonGroupControls);
            $this$checkConvertButtonGroup.getContents().add(firstIndex, buttonGroupNode);
            return;
        }
        for (FormCall content : $this$checkConvertButtonGroup.getContents()) {
            ConvertFormToDslActionKt.checkConvertButtonGroup(content, ids);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRadioButtonRow(FormCall $this$isRadioButtonRow, String[] ids) {
        if (!Intrinsics.areEqual((Object)$this$isRadioButtonRow.getCallee(), (Object)"row")) return false;
        FormCall formCall = (FormCall)CollectionsKt.singleOrNull($this$isRadioButtonRow.getContents());
        Object object = formCall;
        if (formCall == null) return false;
        IComponent iComponent = ((FormCall)object).getOrigin();
        object = iComponent;
        if (iComponent == null) return false;
        String string = object.getId();
        object = string;
        if (string == null) return false;
        Object it = object;
        boolean bl = false;
        if (!ArraysKt.contains((Object[])ids, (Object)it)) return false;
        return true;
    }

    private static final void convertFormToUiDsl$lambda$3(PsiJavaFile $psiFile, PsiFile $ktFile, Project $project) {
        PsiElement psiElement = $psiFile.getContainingDirectory().add((PsiElement)$ktFile);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        PsiFile ktFileReal = (PsiFile)psiElement;
        CodeStyleManager.getInstance((Project)$project).reformat((PsiElement)ktFileReal);
        ktFileReal.navigate(true);
    }

    public static final /* synthetic */ String access$buildTypeParametersString(Module module, String className) {
        return ConvertFormToDslActionKt.buildTypeParametersString(module, className);
    }

    public static final /* synthetic */ Object access$getPropertyValue(IComponent $receiver, String name) {
        return ConvertFormToDslActionKt.getPropertyValue($receiver, name);
    }
}

