/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\tH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f0\u0007\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018\u00b2\u0006\u0012\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/idea/devkit/util/ExtensionByExtensionPointLocator;", "Lorg/jetbrains/idea/devkit/util/ExtensionLocator;", "project", "Lcom/intellij/openapi/project/Project;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "extensionId", "", "extensionIdFunction", "Lkotlin/Function1;", "Lorg/jetbrains/idea/devkit/dom/Extension;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "pointQualifiedName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "processCandidates", "", "processor", "Lcom/intellij/psi/xml/XmlTag;", "", "findCandidates", "", "Lorg/jetbrains/idea/devkit/util/ExtensionCandidate;", "intellij.devkit.core", "smartPointerManager", "Lcom/intellij/psi/SmartPointerManager;", "kotlin.jvm.PlatformType"})
public final class ExtensionByExtensionPointLocator
extends ExtensionLocator {
    @NotNull
    private final Project project;
    @Nullable
    private final String extensionId;
    @NotNull
    private final Function1<Extension, String> extensionIdFunction;
    @NotNull
    private final String pointQualifiedName;

    public ExtensionByExtensionPointLocator(@NotNull Project project, @NotNull ExtensionPoint extensionPoint, @Nullable String extensionId, @NotNull Function1<? super Extension, String> extensionIdFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter(extensionIdFunction, (String)"extensionIdFunction");
        super(null);
        this.project = project;
        this.extensionId = extensionId;
        this.extensionIdFunction = extensionIdFunction;
        String string = extensionPoint.getEffectiveQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEffectiveQualifiedName(...)");
        this.pointQualifiedName = string;
    }

    public /* synthetic */ ExtensionByExtensionPointLocator(Project project, ExtensionPoint extensionPoint, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = ExtensionByExtensionPointLocator::_init_$lambda$0;
        }
        this(project, extensionPoint, string, (Function1<? super Extension, String>)function1);
    }

    private final void processCandidates(Function1<? super XmlTag, Boolean> processor) {
        boolean strictMatch = false;
        String searchText = null;
        if (this.extensionId != null) {
            searchText = this.extensionId;
            strictMatch = true;
        } else {
            String string = StringUtil.substringAfterLast((String)this.pointQualifiedName, (String)".");
            if (string == null) {
                return;
            }
            searchText = string;
            strictMatch = false;
        }
        ExtensionLocatorKt.processExtensionDeclarations(searchText, this.project, strictMatch, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)(arg_0, arg_1) -> ExtensionByExtensionPointLocator.processCandidates$lambda$1(this, processor, arg_0, arg_1)));
    }

    @Override
    @NotNull
    public List<ExtensionCandidate> findCandidates() {
        List<ExtensionCandidate> result = Collections.synchronizedList((List)new SmartList());
        Lazy smartPointerManager$delegate = LazyKt.lazy(() -> ExtensionByExtensionPointLocator.findCandidates$lambda$2(this));
        this.processCandidates((Function1<? super XmlTag, Boolean>)((Function1)arg_0 -> ExtensionByExtensionPointLocator.findCandidates$lambda$4(result, smartPointerManager$delegate, arg_0)));
        Intrinsics.checkNotNull(result);
        return result;
    }

    private static final String _init_$lambda$0(Extension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return extension.getId().getStringValue();
    }

    private static final boolean processCandidates$lambda$1(ExtensionByExtensionPointLocator this$0, Function1 $processor, Extension extension, XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return true;
        }
        ExtensionPoint ep = extensionPoint;
        return Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)this$0.pointQualifiedName) && (this$0.extensionId == null || Intrinsics.areEqual((Object)this$0.extensionId, (Object)this$0.extensionIdFunction.invoke((Object)extension))) ? ((Boolean)$processor.invoke((Object)tag)).booleanValue() && this$0.extensionId == null : true;
    }

    private static final SmartPointerManager findCandidates$lambda$2(ExtensionByExtensionPointLocator this$0) {
        return SmartPointerManager.getInstance((Project)this$0.project);
    }

    private static final SmartPointerManager findCandidates$lambda$3(Lazy<? extends SmartPointerManager> $smartPointerManager$delegate) {
        Lazy<? extends SmartPointerManager> lazy = $smartPointerManager$delegate;
        return (SmartPointerManager)lazy.getValue();
    }

    private static final boolean findCandidates$lambda$4(List $result, Lazy $smartPointerManager$delegate, XmlTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)ExtensionByExtensionPointLocator.findCandidates$lambda$3((Lazy<? extends SmartPointerManager>)$smartPointerManager$delegate).createSmartPsiElementPointer((PsiElement)it)));
    }
}

