/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.api.services.cloudresourcemanager.v3.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.v3.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.v3.model.TestIamPermissionsResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.directaccess.CloudClientService;
import com.google.gct.directaccess.CloudProjectEntry;
import com.google.gct.directaccess.DirectAccessPermissionStatusKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000e2\u00020\u0001:\u0006\t\n\u000b\f\r\u000eB\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "getMissingPermissions", "()Ljava/util/Set;", "Unknown", "MissingServiceUse", "None", "Viewer", "Full", "Companion", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Full;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$MissingServiceUse;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$None;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Unknown;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Viewer;", "directaccess"})
@StabilityInferred(parameters=0)
public abstract class DirectAccessPermissionStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> missingPermissions;
    public static final int $stable = 8;

    private DirectAccessPermissionStatus(Set<String> missingPermissions) {
        this.missingPermissions = missingPermissions;
    }

    @NotNull
    public final Set<String> getMissingPermissions() {
        return this.missingPermissions;
    }

    public /* synthetic */ DirectAccessPermissionStatus(Set missingPermissions, DefaultConstructorMarker $constructor_marker) {
        this(missingPermissions);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0001\u00a2\u0006\u0002\b\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Companion;", "", "<init>", "()V", "parseFrom", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "permissions", "", "", "parseFrom$directaccess", "getTestIamPermissionsResponse", "Lcom/google/api/services/cloudresourcemanager/v3/model/TestIamPermissionsResponse;", "cloudProject", "Lcom/google/gct/directaccess/CloudProjectEntry;", "applyUserProject", "", "checkDirectAccessPermission", "directaccess"})
    @SourceDebugExtension(value={"SMAP\nDirectAccessPermissionStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessPermissionStatus.kt\ncom/google/gct/directaccess/DirectAccessPermissionStatus$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n1#2:127\n40#3,3:128\n24#4:131\n24#4:132\n*S KotlinDebug\n*F\n+ 1 DirectAccessPermissionStatus.kt\ncom/google/gct/directaccess/DirectAccessPermissionStatus$Companion\n*L\n94#1:128,3\n108#1:131\n114#1:132\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final DirectAccessPermissionStatus parseFrom$directaccess(@NotNull Set<String> permissions) {
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            if (permissions.isEmpty()) {
                return new None(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET());
            }
            Set missingPermissions = SetsKt.minus(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET(), (Iterable)permissions);
            return missingPermissions.isEmpty() ? (DirectAccessPermissionStatus)new Full() : (missingPermissions.contains("serviceusage.services.use") ? (DirectAccessPermissionStatus)new MissingServiceUse(missingPermissions) : (missingPermissions.containsAll((Collection)DirectAccessPermissionStatusKt.getADMIN_PERMISSION_SET()) ? (DirectAccessPermissionStatus)new None(missingPermissions) : (permissions.containsAll((Collection)DirectAccessPermissionStatusKt.getVIEWER_PERMISSIONS_SET()) ? (DirectAccessPermissionStatus)new Viewer(missingPermissions) : (DirectAccessPermissionStatus)new Unknown(missingPermissions))));
        }

        private final TestIamPermissionsResponse getTestIamPermissionsResponse(CloudProjectEntry cloudProject, boolean applyUserProject) {
            CloudResourceManager.Projects.TestIamPermissions testIamPermissions;
            TestIamPermissionsRequest testIamPermissionsRequest;
            TestIamPermissionsRequest $this$getTestIamPermissionsResponse_u24lambda_u240 = testIamPermissionsRequest = new TestIamPermissionsRequest();
            boolean bl = false;
            $this$getTestIamPermissionsResponse_u24lambda_u240.setPermissions(CollectionsKt.toList((Iterable)DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET()));
            TestIamPermissionsRequest request = testIamPermissionsRequest;
            boolean $i$f$service = false;
            Class<CloudClientService> serviceClass$iv = CloudClientService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            CloudResourceManager.Projects.TestIamPermissions $this$getTestIamPermissionsResponse_u24lambda_u241 = testIamPermissions = ((CloudClientService)object).getClient().getCloudResourceManager().projects().testIamPermissions("projects/" + cloudProject.getName(), request);
            boolean bl2 = false;
            if (applyUserProject) {
                $this$getTestIamPermissionsResponse_u24lambda_u241.getRequestHeaders().set("X-Goog-User-Project", (Object)cloudProject.getName());
            }
            Object object2 = testIamPermissions.execute();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"execute(...)");
            return (TestIamPermissionsResponse)object2;
        }

        @NotNull
        public final DirectAccessPermissionStatus checkDirectAccessPermission(@NotNull CloudProjectEntry cloudProject) {
            TestIamPermissionsResponse response;
            List list;
            TestIamPermissionsResponse testIamPermissionsResponse;
            boolean $i$f$thisLogger;
            Companion $this$thisLogger$iv;
            TestIamPermissionsResponse testIamPermissionsResponse2;
            Intrinsics.checkNotNullParameter((Object)cloudProject, (String)"cloudProject");
            try {
                testIamPermissionsResponse2 = this.getTestIamPermissionsResponse(cloudProject, true);
            }
            catch (IOException e) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cloud Resource Manager API may not be enabled.", (Throwable)e);
                testIamPermissionsResponse2 = null;
            }
            if ((testIamPermissionsResponse = testIamPermissionsResponse2) == null) {
                try {
                    testIamPermissionsResponse2 = this.getTestIamPermissionsResponse(cloudProject, false);
                }
                catch (IOException e) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Could not fetch permissions for user " + cloudProject.getUser() + " for project " + cloudProject.getName() + ": " + e.getMessage());
                    return new None(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET());
                }
                testIamPermissionsResponse = testIamPermissionsResponse2;
            }
            if ((list = (response = testIamPermissionsResponse).getPermissions()) == null) {
                list = CollectionsKt.emptyList();
            }
            List permissions = list;
            return this.parseFrom$directaccess(CollectionsKt.toSet((Iterable)permissions));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Full;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "<init>", "()V", "directaccess"})
    @StabilityInferred(parameters=1)
    public static final class Full
    extends DirectAccessPermissionStatus {
        public static final int $stable;

        public Full() {
            super(SetsKt.emptySet(), null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$MissingServiceUse;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=1)
    public static final class MissingServiceUse
    extends DirectAccessPermissionStatus {
        public static final int $stable;

        public MissingServiceUse(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$None;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=1)
    public static final class None
    extends DirectAccessPermissionStatus {
        public static final int $stable;

        public None(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Unknown;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=1)
    public static final class Unknown
    extends DirectAccessPermissionStatus {
        public static final int $stable;

        public Unknown(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Viewer;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=1)
    public static final class Viewer
    extends DirectAccessPermissionStatus {
        public static final int $stable;

        public Viewer(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }
}

