/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gct.directaccess.CloudProjectEntry;
import com.google.gct.directaccess.DirectAccessApplicationService;
import com.google.gct.directaccess.DirectAccessCloudProjectManager;
import com.google.gct.directaccess.DirectAccessPersistentStateComponent;
import com.google.gct.directaccess.DirectAccessPersistentStateComponentKt;
import com.google.gct.directaccess.PersistentDeviceSelectionData;
import com.google.gct.directaccess.provisioner.DeviceSelection;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.services.firebase.FirebaseLoginFeature;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001fH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lcom/google/gct/directaccess/DirectAccessService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "_cloudProjectManager", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/gct/directaccess/DirectAccessCloudProjectManager;", "cloudProjectManager", "Lkotlinx/coroutines/flow/StateFlow;", "getCloudProjectManager", "()Lkotlinx/coroutines/flow/StateFlow;", "deviceSelectionListFlow", "", "Lcom/google/gct/directaccess/provisioner/DeviceSelection;", "getDeviceSelectionListFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "value", "", "isProjectClosing", "()Z", "selectCloudProject", "", "cloudProject", "", "maybeApplyDefaultDevices", "dispose", "getCloudProject", "Lcom/google/gct/directaccess/CloudProjectEntry;", "name", "directaccess"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDirectAccessService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessService.kt\ncom/google/gct/directaccess/DirectAccessService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,134:1\n31#2,2:135\n31#2,2:141\n31#2,2:146\n1557#3:137\n1628#3,3:138\n1755#3,3:151\n1557#3:154\n1628#3,3:155\n40#4,3:143\n40#4,3:160\n226#5,3:148\n229#5,2:158\n*S KotlinDebug\n*F\n+ 1 DirectAccessService.kt\ncom/google/gct/directaccess/DirectAccessService\n*L\n44#1:135,2\n62#1:141,2\n73#1:146,2\n44#1:137\n44#1:138,3\n78#1:151,3\n79#1:154\n79#1:155,3\n68#1:143,3\n127#1:160,3\n77#1:148,3\n77#1:158,2\n*E\n"})
public final class DirectAccessService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<DirectAccessCloudProjectManager> _cloudProjectManager;
    @NotNull
    private final StateFlow<DirectAccessCloudProjectManager> cloudProjectManager;
    @NotNull
    private final MutableStateFlow<List<DeviceSelection>> deviceSelectionListFlow;
    @NotNull
    private final MessageBusConnection messageBusConnection;
    private boolean isProjectClosing;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DirectAccessService(@NotNull Project project, @NotNull CoroutineScope scope) {
        void $this$_init__u24lambda_u244;
        MessageBusConnection messageBusConnection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this._cloudProjectManager = StateFlowKt.MutableStateFlow(null);
        this.cloudProjectManager = (StateFlow)this._cloudProjectManager;
        Object $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DirectAccessPersistentStateComponent> serviceClass$iv = DirectAccessPersistentStateComponent.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        $this$service$iv = ((DirectAccessPersistentStateComponent)((Object)object)).getCompatibleDeviceSelectionList();
        DirectAccessService directAccessService = this;
        boolean $i$f$map22 = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PersistentDeviceSelectionData persistentDeviceSelectionData = (PersistentDeviceSelectionData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createDeviceSelection());
        }
        directAccessService.deviceSelectionListFlow = StateFlowKt.MutableStateFlow((Object)((List)destination$iv$iv));
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DirectAccessService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean $i$f$service = false;
                        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
                        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        GoogleLoginService loginService = (GoogleLoginService)object3;
                        this.label = 1;
                        Object object4 = loginService.getActiveUserFlow().collect(new FlowCollector(){

                            public final Object emit(CredentialedUser it, Continuation<? super Unit> $completion) {
                                boolean bl;
                                CredentialedUser credentialedUser = it;
                                if (credentialedUser != null) {
                                    LoginFeature.Companion this_$iv = LoginFeature.Companion;
                                    boolean $i$f$feature = false;
                                    LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
                                    if (loginFeature == null) {
                                        throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
                                    }
                                    bl = credentialedUser.isLoggedIn(loginFeature);
                                } else {
                                    bl = false;
                                }
                                if (bl) {
                                    ComponentManager $this$service$iv = (ComponentManager)this$0.getProject();
                                    boolean $i$f$service = false;
                                    Class<DirectAccessPersistentStateComponent> serviceClass$iv = DirectAccessPersistentStateComponent.class;
                                    Object object = $this$service$iv.getService(serviceClass$iv);
                                    if (object == null) {
                                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                    }
                                    this$0.selectCloudProject(((DirectAccessPersistentStateComponent)((Object)object)).getCompatibleSelectedCloudProject());
                                } else {
                                    this$0.selectCloudProject(null);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object4 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DirectAccessService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getDeviceSelectionListFlow().collect(new FlowCollector(){

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(List<DeviceSelection> deviceSelectionList, Continuation<? super Unit> $completion) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Object $this$service$iv = (ComponentManager)this$0.getProject();
                                boolean $i$f$service = false;
                                Class<DirectAccessPersistentStateComponent> serviceClass$iv = DirectAccessPersistentStateComponent.class;
                                Object object = $this$service$iv.getService(serviceClass$iv);
                                if (object == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                $this$service$iv = deviceSelectionList;
                                DirectAccessPersistentStateComponent.State state = (DirectAccessPersistentStateComponent.State)((DirectAccessPersistentStateComponent)((Object)object)).getState();
                                boolean $i$f$map = false;
                                serviceClass$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    DeviceSelection deviceSelection = (DeviceSelection)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(DirectAccessPersistentStateComponentKt.toPersistentDeviceSelectionData((DeviceSelection)it));
                                }
                                state.setDeviceSelectionList(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        MessageBusConnection $i$f$map22 = messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        directAccessService = this;
        boolean bl = false;
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        $this$_init__u24lambda_u244.subscribe(topic, (Object)new ProjectManagerListener(this){
            final /* synthetic */ DirectAccessService this$0;
            {
                this.this$0 = $receiver;
            }

            public void projectClosing(Project closingProject) {
                Intrinsics.checkNotNullParameter((Object)closingProject, (String)"closingProject");
                if (!Intrinsics.areEqual((Object)closingProject, (Object)this.this$0.getProject())) {
                    return;
                }
                DirectAccessService.access$setProjectClosing$p(this.this$0, true);
            }
        });
        directAccessService.messageBusConnection = messageBusConnection;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final StateFlow<DirectAccessCloudProjectManager> getCloudProjectManager() {
        return this.cloudProjectManager;
    }

    @NotNull
    public final MutableStateFlow<List<DeviceSelection>> getDeviceSelectionListFlow() {
        return this.deviceSelectionListFlow;
    }

    public final boolean isProjectClosing() {
        return this.isProjectClosing;
    }

    public final synchronized void selectCloudProject(@Nullable String cloudProject) {
        CloudProjectEntry cloudProjectEntry;
        String string = cloudProject;
        if (string == null || Intrinsics.areEqual((Object)string, (Object)"")) {
            cloudProjectEntry = null;
        } else {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<DirectAccessPersistentStateComponent> serviceClass$iv = DirectAccessPersistentStateComponent.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DirectAccessPersistentStateComponent.State)((DirectAccessPersistentStateComponent)((Object)object)).getState()).setSelectedCloudProject(cloudProject);
            cloudProjectEntry = this.getCloudProject(cloudProject);
        }
        CloudProjectEntry cloudProjectEntry2 = cloudProjectEntry;
        boolean $i$f$service = false;
        Class<DirectAccessApplicationService> serviceClass$iv = DirectAccessApplicationService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this._cloudProjectManager.setValue((Object)((DirectAccessApplicationService)object).registerCloudProject(this.project, cloudProjectEntry2));
    }

    /*
     * WARNING - void declaration
     */
    public final void maybeApplyDefaultDevices() {
        List list;
        List nextValue$iv;
        Object prevValue$iv;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DirectAccessPersistentStateComponent> serviceClass$iv = DirectAccessPersistentStateComponent.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DirectAccessPersistentStateComponent.State state = (DirectAccessPersistentStateComponent.State)((DirectAccessPersistentStateComponent)((Object)object)).getState();
        if (state.getDefaultDeviceApplied()) {
            return;
        }
        state.setDefaultDeviceApplied(true);
        MutableStateFlow<List<DeviceSelection>> $this$update$iv = this.deviceSelectionListFlow;
        boolean $i$f$update = false;
        do {
            void $this$mapTo$iv$iv;
            boolean bl;
            List deviceSelections;
            block8: {
                prevValue$iv = $this$update$iv.getValue();
                deviceSelections = (List)prevValue$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = deviceSelections;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeviceSelection it = (DeviceSelection)element$iv;
                        boolean bl3 = false;
                        if (!it.isSelected()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                list = deviceSelections;
                continue;
            }
            Iterable $this$map$iv = deviceSelections;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DeviceSelection deviceSelection = (DeviceSelection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getDeviceInfo().isDefault() && !it.isSelected() ? DeviceSelection.copy$default((DeviceSelection)it, true, null, 2, null) : it);
            }
            list = (List)destination$iv$iv;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = list)));
    }

    public void dispose() {
        this.messageBusConnection.disconnect();
        this.selectCloudProject(null);
    }

    private final CloudProjectEntry getCloudProject(String name) {
        boolean $i$f$service = false;
        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String string = ((GoogleLoginService)object).getEmail();
        if (string == null) {
            return null;
        }
        String user = string;
        return new CloudProjectEntry(user, name);
    }

    public static final /* synthetic */ void access$setProjectClosing$p(DirectAccessService $this, boolean bl) {
        $this.isProjectClosing = bl;
    }
}

