/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.flags.StudioFlags;
import com.google.gct.directaccess.provisioner.CatalogClient;
import com.google.gct.directaccess.provisioner.DeviceInfo;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.services.firebase.FirebaseLoginFeature;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.util.List;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/google/gct/directaccess/DirectAccessServiceSetup;", "", "<init>", "()V", "channel", "Lio/grpc/ManagedChannel;", "getChannel", "()Lio/grpc/ManagedChannel;", "fetchAccessToken", "", "getAccessibleDeviceInfoList", "", "Lcom/google/gct/directaccess/provisioner/DeviceInfo;", "cloudProject", "directaccess"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDirectAccessServiceSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessServiceSetup.kt\ncom/google/gct/directaccess/DirectAccessServiceSetup\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n*L\n1#1,69:1\n40#2,3:70\n39#3,4:73\n*S KotlinDebug\n*F\n+ 1 DirectAccessServiceSetup.kt\ncom/google/gct/directaccess/DirectAccessServiceSetup\n*L\n57#1:70,3\n57#1:73,4\n*E\n"})
public final class DirectAccessServiceSetup {
    @NotNull
    private final ManagedChannel channel;
    public static final int $stable = 8;

    public DirectAccessServiceSetup() {
        ManagedChannel managedChannel = NettyChannelBuilder.forTarget((String)("dns:///" + StudioFlags.DIRECT_ACCESS_ENDPOINT.get())).sslContext(GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient(), (SslProvider)SslProvider.JDK).trustManager((TrustManager)ConfirmingTrustManager.createForStorage((String)CertificateManager.DEFAULT_PATH, (String)"changeit")).build()).withOption(ChannelOption.TCP_NODELAY, (Object)true).build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        this.channel = managedChannel;
    }

    @NotNull
    public final ManagedChannel getChannel() {
        return this.channel;
    }

    @Nullable
    public final String fetchAccessToken() {
        boolean $i$f$service = false;
        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        return ((GoogleLoginService)object).fetchOAuth2Token(loginFeature);
    }

    @NotNull
    public final List<DeviceInfo> getAccessibleDeviceInfoList(@Nullable String cloudProject) {
        return CatalogClient.INSTANCE.getAvailableDevices("https://" + StudioFlags.DIRECT_ACCESS_ENDPOINT.get() + "/", cloudProject);
    }
}

