/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.google.devtools.testing.v1.AndroidDevice;
import com.google.devtools.testing.v1.CancelDeviceSessionRequest;
import com.google.devtools.testing.v1.CreateDeviceSessionRequest;
import com.google.devtools.testing.v1.DeviceSession;
import com.google.devtools.testing.v1.DirectAccessServiceGrpc;
import com.google.devtools.testing.v1.GetDeviceSessionRequest;
import com.google.devtools.testing.v1.ListDeviceSessionsRequest;
import com.google.devtools.testing.v1.ListDeviceSessionsResponse;
import com.google.devtools.testing.v1.UpdateDeviceSessionRequest;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerImpl;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerKt;
import com.google.services.firebase.directaccess.client.TokenCallCredentials;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0016J\u001f\u0010\u001f\u001a\n \u0010*\u0004\u0018\u00010 0 2\b\b\u0002\u0010!\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016J-\u0010*\u001a\n \u0010*\u0004\u0018\u00010+0+2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J \u00102\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0017042\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u00105\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J8\u00106\u001a\u00020$2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010%\u001a\u00020\u00032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001909H\u0082@\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00032\b\b\u0002\u0010<\u001a\u00020\u0017H\u0002J\b\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl;", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "cloudProjectId", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lio/grpc/Channel;", "oAuthTokenFetcher", "Lkotlin/Function0;", "callCreds", "Lio/grpc/CallCredentials;", "<init>", "(Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lio/grpc/Channel;Lkotlin/jvm/functions/Function0;Lio/grpc/CallCredentials;)V", "directAccessStub", "Lcom/google/devtools/testing/v1/DirectAccessServiceGrpc$DirectAccessServiceBlockingStub;", "kotlin.jvm.PlatformType", "getDirectAccessStub", "()Lcom/google/devtools/testing/v1/DirectAccessServiceGrpc$DirectAccessServiceBlockingStub;", "Lcom/google/devtools/testing/v1/DirectAccessServiceGrpc$DirectAccessServiceBlockingStub;", "reservationFlowMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/devtools/testing/v1/DeviceSession;", "gracePeriodReservationsMap", "", "createReservation", "model", "apiLevel", "listReservations", "", "createListSessionRequest", "Lcom/google/devtools/testing/v1/ListDeviceSessionsRequest;", "nextPageToken", "(Ljava/lang/String;)Lcom/google/devtools/testing/v1/ListDeviceSessionsRequest;", "setGracePeriod", "", "reservationName", "cancelReservationImmediately", "cancelReservation", "withGracePeriod", "", "createUpdateDeviceSessionRequest", "Lcom/google/devtools/testing/v1/UpdateDeviceSessionRequest;", "reservation", "duration", "Ljava/time/Duration;", "type", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager$ReservationExtendType;", "(Lcom/google/devtools/testing/v1/DeviceSession;Ljava/time/Duration;Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager$ReservationExtendType;)Lcom/google/devtools/testing/v1/UpdateDeviceSessionRequest;", "extendReservation", "fetchReservationFlow", "Lkotlinx/coroutines/flow/StateFlow;", "maybeRestoreExpireTimeOnReconnect", "updateReservationUntilClosed", "stateFlow", "nextIterationDelay", "Lkotlin/Function1;", "(Lkotlinx/coroutines/flow/MutableStateFlow;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchReservation", "previousReservation", "metadataInterceptor", "Lio/grpc/ClientInterceptor;", "directaccess-client"})
@SourceDebugExtension(value={"SMAP\nDirectAccessReservationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,420:1\n1#2:421\n226#3,5:422\n194#3,5:427\n*S KotlinDebug\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl\n*L\n327#1:422,5\n383#1:427,5\n*E\n"})
public final class DirectAccessReservationManagerImpl
implements DirectAccessReservationManager {
    @NotNull
    private final String cloudProjectId;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CallCredentials callCreds;
    private final DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessStub;
    @NotNull
    private final ConcurrentHashMap<String, MutableStateFlow<DeviceSession>> reservationFlowMap;
    @NotNull
    private final ConcurrentHashMap<String, Long> gracePeriodReservationsMap;

    public DirectAccessReservationManagerImpl(@NotNull String cloudProjectId, @NotNull CoroutineScope scope, @NotNull Channel channel, @NotNull Function0<String> oAuthTokenFetcher, @NotNull CallCredentials callCreds) {
        Intrinsics.checkNotNullParameter((Object)cloudProjectId, (String)"cloudProjectId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(oAuthTokenFetcher, (String)"oAuthTokenFetcher");
        Intrinsics.checkNotNullParameter((Object)callCreds, (String)"callCreds");
        this.cloudProjectId = cloudProjectId;
        this.scope = scope;
        this.callCreds = callCreds;
        this.directAccessStub = DirectAccessServiceGrpc.newBlockingStub((Channel)channel);
        this.reservationFlowMap = new ConcurrentHashMap();
        this.gracePeriodReservationsMap = new ConcurrentHashMap();
    }

    public /* synthetic */ DirectAccessReservationManagerImpl(String string, CoroutineScope coroutineScope, Channel channel, Function0 function0, CallCredentials callCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            callCredentials = new TokenCallCredentials((Function0<String>)function0);
        }
        this(string, coroutineScope, channel, (Function0<String>)function0, callCredentials);
    }

    private final DirectAccessServiceGrpc.DirectAccessServiceBlockingStub getDirectAccessStub() {
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[]{this.metadataInterceptor()};
        return (DirectAccessServiceGrpc.DirectAccessServiceBlockingStub)((DirectAccessServiceGrpc.DirectAccessServiceBlockingStub)this.directAccessStub.withCallCredentials(this.callCreds)).withInterceptors(clientInterceptorArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DeviceSession createReservation(@NotNull String model, @NotNull String apiLevel) {
        void $this$createReservation_u24lambda_u242_u24lambda_u241_u24lambda_u240;
        void $this$createReservation_u24lambda_u242_u24lambda_u241;
        AndroidDevice.Builder builder;
        DeviceSession.Builder builder2;
        CreateDeviceSessionRequest.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
        CreateDeviceSessionRequest.Builder $this$createReservation_u24lambda_u242 = builder3 = CreateDeviceSessionRequest.newBuilder();
        boolean bl = false;
        $this$createReservation_u24lambda_u242.setParent("projects/" + this.cloudProjectId);
        DeviceSession.Builder builder4 = builder2 = DeviceSession.newBuilder();
        CreateDeviceSessionRequest.Builder builder5 = $this$createReservation_u24lambda_u242;
        boolean bl2 = false;
        AndroidDevice.Builder builder6 = builder = AndroidDevice.newBuilder();
        void var13_12 = $this$createReservation_u24lambda_u242_u24lambda_u241;
        boolean bl3 = false;
        $this$createReservation_u24lambda_u242_u24lambda_u241_u24lambda_u240.setAndroidModelId(model);
        $this$createReservation_u24lambda_u242_u24lambda_u241_u24lambda_u240.setAndroidVersionId(apiLevel);
        var13_12.setAndroidDevice(builder.build());
        builder5.setDeviceSession(builder2.build());
        CreateDeviceSessionRequest createDeviceSessionRequest = builder3.build();
        DeviceSession deviceSession = this.getDirectAccessStub().createDeviceSession(createDeviceSessionRequest);
        Intrinsics.checkNotNullExpressionValue((Object)deviceSession, (String)"createDeviceSession(...)");
        return deviceSession;
    }

    @Override
    @NotNull
    public List<DeviceSession> listReservations() {
        ListDeviceSessionsResponse listReservationResponse;
        List reservationsList = new ArrayList();
        String nextPageToken = "";
        do {
            listReservationResponse = this.getDirectAccessStub().listDeviceSessions(this.createListSessionRequest(nextPageToken));
            List list = listReservationResponse.getDeviceSessionsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDeviceSessionsList(...)");
            reservationsList.addAll(list);
        } while (!StringsKt.isBlank((CharSequence)(nextPageToken = listReservationResponse.getNextPageToken())));
        return reservationsList;
    }

    private final ListDeviceSessionsRequest createListSessionRequest(String nextPageToken) {
        ListDeviceSessionsRequest.Builder builder;
        ListDeviceSessionsRequest.Builder $this$createListSessionRequest_u24lambda_u243 = builder = ListDeviceSessionsRequest.newBuilder();
        boolean bl = false;
        $this$createListSessionRequest_u24lambda_u243.setParent("projects/" + this.cloudProjectId);
        $this$createListSessionRequest_u24lambda_u243.setPageToken(nextPageToken);
        $this$createListSessionRequest_u24lambda_u243.setPageSize(500);
        return builder.build();
    }

    static /* synthetic */ ListDeviceSessionsRequest createListSessionRequest$default(DirectAccessReservationManagerImpl directAccessReservationManagerImpl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return directAccessReservationManagerImpl.createListSessionRequest(string);
    }

    private final void setGracePeriod(String reservationName2) {
        if (!DirectAccessReservationManagerKt.access$getExpiryLessThanGracePeriod(this.fetchReservationFlow(reservationName2))) {
            ((Map)this.gracePeriodReservationsMap).put(reservationName2, ((DeviceSession)this.fetchReservationFlow(reservationName2).getValue()).getExpireTime().getSeconds());
            this.extendReservation(reservationName2, DirectAccessReservationManagerKt.getGRACE_PERIOD_DURATION(), DirectAccessReservationManager.ReservationExtendType.TTL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cancelReservationImmediately(String reservationName2) {
        void $this$cancelReservationImmediately_u24lambda_u244;
        CancelDeviceSessionRequest.Builder builder;
        CancelDeviceSessionRequest.Builder builder2 = builder = CancelDeviceSessionRequest.newBuilder();
        DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessServiceBlockingStub = this.getDirectAccessStub();
        boolean bl = false;
        $this$cancelReservationImmediately_u24lambda_u244.setName(reservationName2);
        directAccessServiceBlockingStub.cancelDeviceSession(builder.build());
        this.gracePeriodReservationsMap.remove(reservationName2);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, reservationName2, null){
            int label;
            final /* synthetic */ DirectAccessReservationManagerImpl this$0;
            final /* synthetic */ String $reservationName;
            {
                this.this$0 = $receiver;
                this.$reservationName = $reservationName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableStateFlow mutableStateFlow = (MutableStateFlow)DirectAccessReservationManagerImpl.access$getReservationFlowMap$p(this.this$0).remove(this.$reservationName);
                        if (mutableStateFlow == null) break;
                        MutableStateFlow mutableStateFlow2 = mutableStateFlow;
                        DirectAccessReservationManagerImpl directAccessReservationManagerImpl = this.this$0;
                        String string = this.$reservationName;
                        MutableStateFlow it = mutableStateFlow2;
                        boolean bl = false;
                        this.label = 1;
                        Object object3 = DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(directAccessReservationManagerImpl, it, string, cancelReservationImmediately.2::invokeSuspend$lambda$1$lambda$0, (Continuation)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final long invokeSuspend$lambda$1$lambda$0(DeviceSession it) {
                return TimeUnit.SECONDS.toMillis(1L);
            }
        }), (int)3, null);
    }

    @Override
    public void cancelReservation(@NotNull String reservationName2, boolean withGracePeriod) {
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        if (withGracePeriod && ((DeviceSession)this.fetchReservationFlow(reservationName2).getValue()).getState() == DeviceSession.SessionState.ACTIVE) {
            this.setGracePeriod(reservationName2);
        } else {
            this.cancelReservationImmediately(reservationName2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateDeviceSessionRequest createUpdateDeviceSessionRequest(DeviceSession reservation, Duration duration, DirectAccessReservationManager.ReservationExtendType type) {
        void $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u248;
        DeviceSession.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247;
        DeviceSession.Builder builder;
        UpdateDeviceSessionRequest.Builder builder2;
        UpdateDeviceSessionRequest.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u249 = builder2 = UpdateDeviceSessionRequest.newBuilder();
        boolean bl = false;
        DeviceSession.Builder builder3 = builder = $this$createUpdateDeviceSessionRequest_u24lambda_u249.getDeviceSessionBuilder();
        UpdateDeviceSessionRequest.Builder builder4 = $this$createUpdateDeviceSessionRequest_u24lambda_u249;
        boolean bl2 = false;
        $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247.setName(reservation.getName());
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                void $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247_u24lambda_u245;
                Timestamp.Builder builder5;
                Timestamp.Builder builder6 = builder5 = $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247.getExpireTimeBuilder();
                void var13_15 = $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247;
                boolean bl3 = false;
                $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247_u24lambda_u245.setSeconds(reservation.getExpireTime().getSeconds() + duration.getSeconds());
                var13_15.setExpireTime(builder5.build());
                break;
            }
            case 2: {
                void $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247_u24lambda_u246;
                Duration.Builder builder7;
                Duration.Builder $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247_u24lambda_u245 = builder7 = $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247.getTtlBuilder();
                void var13_16 = $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247;
                boolean bl4 = false;
                $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247_u24lambda_u246.setSeconds(duration.getSeconds());
                var13_16.setTtl(builder7.build());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        builder4.setDeviceSession(builder.build());
        $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u247 = builder = FieldMask.newBuilder();
        builder4 = $this$createUpdateDeviceSessionRequest_u24lambda_u249;
        boolean bl5 = false;
        $this$createUpdateDeviceSessionRequest_u24lambda_u249_u24lambda_u248.addPaths(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> "expireTime";
            case 2 -> "ttl";
            default -> throw new NoWhenBranchMatchedException();
        });
        builder4.setUpdateMask(builder.build());
        return builder2.build();
    }

    @Override
    public void extendReservation(@NotNull String reservationName2, @NotNull Duration duration, @NotNull DirectAccessReservationManager.ReservationExtendType type) {
        DeviceSession nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        StateFlow<DeviceSession> stateFlow2 = this.fetchReservationFlow(reservationName2);
        DeviceSession extendedReservation = this.getDirectAccessStub().updateDeviceSession(this.createUpdateDeviceSessionRequest((DeviceSession)stateFlow2.getValue(), duration, type));
        Intrinsics.checkNotNull(stateFlow2, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.MutableStateFlow<com.google.devtools.testing.v1.DeviceSession>");
        MutableStateFlow $this$update$iv = (MutableStateFlow)stateFlow2;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            DeviceSession it = (DeviceSession)prevValue$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)extendedReservation);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = extendedReservation)));
    }

    @Override
    @NotNull
    public StateFlow<DeviceSession> fetchReservationFlow(@NotNull String reservationName2) {
        StateFlow stateFlow2;
        Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
        MutableStateFlow<DeviceSession> mutableStateFlow = this.reservationFlowMap.get(reservationName2);
        if (mutableStateFlow != null) {
            stateFlow2 = (StateFlow)mutableStateFlow;
        } else {
            DirectAccessReservationManagerImpl $this$fetchReservationFlow_u24lambda_u2411 = this;
            boolean bl = false;
            MutableStateFlow stateFlow3 = StateFlowKt.MutableStateFlow((Object)DirectAccessReservationManagerImpl.fetchReservation$default($this$fetchReservationFlow_u24lambda_u2411, reservationName2, null, 2, null));
            ((Map)$this$fetchReservationFlow_u24lambda_u2411.reservationFlowMap).put(reservationName2, stateFlow3);
            BuildersKt.launch$default((CoroutineScope)$this$fetchReservationFlow_u24lambda_u2411.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$fetchReservationFlow_u24lambda_u2411, (MutableStateFlow<DeviceSession>)stateFlow3, reservationName2, null){
                int label;
                final /* synthetic */ DirectAccessReservationManagerImpl $this_run;
                final /* synthetic */ MutableStateFlow<DeviceSession> $stateFlow;
                final /* synthetic */ String $reservationName;
                {
                    this.$this_run = $receiver;
                    this.$stateFlow = $stateFlow;
                    this.$reservationName = $reservationName;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(this.$this_run, this.$stateFlow, this.$reservationName, fetchReservationFlow.1.1::invokeSuspend$lambda$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final long invokeSuspend$lambda$0(DeviceSession newReservation2) {
                    long maxDelayTimeMillis = DirectAccessReservationManagerKt.isActive(newReservation2) ? TimeUnit.MINUTES.toMillis(1L) : TimeUnit.SECONDS.toMillis(2L);
                    long availableTimeMillis = TimeUnit.SECONDS.toMillis(newReservation2.getExpireTime().getSeconds()) - System.currentTimeMillis();
                    return RangesKt.coerceIn((long)availableTimeMillis, (long)TimeUnit.SECONDS.toMillis(1L), (long)maxDelayTimeMillis);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)$this$fetchReservationFlow_u24lambda_u2411.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableStateFlow<DeviceSession>)stateFlow3, $this$fetchReservationFlow_u24lambda_u2411, reservationName2, null){
                int label;
                final /* synthetic */ MutableStateFlow<DeviceSession> $stateFlow;
                final /* synthetic */ DirectAccessReservationManagerImpl $this_run;
                final /* synthetic */ String $reservationName;
                {
                    this.$stateFlow = $stateFlow;
                    this.$this_run = $receiver;
                    this.$reservationName = $reservationName;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)this.$stateFlow), (Function2)((Function2)new Function2<DeviceSession, Continuation<? super Boolean>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            DeviceSession it = (DeviceSession)this.L$0;
                                            DeviceSession.SessionState sessionState = it.getState();
                                            Intrinsics.checkNotNullExpressionValue((Object)sessionState, (String)"getState(...)");
                                            return Boxing.boxBoolean((!DirectAccessReservationManagerKt.isClosed(sessionState) ? 1 : 0) != 0);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(DeviceSession p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            DirectAccessReservationManagerImpl.access$getGracePeriodReservationsMap$p(this.$this_run).remove(this.$reservationName);
                            DirectAccessReservationManagerImpl.access$getReservationFlowMap$p(this.$this_run).remove(this.$reservationName);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            stateFlow2 = (StateFlow)stateFlow3;
        }
        return stateFlow2;
    }

    @Override
    public void maybeRestoreExpireTimeOnReconnect(@NotNull String reservationName2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reservationName2, (String)"reservationName");
            Long l = this.gracePeriodReservationsMap.remove(reservationName2);
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            StateFlow<DeviceSession> reservationFlow = this.fetchReservationFlow(reservationName2);
            if (DirectAccessReservationManagerKt.access$getExpiryLessThanGracePeriod(reservationFlow)) {
                Duration duration = Duration.ofSeconds(it - ((DeviceSession)reservationFlow.getValue()).getExpireTime().getSeconds());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
                this.extendReservation(reservationName2, duration, DirectAccessReservationManager.ReservationExtendType.EXTEND);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateReservationUntilClosed(MutableStateFlow<DeviceSession> var1_1, String var2_2, Function1<? super DeviceSession, Long> var3_3, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateReservationUntilClosed.1)) ** GOTO lbl-1000
        var13_5 = $completion;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DirectAccessReservationManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DirectAccessReservationManagerImpl.access$updateReservationUntilClosed(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl13:
                // 2 sources

                while (true) {
                    $this$updateAndGet$iv = stateFlow;
                    $i$f$updateAndGet = false;
                    while (true) {
                        prevValue$iv = $this$updateAndGet$iv.getValue();
                        currentReservation = (DeviceSession)prevValue$iv;
                        $i$a$-updateAndGet-DirectAccessReservationManagerImpl$updateReservationUntilClosed$newReservation$1 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = stateFlow;
                        $continuation.L$2 = reservationName;
                        $continuation.L$3 = nextIterationDelay;
                        $continuation.L$4 = $this$updateAndGet$iv;
                        $continuation.L$5 = prevValue$iv;
                        $continuation.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DeviceSession>, Object>(this, reservationName, currentReservation, null){
                            int label;
                            final /* synthetic */ DirectAccessReservationManagerImpl this$0;
                            final /* synthetic */ String $reservationName;
                            final /* synthetic */ DeviceSession $currentReservation;
                            {
                                this.this$0 = $receiver;
                                this.$reservationName = $reservationName;
                                this.$currentReservation = $currentReservation;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return DirectAccessReservationManagerImpl.access$fetchReservation(this.this$0, this.$reservationName, this.$currentReservation);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super DeviceSession> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v0 != var14_7) continue;
                        return var14_7;
                    }
                    break;
                }
            }
            case 1: {
                $i$f$updateAndGet = false;
                $i$a$-updateAndGet-DirectAccessReservationManagerImpl$updateReservationUntilClosed$newReservation$1 = false;
                prevValue$iv = $continuation.L$5;
                $this$updateAndGet$iv = (MutableStateFlow)$continuation.L$4;
                nextIterationDelay = (Function1)$continuation.L$3;
                reservationName = (String)$continuation.L$2;
                stateFlow = (MutableStateFlow)$continuation.L$1;
                this = (DirectAccessReservationManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                if (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (DeviceSession)v0))) ** continue;
                newReservation = nextValue$iv;
                v1 = newReservation.getState();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getState(...)");
                if (DirectAccessReservationManagerKt.isClosed(v1)) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = stateFlow;
                $continuation.L$2 = reservationName;
                $continuation.L$3 = nextIterationDelay;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.label = 2;
                v2 = DelayKt.delay((long)((Number)nextIterationDelay.invoke((Object)newReservation)).longValue(), (Continuation)$continuation);
                if (v2 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl66
            }
            case 2: {
                nextIterationDelay = (Function1)$continuation.L$3;
                reservationName = (String)$continuation.L$2;
                stateFlow = (MutableStateFlow)$continuation.L$1;
                this = (DirectAccessReservationManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl66:
                // 2 sources

                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final DeviceSession fetchReservation(String reservationName2, DeviceSession previousReservation) {
        GetDeviceSessionRequest.Builder builder;
        try {
            void $this$fetchReservation_u24lambda_u2414;
            GetDeviceSessionRequest.Builder builder2 = builder = GetDeviceSessionRequest.newBuilder();
            DirectAccessServiceGrpc.DirectAccessServiceBlockingStub directAccessServiceBlockingStub = this.getDirectAccessStub();
            boolean bl = false;
            $this$fetchReservation_u24lambda_u2414.setName(reservationName2);
            builder = directAccessServiceBlockingStub.getDeviceSession(builder.build());
        }
        catch (StatusRuntimeException e) {
            DeviceSession.Builder builder3;
            DirectAccessReservationManagerKt.access$getLogger().log(Level.WARNING, "Failed to fetch reservation " + reservationName2, e);
            DeviceSession.Builder $this$fetchReservation_u24lambda_u2415 = builder3 = previousReservation.toBuilder();
            boolean bl = false;
            $this$fetchReservation_u24lambda_u2415.setState(DeviceSession.SessionState.SESSION_STATE_UNSPECIFIED);
            builder = builder3.build();
        }
        return builder;
    }

    static /* synthetic */ DeviceSession fetchReservation$default(DirectAccessReservationManagerImpl directAccessReservationManagerImpl, String string, DeviceSession deviceSession, int n, Object object) {
        if ((n & 2) != 0) {
            deviceSession = DeviceSession.newBuilder().build();
        }
        return directAccessReservationManagerImpl.fetchReservation(string, deviceSession);
    }

    private final ClientInterceptor metadataInterceptor() {
        Metadata metadata;
        Metadata $this$metadataInterceptor_u24lambda_u2416 = metadata = new Metadata();
        boolean bl = false;
        $this$metadataInterceptor_u24lambda_u2416.put(Metadata.Key.of((String)"X-Goog-User-Project", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.cloudProjectId);
        ClientInterceptor clientInterceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata);
        Intrinsics.checkNotNullExpressionValue((Object)clientInterceptor, (String)"newAttachHeadersInterceptor(...)");
        return clientInterceptor;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getReservationFlowMap$p(DirectAccessReservationManagerImpl $this) {
        return $this.reservationFlowMap;
    }

    public static final /* synthetic */ Object access$updateReservationUntilClosed(DirectAccessReservationManagerImpl $this, MutableStateFlow stateFlow2, String reservationName2, Function1 nextIterationDelay, Continuation $completion) {
        return $this.updateReservationUntilClosed((MutableStateFlow<DeviceSession>)stateFlow2, reservationName2, (Function1<? super DeviceSession, Long>)nextIterationDelay, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getGracePeriodReservationsMap$p(DirectAccessReservationManagerImpl $this) {
        return $this.gracePeriodReservationsMap;
    }

    public static final /* synthetic */ DeviceSession access$fetchReservation(DirectAccessReservationManagerImpl $this, String reservationName2, DeviceSession previousReservation) {
        return $this.fetchReservation(reservationName2, previousReservation);
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectAccessReservationManager.ReservationExtendType.values().length];
            try {
                nArray[DirectAccessReservationManager.ReservationExtendType.EXTEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectAccessReservationManager.ReservationExtendType.TTL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

