/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.testing.v1.DeviceSession;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManagerImpl;
import io.grpc.Channel;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\u0018\u0010\u0019\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001b\u001a\u0018\u0010\u001c\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001b\u001a\n\u0010\u001d\u001a\u00020\u0013*\u00020\u001e\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010'\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001e\u0010\u0015\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00140\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"GOOGLE_USER_PROJECT_KEY", "", "GRACE_PERIOD_DURATION", "Ljava/time/Duration;", "getGRACE_PERIOD_DURATION$annotations", "()V", "getGRACE_PERIOD_DURATION", "()Ljava/time/Duration;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "findOrCreateReservation", "Lkotlin/Pair;", "", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManager;", "codename", "api", "isActive", "", "Lcom/google/devtools/testing/v1/DeviceSession;", "expiryLessThanGracePeriod", "Lkotlinx/coroutines/flow/StateFlow;", "getExpiryLessThanGracePeriod", "(Lkotlinx/coroutines/flow/StateFlow;)Z", "waitUntilActive", "", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "takeWhileNotClosed", "isClosed", "Lcom/google/devtools/testing/v1/DeviceSession$SessionState;", "DirectAccessReservationManager", "Lcom/google/services/firebase/directaccess/client/DirectAccessReservationManagerImpl;", "cloudProjectId", "scope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lio/grpc/Channel;", "oAuthTokenFetcher", "Lkotlin/Function0;", "directaccess-client"})
@SourceDebugExtension(value={"SMAP\nDirectAccessReservationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n295#2,2:421\n*S KotlinDebug\n*F\n+ 1 DirectAccessReservationManager.kt\ncom/google/services/firebase/directaccess/client/DirectAccessReservationManagerKt\n*L\n125#1:421,2\n*E\n"})
public final class DirectAccessReservationManagerKt {
    @NotNull
    public static final String GOOGLE_USER_PROJECT_KEY = "X-Goog-User-Project";
    @NotNull
    private static final Duration GRACE_PERIOD_DURATION;

    @NotNull
    public static final Duration getGRACE_PERIOD_DURATION() {
        return GRACE_PERIOD_DURATION;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGRACE_PERIOD_DURATION$annotations() {
    }

    private static final Logger getLogger() {
        Logger logger = Logger.getLogger(Reflection.getOrCreateKotlinClass(DirectAccessReservationManager.class).getQualifiedName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final Pair<String, Long> findOrCreateReservation(@NotNull DirectAccessReservationManager $this$findOrCreateReservation, @NotNull String codename, @NotNull String api) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$findOrCreateReservation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)codename, (String)"codename");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            $this$firstOrNull$iv = $this$findOrCreateReservation.listReservations();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                reservation = (DeviceSession)element$iv;
                $i$a$-firstOrNull-DirectAccessReservationManagerKt$findOrCreateReservation$existingReservation$1 = false;
                v0 = reservation.getState();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getState(...)");
                if (DirectAccessReservationManagerKt.isClosed(v0)) ** GOTO lbl-1000
                it = reservation.getAndroidDevice();
                $i$a$-let-DirectAccessReservationManagerKt$findOrCreateReservation$existingReservation$1$1 = false;
                v1 = Intrinsics.areEqual((Object)it.getAndroidModelId(), (Object)codename) && Intrinsics.areEqual((Object)it.getAndroidVersionId(), (Object)api);
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        existingReservation = v3;
        if (existingReservation != null) {
            it = existingReservation;
            $i$a$-let-DirectAccessReservationManagerKt$findOrCreateReservation$1 = false;
            return new Pair((Object)existingReservation.getName(), (Object)0L);
        }
        startTime = System.currentTimeMillis();
        return new Pair((Object)$this$findOrCreateReservation.createReservation(codename, api).getName(), (Object)startTime);
    }

    public static final boolean isActive(@NotNull DeviceSession $this$isActive) {
        Intrinsics.checkNotNullParameter((Object)$this$isActive, (String)"<this>");
        return $this$isActive.getState() == DeviceSession.SessionState.ACTIVE;
    }

    private static final boolean getExpiryLessThanGracePeriod(StateFlow<DeviceSession> $this$expiryLessThanGracePeriod) {
        return ((DeviceSession)$this$expiryLessThanGracePeriod.getValue()).getExpireTime().getSeconds() <= Instant.now().getEpochSecond() + GRACE_PERIOD_DURATION.getSeconds();
    }

    @Nullable
    public static final Object waitUntilActive(@NotNull StateFlow<DeviceSession> $this$waitUntilActive, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)$this$waitUntilActive), (Function2)((Function2)new Function2<DeviceSession, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        DeviceSession reservation = (DeviceSession)this.L$0;
                        boolean active = bl = DirectAccessReservationManagerKt.isActive(reservation);
                        boolean bl2 = false;
                        DirectAccessReservationManagerKt.access$getLogger().info(active ? reservation.getName() + " is " + reservation.getState() : "Waiting for " + reservation.getName() + " to activate...");
                        return Boxing.boxBoolean((!bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DeviceSession p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object takeWhileNotClosed(@NotNull StateFlow<DeviceSession> $this$takeWhileNotClosed, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)$this$takeWhileNotClosed), (Function2)((Function2)new Function2<DeviceSession, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DeviceSession reservation = (DeviceSession)this.L$0;
                        DeviceSession.SessionState sessionState = reservation.getState();
                        Intrinsics.checkNotNullExpressionValue((Object)sessionState, (String)"getState(...)");
                        return Boxing.boxBoolean((!DirectAccessReservationManagerKt.isClosed(sessionState) ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DeviceSession p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final boolean isClosed(@NotNull DeviceSession.SessionState $this$isClosed) {
        Intrinsics.checkNotNullParameter((Object)$this$isClosed, (String)"<this>");
        return $this$isClosed != DeviceSession.SessionState.ACTIVE && $this$isClosed != DeviceSession.SessionState.PENDING && $this$isClosed != DeviceSession.SessionState.REQUESTED;
    }

    @NotNull
    public static final DirectAccessReservationManagerImpl DirectAccessReservationManager(@NotNull String cloudProjectId, @NotNull CoroutineScope scope, @NotNull Channel channel, @NotNull Function0<String> oAuthTokenFetcher) {
        Intrinsics.checkNotNullParameter((Object)cloudProjectId, (String)"cloudProjectId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(oAuthTokenFetcher, (String)"oAuthTokenFetcher");
        return new DirectAccessReservationManagerImpl(cloudProjectId, scope, channel, oAuthTokenFetcher, null, 16, null);
    }

    public static final /* synthetic */ boolean access$getExpiryLessThanGracePeriod(StateFlow $receiver) {
        return DirectAccessReservationManagerKt.getExpiryLessThanGracePeriod((StateFlow<DeviceSession>)$receiver);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return DirectAccessReservationManagerKt.getLogger();
    }

    static {
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        GRACE_PERIOD_DURATION = duration;
    }
}

