/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.cli;

import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.protobuf.Timestamp;
import com.google.services.firebase.directaccess.client.cli.CredentialsNotFoundException;
import com.google.services.firebase.directaccess.client.cli.DirectAccessCliSettings;
import com.google.services.firebase.directaccess.client.cli.DirectAccessCliSettingsKt;
import com.google.services.firebase.directaccess.client.cli.ShowUsageException;
import com.google.services.firebase.directaccess.client.cli.action.DirectAccessAction;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aN\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0007*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052&\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00070\u0005j\u0002`\n\u001a6\u0010\u000b\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u001e\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e\u0012\u0004\u0012\u00020\u000f0\u0001\u001a\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0011*\u00020\u0006\u001a\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006\u001a\u0006\u0010\u0016\u001a\u00020\u0017\"\u0015\u0010\u0018\u001a\u00020\u0006*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*2\u0010\u0004\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002`\u00070\u00052\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00070\u0005\u00a8\u0006\u001c"}, d2={"ActionMapValue", "Lkotlin/Function1;", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "ActionMap", "", "", "Lcom/google/services/firebase/directaccess/client/cli/ActionMapValue;", "firstArgToAction", "map", "Lcom/google/services/firebase/directaccess/client/cli/ActionMap;", "retainAll", "", "block", "", "", "argToPair", "Lkotlin/Pair;", "fetchAccessTokenForClient", "clientId", "clientSecret", "refreshToken", "getApplicationDefaultCredentialsPath", "Ljava/nio/file/Path;", "formattedTime", "Lcom/google/protobuf/Timestamp;", "getFormattedTime", "(Lcom/google/protobuf/Timestamp;)Ljava/lang/String;", "directaccess-client"})
public final class UtilsKt {
    @NotNull
    public static final Function1<DirectAccessCliSettings, DirectAccessAction> firstArgToAction(@NotNull Map<String, String> $this$firstArgToAction, @NotNull Map<String, Function1<DirectAccessCliSettings, DirectAccessAction>> map2) {
        Intrinsics.checkNotNullParameter($this$firstArgToAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if ($this$firstArgToAction.isEmpty()) {
            throw new ShowUsageException("Incomplete command");
        }
        String firstArg = (String)CollectionsKt.first((Iterable)$this$firstArgToAction.keySet());
        $this$firstArgToAction.remove(firstArg);
        Function1<DirectAccessCliSettings, DirectAccessAction> function1 = map2.get(firstArg);
        if (function1 == null) {
            throw new ShowUsageException(firstArg + " is not a valid command");
        }
        return function1;
    }

    public static final void retainAll(@NotNull Map<String, String> $this$retainAll, @NotNull Function1<? super Map.Entry<String, String>, Boolean> block) {
        Intrinsics.checkNotNullParameter($this$retainAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterator<Map.Entry<String, String>> iterator = $this$retainAll.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!((Boolean)block.invoke(iterator.next())).booleanValue()) continue;
            iterator.remove();
        }
    }

    @NotNull
    public static final Pair<String, String> argToPair(@NotNull String $this$argToPair) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$argToPair, (String)"<this>");
        if (!StringsKt.startsWith$default((String)$this$argToPair, (String)"--", (boolean)false, (int)2, null)) {
            pair = new Pair((Object)$this$argToPair, (Object)"");
        } else if (StringsKt.contains$default((CharSequence)$this$argToPair, (CharSequence)"=", (boolean)false, (int)2, null)) {
            boolean bl;
            String[] stringArray = new String[]{"="};
            List splitArg = StringsKt.split$default((CharSequence)$this$argToPair, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl2 = bl = splitArg.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            pair = new Pair(splitArg.get(0), splitArg.get(1));
        } else {
            pair = new Pair((Object)$this$argToPair, (Object)"");
        }
        return pair;
    }

    @NotNull
    public static final String fetchAccessTokenForClient(@NotNull String clientId, @NotNull String clientSecret, @NotNull String refreshToken) {
        String string;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        try {
            GoogleRefreshTokenRequest request = new GoogleRefreshTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), refreshToken, clientId, clientSecret);
            GoogleTokenResponse response = request.execute();
            string = response.getAccessToken();
        }
        catch (Exception e) {
            throw new CredentialsNotFoundException("Error fetching access token", e);
        }
        return string;
    }

    @NotNull
    public static final Path getApplicationDefaultCredentialsPath() {
        String userHome = System.getProperty("user.home");
        Intrinsics.checkNotNull((Object)userHome);
        String string = userHome;
        String[] stringArray = DirectAccessCliSettingsKt.getADC_PATH();
        stringArray = Arrays.copyOf(stringArray, stringArray.length);
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public static final String getFormattedTime(@NotNull Timestamp $this$formattedTime) {
        Intrinsics.checkNotNullParameter((Object)$this$formattedTime, (String)"<this>");
        String string = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault()).format(Instant.ofEpochSecond($this$formattedTime.getSeconds(), $this$formattedTime.getNanos()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

