/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.launcher;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.cloudresourcemanager.v3.CloudResourceManager;
import com.google.api.services.storage.Storage;
import com.google.api.services.testing.Testing;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.TestEnvironmentCatalog;
import com.google.api.services.toolresults.ToolResults;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.gct.testing.CloudTestingUtils;
import com.google.services.firebase.FirebaseLoginFeature;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010\"\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010%\u001a\u00020&2\b\u0010$\u001a\u0004\u0018\u00010\u001c2\b\u0010'\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0006\u00101\u001a\u00020\u001aJ\u0006\u00102\u001a\u000203R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010(\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010.\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00065"}, d2={"Lcom/google/gct/testing/launcher/CloudAuthenticator;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "myHttpTransport", "Lcom/google/api/client/http/HttpTransport;", "getMyHttpTransport", "()Lcom/google/api/client/http/HttpTransport;", "myStorage", "Lcom/google/api/services/storage/Storage;", "myCloudResourceManager", "Lcom/google/api/services/cloudresourcemanager/v3/CloudResourceManager;", "myTest", "Lcom/google/api/services/testing/Testing;", "myToolresults", "Lcom/google/api/services/toolresults/ToolResults;", "myLastDiscoveryServiceInvocationTimestamp", "", "firebaseFeature", "Lcom/google/services/firebase/FirebaseLoginFeature;", "storage", "getStorage", "()Lcom/google/api/services/storage/Storage;", "recreateTestAndToolResults", "", "testBackendUrl", "", "toolResultsBackendUrl", "cloudResourceManager", "getCloudResourceManager", "()Lcom/google/api/services/cloudresourcemanager/v3/CloudResourceManager;", "test", "getTest", "()Lcom/google/api/services/testing/Testing;", "endpoint", "getAndroidDeviceCatalogForEnvironment", "Lcom/google/api/services/testing/model/AndroidDeviceCatalog;", "gcpProject", "androidDeviceCatalog", "getAndroidDeviceCatalog", "()Lcom/google/api/services/testing/model/AndroidDeviceCatalog;", "showDeviceCatalogError", "errorMessageSuffix", "currentTimestamp", "toolresults", "getToolresults", "()Lcom/google/api/services/toolresults/ToolResults;", "prepareCredential", "authorize", "", "Companion", "firebase-testing"})
@SourceDebugExtension(value={"SMAP\nCloudAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudAuthenticator.kt\ncom/google/gct/testing/launcher/CloudAuthenticator\n+ 2 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n39#2,4:242\n1#3:246\n*S KotlinDebug\n*F\n+ 1 CloudAuthenticator.kt\ncom/google/gct/testing/launcher/CloudAuthenticator\n*L\n65#1:242,4\n*E\n"})
public final class CloudAuthenticator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HttpTransport myHttpTransport;
    @Nullable
    private Storage myStorage;
    @Nullable
    private CloudResourceManager myCloudResourceManager;
    @Nullable
    private Testing myTest;
    @Nullable
    private ToolResults myToolresults;
    private long myLastDiscoveryServiceInvocationTimestamp;
    @NotNull
    private final FirebaseLoginFeature firebaseFeature;

    public CloudAuthenticator(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.myLastDiscoveryServiceInvocationTimestamp = -1L;
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CloudAuthenticator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean $i$f$service = false;
                        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
                        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        this.label = 1;
                        Object object4 = ((GoogleLoginService)object3).getActiveUserFlow().collect(new FlowCollector(){

                            public final Object emit(CredentialedUser it, Continuation<? super Unit> $completion) {
                                1.invokeSuspend$reset(this$0);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object4 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$reset(CloudAuthenticator this$0) {
                this$0.myHttpTransport = null;
                this$0.myStorage = null;
                this$0.myCloudResourceManager = null;
                this$0.myTest = null;
                this$0.myToolresults = null;
            }
        }), (int)3, null);
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        this.firebaseFeature = (FirebaseLoginFeature)loginFeature;
    }

    private final HttpTransport getMyHttpTransport() {
        HttpTransport httpTransport = this.myHttpTransport;
        if (httpTransport == null) {
            NetHttpTransport netHttpTransport;
            NetHttpTransport it = netHttpTransport = new NetHttpTransport();
            boolean bl = false;
            this.myHttpTransport = (HttpTransport)it;
            httpTransport = (HttpTransport)netHttpTransport;
        }
        return httpTransport;
    }

    @NotNull
    public final Storage getStorage() {
        Storage storage = this.myStorage;
        if (storage == null) {
            Storage storage2;
            Storage it = storage2 = new Storage.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL").build();
            boolean bl = false;
            this.myStorage = it;
            Storage storage3 = storage2;
            storage = storage3;
            Intrinsics.checkNotNullExpressionValue((Object)storage3, (String)"also(...)");
        }
        return storage;
    }

    public final void recreateTestAndToolResults(@Nullable String testBackendUrl, @Nullable String toolResultsBackendUrl) {
        this.myTest = new Testing.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL").setRootUrl(testBackendUrl).build();
        this.myToolresults = new ToolResults.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL").setRootUrl(toolResultsBackendUrl).build();
    }

    @NotNull
    public final CloudResourceManager getCloudResourceManager() {
        CloudResourceManager cloudResourceManager = this.myCloudResourceManager;
        if (cloudResourceManager == null) {
            CloudResourceManager cloudResourceManager2;
            CloudResourceManager it = cloudResourceManager2 = new CloudResourceManager.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL").build();
            boolean bl = false;
            this.myCloudResourceManager = it;
            CloudResourceManager cloudResourceManager3 = cloudResourceManager2;
            cloudResourceManager = cloudResourceManager3;
            Intrinsics.checkNotNullExpressionValue((Object)cloudResourceManager3, (String)"also(...)");
        }
        return cloudResourceManager;
    }

    @NotNull
    public final Testing getTest() {
        return this.getTest(null);
    }

    private final Testing getTest(String endpoint) {
        Testing testing = this.myTest;
        if (testing == null) {
            Testing.Builder builder;
            Testing.Builder $this$getTest_u24lambda_u243 = builder = new Testing.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL");
            boolean bl = false;
            if (endpoint != null) {
                $this$getTest_u24lambda_u243.setRootUrl(endpoint);
            }
            Testing.Builder it = builder = builder.build();
            boolean bl2 = false;
            this.myTest = it;
            Testing.Builder builder2 = builder;
            testing = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"also(...)");
        }
        return testing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AndroidDeviceCatalog getAndroidDeviceCatalogForEnvironment(@Nullable String endpoint, @Nullable String gcpProject) throws IOException {
        long currentTimestamp = System.currentTimeMillis();
        try {
            Testing.TestEnvironmentCatalog.Get getter = this.getTest(endpoint).testEnvironmentCatalog().get("ANDROID");
            getter.setProjectId(gcpProject);
            getter.getRequestHeaders().set("X-Goog-User-Project", (Object)gcpProject);
            AndroidDeviceCatalog catalog = ((TestEnvironmentCatalog)getter.execute()).getAndroidDeviceCatalog();
            if (catalog.getVersions().isEmpty() || catalog.getModels().isEmpty() || catalog.getRuntimeConfiguration().getLocales().isEmpty() || catalog.getRuntimeConfiguration().getOrientations().isEmpty()) {
                this.showDeviceCatalogError("Android device catalog is empty for some dimensions", currentTimestamp);
            }
            Intrinsics.checkNotNull((Object)catalog);
            AndroidDeviceCatalog androidDeviceCatalog = catalog;
            return androidDeviceCatalog;
        }
        finally {
            this.myLastDiscoveryServiceInvocationTimestamp = currentTimestamp;
        }
    }

    @Nullable
    public final AndroidDeviceCatalog getAndroidDeviceCatalog() {
        try {
            return this.getAndroidDeviceCatalogForEnvironment(null, null);
        }
        catch (IOException e) {
            this.showDeviceCatalogError(StringsKt.trimIndent((String)("\n  Exception while getting Android device catalog\n\n  " + e.getMessage() + "\n  ")), System.currentTimeMillis());
            return null;
        }
    }

    private final void showDeviceCatalogError(String errorMessageSuffix, long currentTimestamp) {
        if (currentTimestamp - this.myLastDiscoveryServiceInvocationTimestamp > 1000L) {
            CloudTestingUtils.showErrorMessage(null, "Error retrieving android device catalog", "Failed to retrieve available firebase devices! Please try again later.\n" + errorMessageSuffix);
        }
    }

    @NotNull
    public final ToolResults getToolresults() {
        ToolResults toolResults = this.myToolresults;
        if (toolResults == null) {
            ToolResults toolResults2;
            ToolResults it = toolResults2 = new ToolResults.Builder(this.getMyHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.firebaseFeature.credential()).setApplicationName("GCTL").build();
            boolean bl = false;
            this.myToolresults = it;
            ToolResults toolResults3 = toolResults2;
            toolResults = toolResults3;
            Intrinsics.checkNotNullExpressionValue((Object)toolResults3, (String)"also(...)");
        }
        return toolResults;
    }

    public final void prepareCredential() {
        if (!this.firebaseFeature.isLoggedIn() && !this.authorize()) {
            throw new RuntimeException("Failed to authorize to Google Cloud! Please check if you set the correct user account.");
        }
    }

    public final boolean authorize() {
        if (!this.firebaseFeature.isLoggedIn()) {
            CompletableFuture complete = new CompletableFuture();
            LoginFeature.logInAsync$default((LoginFeature)((LoginFeature)this.firebaseFeature), null, null, () -> CloudAuthenticator.authorize$lambda$6(complete), (int)3, null);
            complete.get();
        }
        return this.firebaseFeature.isLoggedIn();
    }

    private static final void authorize$lambda$6(CompletableFuture $complete) {
        $complete.complete(null);
    }

    @NotNull
    public static final CloudAuthenticator getInstance() {
        return Companion.getInstance();
    }

    public static final boolean isUserLoggedIn() {
        return Companion.isUserLoggedIn();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\t\u0010\f\u00a8\u0006\r"}, d2={"Lcom/google/gct/testing/launcher/CloudAuthenticator$Companion;", "", "<init>", "()V", "instance", "Lcom/google/gct/testing/launcher/CloudAuthenticator;", "getInstance$annotations", "getInstance", "()Lcom/google/gct/testing/launcher/CloudAuthenticator;", "isUserLoggedIn", "", "isUserLoggedIn$annotations", "()Z", "firebase-testing"})
    @SourceDebugExtension(value={"SMAP\nCloudAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudAuthenticator.kt\ncom/google/gct/testing/launcher/CloudAuthenticator$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n*L\n1#1,241:1\n40#2,3:242\n39#3,4:245\n*S KotlinDebug\n*F\n+ 1 CloudAuthenticator.kt\ncom/google/gct/testing/launcher/CloudAuthenticator$Companion\n*L\n233#1:242,3\n238#1:245,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudAuthenticator getInstance() {
            boolean $i$f$service = false;
            Class<CloudAuthenticator> serviceClass$iv = CloudAuthenticator.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CloudAuthenticator)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public final boolean isUserLoggedIn() {
            LoginFeature.Companion this_$iv = LoginFeature.Companion;
            boolean $i$f$feature = false;
            LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
            if (loginFeature == null) {
                throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
            }
            return ((FirebaseLoginFeature)loginFeature).isLoggedIn();
        }

        @JvmStatic
        @Deprecated(message="Just check the status directly")
        public static /* synthetic */ void isUserLoggedIn$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

