/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.gson.Gson;
import com.google.services.firebase.FirebaseLoginFeature;
import com.google.services.firebase.FirebaseProject;
import com.google.services.firebase.ListFirebaseProjectResponse;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/google/services/firebase/FirebaseProjectClient;", "", "<init>", "()V", "httpTransport", "Lcom/google/api/client/http/HttpTransport;", "setHttpTransportForTest", "", "transport", "restoreHttpTransport", "defaultCredential", "Lcom/google/api/client/auth/oauth2/Credential;", "getDefaultCredential", "()Lcom/google/api/client/auth/oauth2/Credential;", "listFirebaseProjects", "", "Lcom/google/services/firebase/FirebaseProject;", "credential", "createCloudProject", "projectId", "", "addFirebaseProject", "firebase"})
@SourceDebugExtension(value={"SMAP\nFirebaseProjectClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseProjectClient.kt\ncom/google/services/firebase/FirebaseProjectClient\n+ 2 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n39#2,4:126\n1#3:130\n24#4:131\n24#4:132\n*S KotlinDebug\n*F\n+ 1 FirebaseProjectClient.kt\ncom/google/services/firebase/FirebaseProjectClient\n*L\n58#1:126,4\n76#1:131\n84#1:132\n*E\n"})
public final class FirebaseProjectClient {
    @NotNull
    public static final FirebaseProjectClient INSTANCE = new FirebaseProjectClient();
    @NotNull
    private static HttpTransport httpTransport = (HttpTransport)new NetHttpTransport();

    private FirebaseProjectClient() {
    }

    @TestOnly
    public final void setHttpTransportForTest(@NotNull HttpTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        httpTransport = transport;
    }

    @TestOnly
    public final void restoreHttpTransport() {
        httpTransport = (HttpTransport)new NetHttpTransport();
    }

    private final Credential getDefaultCredential() {
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        return GoogleLoginService.Companion.getInstance().getCredential(loginFeature);
    }

    @NotNull
    public final List<FirebaseProject> listFirebaseProjects(@Nullable Credential credential) {
        boolean bl;
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        List projects = new ArrayList();
        String nextPageToken = null;
        do {
            ListFirebaseProjectResponse listFirebaseProjectResponse;
            GenericUrl genericUrl;
            GenericUrl $this$listFirebaseProjects_u24lambda_u240 = genericUrl = new GenericUrl("https://firebase.googleapis.com/v1beta1/projects");
            boolean bl2 = false;
            $this$listFirebaseProjects_u24lambda_u240.put("pageToken", nextPageToken);
            $this$listFirebaseProjects_u24lambda_u240.put("pageSize", (Object)1000);
            GenericUrl url = genericUrl;
            Object $this$listFirebaseProjects_u24lambda_u241 = $this$listFirebaseProjects_u24lambda_u240 = requestFactory.buildGetRequest(url);
            boolean bl3 = false;
            Credential credential2 = credential;
            if (credential2 != null) {
                credential2.initialize((HttpRequest)$this$listFirebaseProjects_u24lambda_u241);
            }
            GenericUrl request = $this$listFirebaseProjects_u24lambda_u240;
            try {
                $this$listFirebaseProjects_u24lambda_u241 = request.execute().parseAsString();
            }
            catch (IOException e) {
                FirebaseProjectClient $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(FirebaseProjectClient.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Error while fetching firebase projects: " + e.getMessage());
                throw e;
            }
            Object response2 = $this$listFirebaseProjects_u24lambda_u241;
            try {
                listFirebaseProjectResponse = (ListFirebaseProjectResponse)new Gson().fromJson((String)response2, ListFirebaseProjectResponse.class);
            }
            catch (Exception e) {
                FirebaseProjectClient $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(FirebaseProjectClient.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Error while parsing firebase projects: " + e.getMessage());
                throw e;
            }
            ListFirebaseProjectResponse parser = listFirebaseProjectResponse;
            if (parser.getResults() != null) {
                List<FirebaseProject> it;
                boolean bl4 = false;
                projects.addAll((Collection)it);
            }
            String string = nextPageToken = parser.getNextPageToken();
            if (string != null) {
                if (((CharSequence)string).length() > 0) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl);
        return projects;
    }

    public static /* synthetic */ List listFirebaseProjects$default(FirebaseProjectClient firebaseProjectClient, Credential credential, int n, Object object) {
        if ((n & 1) != 0) {
            credential = firebaseProjectClient.getDefaultCredential();
        }
        return firebaseProjectClient.listFirebaseProjects(credential);
    }

    public final void createCloudProject(@NotNull String projectId, @Nullable Credential credential) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
        JsonHttpContent createProjectContent = new JsonHttpContent((JsonFactory)jsonFactory, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"projectId", (Object)projectId)));
        GenericUrl createProjectUrl = new GenericUrl("https://cloudresourcemanager.googleapis.com/v3/projects/");
        HttpRequest request = requestFactory.buildPostRequest(createProjectUrl, (HttpContent)createProjectContent);
        Credential credential2 = credential;
        if (credential2 != null) {
            credential2.initialize(request);
        }
        request.execute();
    }

    public static /* synthetic */ void createCloudProject$default(FirebaseProjectClient firebaseProjectClient, String string, Credential credential, int n, Object object) {
        if ((n & 2) != 0) {
            credential = firebaseProjectClient.getDefaultCredential();
        }
        firebaseProjectClient.createCloudProject(string, credential);
    }

    public final void addFirebaseProject(@NotNull String projectId, @Nullable Credential credential) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        String addFirebaseUri = "https://firebase.googleapis.com/v1beta1/projects/" + projectId + ":addFirebase";
        HttpRequest addFirebaseRequest = requestFactory.buildPostRequest(new GenericUrl(addFirebaseUri), (HttpContent)new EmptyContent());
        Credential credential2 = credential;
        if (credential2 != null) {
            credential2.initialize(addFirebaseRequest);
        }
        addFirebaseRequest.execute();
    }

    public static /* synthetic */ void addFirebaseProject$default(FirebaseProjectClient firebaseProjectClient, String string, Credential credential, int n, Object object) {
        if ((n & 2) != 0) {
            credential = firebaseProjectClient.getDefaultCredential();
        }
        firebaseProjectClient.addFirebaseProject(string, credential);
    }
}

