/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.gradle.project.Info;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.ModuleState;
import com.google.services.firebase.ModuleStateService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleAsyncStateManager
extends AssistActionStateManager {
    protected final Map<Project, String> myStateMessageMap = new HashMap<Project, String>();

    private static Logger getLog() {
        return Logger.getInstance(ModuleAsyncStateManager.class);
    }

    @NotNull
    public DefaultActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        this.myStateMessageMap.remove(project);
        List modules = Info.getInstance((Project)project).getAndroidModules();
        ModuleAsyncStateManager.getLog().debug("getState called for: " + project.getName());
        int numCompleted = 0;
        for (Module module : modules) {
            ModuleState moduleState = ModuleStateService.getInstance().getModuleState(module);
            if (moduleState != null) {
                if (moduleState.isCompletable()) continue;
                ++numCompleted;
                continue;
            }
            ModuleStateService.getInstance().requestModuleStatusUpdate(module);
            return DefaultActionState.IN_PROGRESS;
        }
        if (numCompleted == 0) {
            return DefaultActionState.INCOMPLETE;
        }
        if (numCompleted != modules.size()) {
            this.myStateMessageMap.put(project, FirebaseBundle.message("stateManager.userNote.partiallyCompleted", numCompleted, modules.size()));
            return DefaultActionState.PARTIALLY_COMPLETE;
        }
        return DefaultActionState.COMPLETE;
    }
}

