/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.Nullable;

public class ConnectProjectPayload {
    private static final Logger LOGGER = Logger.getInstance(ConnectProjectPayload.class);
    @Nullable
    private final String userEmail;
    @Nullable
    private final String projectNumber;
    @Nullable
    private final String projectId;
    @Nullable
    private final String packageName;
    @Nullable
    private final String servicesJson;
    @Nullable
    private final String appConfigVersion;

    private ConnectProjectPayload(@Nullable String userEmail, @Nullable String projectNumber, @Nullable String projectId, @Nullable String packageName, @Nullable String servicesJson, @Nullable String appConfigVersion) {
        this.userEmail = userEmail;
        this.projectNumber = projectNumber;
        this.projectId = projectId;
        this.packageName = packageName;
        this.servicesJson = servicesJson;
        this.appConfigVersion = appConfigVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public String getUserEmail() {
        return this.userEmail;
    }

    @Nullable
    public String getProjectNumber() {
        return this.projectNumber;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Nullable
    public String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public String getServicesJson() {
        return this.servicesJson;
    }

    public String getAppConfigVersion() {
        return this.appConfigVersion;
    }

    public boolean isValid() {
        if (this.userEmail == null || this.userEmail.isEmpty() || this.projectNumber == null || this.projectNumber.isEmpty() || this.servicesJson == null || this.servicesJson.isEmpty()) {
            return false;
        }
        try {
            return new JsonParser().parse(this.servicesJson).getAsJsonObject() != null;
        }
        catch (JsonParseException | IllegalStateException e) {
            LOGGER.warn("googleServices json cannot be parsed", e);
            return false;
        }
    }

    public static class Builder {
        private String userEmail;
        private String projectNumber;
        private String projectId;
        private String packageName;
        private String servicesJson;
        private String appConfigVersion;

        public Builder setUserEmail(@Nullable String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        public Builder setProjectNumber(@Nullable String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setProjectId(@Nullable String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setBase64ServicesJson(@Nullable String servicesJson) {
            this.servicesJson = servicesJson == null ? null : new String(Base64.getDecoder().decode(servicesJson), StandardCharsets.UTF_8);
            return this;
        }

        public Builder setPackageName(@Nullable String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setAppConfigVersion(@Nullable String appConfigVersion) {
            this.appConfigVersion = appConfigVersion;
            return this;
        }

        public ConnectProjectPayload build() {
            return new ConnectProjectPayload(this.userEmail, this.projectNumber, this.projectId, this.packageName, this.servicesJson, this.appConfigVersion);
        }
    }
}

