/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.services.firebase.ModuleAsyncStateManager;
import com.google.services.firebase.ModuleStateService;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConnectStateManager
extends ModuleAsyncStateManager {
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    @NotNull
    public String getId() {
        return "firebase.connect";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                ModuleStateService.getInstance().requestProjectModuleStateUpdate(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                ModuleStateService.getInstance().requestProjectModuleStateUpdate(project);
            }
        });
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        String message = this.myStateMessageMap.getOrDefault(project, successMessage);
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }
}

