/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.config.GradleConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConfig {
    @Nullable
    private final FirebaseLocalConfig myFirebaseLocalConfig;
    private final Set<AndroidClient> myRegisterableClients;

    public FirebaseConfig(@NotNull Module androidApplicationModule) throws FirebaseLocalConfig.InvalidLocalConfigException {
        this(FirebaseLocalConfig.fromModule(androidApplicationModule), GradleConfig.fromModule(androidApplicationModule));
    }

    @VisibleForTesting
    FirebaseConfig(@Nullable FirebaseLocalConfig fileConfig, @NotNull GradleConfig gradleConfig) throws FirebaseLocalConfig.InvalidLocalConfigException {
        this.myFirebaseLocalConfig = fileConfig;
        HashSet<AndroidClient> unregisteredClients = new HashSet<AndroidClient>();
        ImmutableList.Builder configExceptionBuilder = new ImmutableList.Builder();
        if (this.myFirebaseLocalConfig != null && this.myFirebaseLocalConfig.getConfigErrors() != null) {
            configExceptionBuilder.addAll(this.myFirebaseLocalConfig.getConfigErrors());
        }
        for (AndroidClient variant : gradleConfig.getVariants()) {
            FirebaseConfig.getLog().info("Found unregistered client: " + variant);
            if (unregisteredClients.add(variant)) continue;
            FirebaseConfig.getLog().warn("Unregistered client (" + variant.toString() + ") found on multiple Firebase projects, ignoring.");
        }
        ImmutableSet unregisteredClients1 = ImmutableSet.copyOf(unregisteredClients);
        this.myRegisterableClients = unregisteredClients1.stream().filter(AndroidClient::isAttemptRegistration).collect(Collectors.toSet());
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConfig.class);
    }

    @Nullable
    public String getLocalFirebaseConfigProjectId() {
        return this.myFirebaseLocalConfig != null ? this.myFirebaseLocalConfig.getProjectId() : null;
    }

    @NotNull
    public Set<AndroidClient> getRegisterableAndroidClients() {
        return this.myRegisterableClients;
    }
}

