/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.services.firebase.insights.config.GClient;
import com.google.services.firebase.insights.config.GProjectInfo;
import com.google.services.firebase.insights.config.GServices;
import com.google.services.firebase.insights.datamodel.CrashlyticsConnection;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\"\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"parseGoogleServices", "", "Lcom/google/services/firebase/insights/datamodel/CrashlyticsConnection;", "json", "Ljava/io/Reader;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "firebase"})
public final class JsonParserKt {
    private static final Gson gson = new Gson().newBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    @NotNull
    public static final List<CrashlyticsConnection> parseGoogleServices(@NotNull Reader json) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            GServices gServices = (GServices)gson.fromJson(json, GServices.class);
            if (gServices == null) {
                return CollectionsKt.emptyList();
            }
            GServices gServices2 = gServices;
            GProjectInfo pInfo = gServices2.getProjectInfo();
            if (!pInfo.isValid()) {
                return CollectionsKt.emptyList();
            }
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)gServices2.getClient()), JsonParserKt::parseGoogleServices$lambda$0), arg_0 -> JsonParserKt.parseGoogleServices$lambda$1(pInfo, arg_0)));
        }
        catch (JsonParseException ex) {
            list = CollectionsKt.emptyList();
        }
        catch (IOException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean parseGoogleServices$lambda$0(GClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return client.isValid();
    }

    private static final CrashlyticsConnection parseGoogleServices$lambda$1(GProjectInfo $pInfo, GClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new CrashlyticsConnection(client.getClientInfo().getAndroidClientInfo().getPackageName(), client.getClientInfo().getMobilesdkAppId(), $pInfo.getProjectId(), $pInfo.getProjectNumber());
    }
}

