/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.insights.Connection;
import com.android.tools.idea.insights.ModuleUtilKt;
import com.android.tools.idea.insights.VariantData;
import com.google.services.firebase.insights.datamodel.CrashlyticsConnection;
import com.intellij.openapi.module.Module;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010)\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010H\u0002J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J'\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00100\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u0011\u0010!\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lcom/google/services/firebase/insights/datamodel/CrashlyticsVariantConnection;", "Lcom/android/tools/idea/insights/Connection;", "connection", "Lcom/google/services/firebase/insights/datamodel/CrashlyticsConnection;", "variantData", "Lcom/android/tools/idea/insights/VariantData;", "isConfigured", "", "<init>", "(Lcom/google/services/firebase/insights/datamodel/CrashlyticsConnection;Lcom/android/tools/idea/insights/VariantData;Z)V", "getConnection", "()Lcom/google/services/firebase/insights/datamodel/CrashlyticsConnection;", "getVariantData", "()Lcom/android/tools/idea/insights/VariantData;", "()Z", "appId", "", "getAppId", "()Ljava/lang/String;", "mobileSdkAppId", "getMobileSdkAppId", "projectId", "getProjectId", "projectNumber", "getProjectNumber", "clientId", "getClientId", "moduleShortName", "getModuleShortName", "shortMenuItemText", "getShortMenuItemText", "menuItemText", "getMenuItemText", "titleText", "getTitleText", "isPreferredComputation", "Lkotlin/Function0;", "isPreferredComputation$firebase", "()Lkotlin/jvm/functions/Function0;", "setPreferredComputation$firebase", "(Lkotlin/jvm/functions/Function0;)V", "isPreferredConnection", "stripProjectName", "projectName", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "firebase"})
public final class CrashlyticsVariantConnection
implements Connection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrashlyticsConnection connection;
    @NotNull
    private final VariantData variantData;
    private final boolean isConfigured;
    @NotNull
    private final String appId;
    @NotNull
    private final String mobileSdkAppId;
    @NotNull
    private final String projectId;
    @NotNull
    private final String projectNumber;
    @NotNull
    private final String clientId;
    @NotNull
    private final String moduleShortName;
    @NotNull
    private final String shortMenuItemText;
    @NotNull
    private final String menuItemText;
    @NotNull
    private final String titleText;
    @TestOnly
    @NotNull
    private Function0<Boolean> isPreferredComputation;
    @NotNull
    public static final String ALL_VARIANTS = "All";

    public CrashlyticsVariantConnection(@NotNull CrashlyticsConnection connection, @NotNull VariantData variantData, boolean isConfigured) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        this.connection = connection;
        this.variantData = variantData;
        this.isConfigured = isConfigured;
        this.appId = this.connection.getAppId();
        this.mobileSdkAppId = this.connection.getMobileSdkAppId();
        this.projectId = this.connection.getProjectId();
        this.projectNumber = this.connection.getProjectNumber();
        this.clientId = "android:" + this.getAppId();
        String string = this.variantData.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.moduleShortName = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null);
        this.shortMenuItemText = this.variantData.getVariantName() + ": [" + this.stripProjectName(this.getProjectId()) + "] " + this.getAppId();
        this.menuItemText = this.isConfigured() ? this.moduleShortName + " \u203a " + this.shortMenuItemText : this.moduleShortName;
        this.titleText = this.isConfigured() ? this.menuItemText : this.moduleShortName + " \u203a (no connection)";
        this.isPreferredComputation = () -> CrashlyticsVariantConnection.isPreferredComputation$lambda$0(this);
    }

    public /* synthetic */ CrashlyticsVariantConnection(CrashlyticsConnection crashlyticsConnection, VariantData variantData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(crashlyticsConnection, variantData, bl);
    }

    @NotNull
    public final CrashlyticsConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public final VariantData getVariantData() {
        return this.variantData;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    @NotNull
    public String getAppId() {
        return this.appId;
    }

    @NotNull
    public String getMobileSdkAppId() {
        return this.mobileSdkAppId;
    }

    @NotNull
    public String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public String getProjectNumber() {
        return this.projectNumber;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getModuleShortName() {
        return this.moduleShortName;
    }

    @NotNull
    public final String getShortMenuItemText() {
        return this.shortMenuItemText;
    }

    @NotNull
    public final String getMenuItemText() {
        return this.menuItemText;
    }

    @NotNull
    public final String getTitleText() {
        return this.titleText;
    }

    @NotNull
    public final Function0<Boolean> isPreferredComputation$firebase() {
        return this.isPreferredComputation;
    }

    public final void setPreferredComputation$firebase(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.isPreferredComputation = function0;
    }

    public boolean isPreferredConnection() {
        return (Boolean)this.isPreferredComputation.invoke();
    }

    private final String stripProjectName(String projectName) {
        return StringsKt.substringBeforeLast$default((String)projectName, (char)'-', null, (int)2, null);
    }

    @NotNull
    public final CrashlyticsConnection component1() {
        return this.connection;
    }

    @NotNull
    public final VariantData component2() {
        return this.variantData;
    }

    public final boolean component3() {
        return this.isConfigured;
    }

    @NotNull
    public final CrashlyticsVariantConnection copy(@NotNull CrashlyticsConnection connection, @NotNull VariantData variantData, boolean isConfigured) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        return new CrashlyticsVariantConnection(connection, variantData, isConfigured);
    }

    public static /* synthetic */ CrashlyticsVariantConnection copy$default(CrashlyticsVariantConnection crashlyticsVariantConnection, CrashlyticsConnection crashlyticsConnection, VariantData variantData, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            crashlyticsConnection = crashlyticsVariantConnection.connection;
        }
        if ((n & 2) != 0) {
            variantData = crashlyticsVariantConnection.variantData;
        }
        if ((n & 4) != 0) {
            bl = crashlyticsVariantConnection.isConfigured;
        }
        return crashlyticsVariantConnection.copy(crashlyticsConnection, variantData, bl);
    }

    @NotNull
    public String toString() {
        return "CrashlyticsVariantConnection(connection=" + this.connection + ", variantData=" + this.variantData + ", isConfigured=" + this.isConfigured + ")";
    }

    public int hashCode() {
        int result = this.connection.hashCode();
        result = result * 31 + this.variantData.hashCode();
        result = result * 31 + Boolean.hashCode(this.isConfigured);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrashlyticsVariantConnection)) {
            return false;
        }
        CrashlyticsVariantConnection crashlyticsVariantConnection = (CrashlyticsVariantConnection)other;
        if (!Intrinsics.areEqual((Object)this.connection, (Object)crashlyticsVariantConnection.connection)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variantData, (Object)crashlyticsVariantConnection.variantData)) {
            return false;
        }
        return this.isConfigured == crashlyticsVariantConnection.isConfigured;
    }

    private static final boolean isPreferredComputation$lambda$0(CrashlyticsVariantConnection this$0) {
        String string = ModuleUtilKt.getAndroidAppId((Module)this$0.variantData.getModule());
        if (string == null) {
            return false;
        }
        String appId = string;
        Object object = GradleAndroidModel.Companion.get(this$0.variantData.getModule());
        if (object == null || (object = object.getSelectedVariant()) == null || (object = object.getDisplayName()) == null) {
            return false;
        }
        Object variantName = object;
        return Intrinsics.areEqual((Object)appId, (Object)this$0.getAppId()) && Intrinsics.areEqual((Object)variantName, (Object)this$0.variantData.getVariantName());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/insights/datamodel/CrashlyticsVariantConnection$Companion;", "", "<init>", "()V", "ALL_VARIANTS", "", "createPlaceHolder", "Lcom/google/services/firebase/insights/datamodel/CrashlyticsVariantConnection;", "module", "Lcom/intellij/openapi/module/Module;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CrashlyticsVariantConnection createPlaceHolder(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new CrashlyticsVariantConnection(new CrashlyticsConnection("PLACEHOLDER", "", "", ""), new VariantData(module, CrashlyticsVariantConnection.ALL_VARIANTS), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

