/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.persistence;

import com.android.tools.idea.insights.client.TosClient;
import com.android.tools.idea.insights.persistence.TosPersistence;
import com.google.gct.login2.GoogleLoginService;
import com.google.services.firebase.insights.FirebaseTosRedirector;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0005H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002R&\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/services/firebase/insights/persistence/PersistentTosClient;", "Lcom/android/tools/idea/insights/client/TosClient;", "tosAcceptor", "Lkotlin/Function3;", "", "Lcom/intellij/openapi/project/Project;", "", "<init>", "(Lkotlin/jvm/functions/Function3;)V", "isTosAccepted", "", "firebaseProject", "tryAcceptTos", "project", "getUserEmail", "Companion", "firebase"})
public final class PersistentTosClient
implements TosClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function3<String, String, Project, Unit> tosAcceptor;

    public PersistentTosClient(@NotNull Function3<? super String, ? super String, ? super Project, Unit> tosAcceptor) {
        Intrinsics.checkNotNullParameter(tosAcceptor, (String)"tosAcceptor");
        this.tosAcceptor = tosAcceptor;
    }

    public boolean isTosAccepted(@NotNull String firebaseProject) {
        Intrinsics.checkNotNullParameter((Object)firebaseProject, (String)"firebaseProject");
        return TosPersistence.Companion.getInstance().isTosAccepted(firebaseProject);
    }

    public boolean tryAcceptTos(@NotNull String firebaseProject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)firebaseProject, (String)"firebaseProject");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.getUserEmail();
        if (string == null) {
            return false;
        }
        String user = string;
        this.tosAcceptor.invoke((Object)firebaseProject, (Object)user, (Object)project);
        return this.isTosAccepted(firebaseProject);
    }

    private final String getUserEmail() {
        return GoogleLoginService.Companion.getInstance().getEmail();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a8\u0006\u000b"}, d2={"Lcom/google/services/firebase/insights/persistence/PersistentTosClient$Companion;", "", "<init>", "()V", "create", "Lcom/google/services/firebase/insights/persistence/PersistentTosClient;", "tosAcceptor", "Lkotlin/Function3;", "", "Lcom/intellij/openapi/project/Project;", "", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PersistentTosClient create(@NotNull Function3<? super String, ? super String, ? super Project, Unit> tosAcceptor) {
            Intrinsics.checkNotNullParameter(tosAcceptor, (String)"tosAcceptor");
            return new PersistentTosClient(tosAcceptor);
        }

        public static /* synthetic */ PersistentTosClient create$default(Companion companion, Function3 function3, int n, Object object) {
            if ((n & 1) != 0) {
                function3 = Companion::create$lambda$0;
            }
            return companion.create((Function3<? super String, ? super String, ? super Project, Unit>)function3);
        }

        private static final Unit create$lambda$0(String firebaseProject, String user, Project project) {
            Intrinsics.checkNotNullParameter((Object)firebaseProject, (String)"firebaseProject");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            new FirebaseTosRedirector(project, firebaseProject, user).queue();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

