/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.insights.AppInsightsIssue;
import com.android.tools.idea.insights.AppInsightsState;
import com.android.tools.idea.insights.Connection;
import com.android.tools.idea.insights.LoadingState;
import com.android.tools.idea.insights.MultiSelection;
import com.android.tools.idea.insights.TimeIntervalFilter;
import com.android.tools.idea.insights.Version;
import com.android.tools.idea.insights.WithCount;
import com.android.tools.idea.insights.ui.InsightPermissionDeniedHandler;
import com.android.tools.idea.insights.ui.UiUtilKt;
import com.google.services.firebase.insights.ui.FirebaseConsoleUrlUtilKt;
import com.intellij.ide.BrowserUtil;
import com.intellij.util.ui.StatusText;
import java.awt.event.ActionEvent;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/services/firebase/insights/ui/CrashlyticsInsightPermissionDeniedHandler;", "Lcom/android/tools/idea/insights/ui/InsightPermissionDeniedHandler;", "stateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/android/tools/idea/insights/AppInsightsState;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;)V", "handlePermissionDenied", "", "permissionDenied", "Lcom/android/tools/idea/insights/LoadingState$PermissionDenied;", "statusText", "Lcom/intellij/util/ui/StatusText;", "getConsoleUrl", "", "firebase"})
public final class CrashlyticsInsightPermissionDeniedHandler
implements InsightPermissionDeniedHandler {
    @NotNull
    private final StateFlow<AppInsightsState> stateFlow;

    public CrashlyticsInsightPermissionDeniedHandler(@NotNull StateFlow<AppInsightsState> stateFlow) {
        Intrinsics.checkNotNullParameter(stateFlow, (String)"stateFlow");
        this.stateFlow = stateFlow;
    }

    public void handlePermissionDenied(@NotNull LoadingState.PermissionDenied permissionDenied, @NotNull StatusText statusText) {
        StatusText statusText2;
        Intrinsics.checkNotNullParameter((Object)permissionDenied, (String)"permissionDenied");
        Intrinsics.checkNotNullParameter((Object)statusText, (String)"statusText");
        String errorMessage = permissionDenied.getMessage();
        StatusText $this$handlePermissionDenied_u24lambda_u242 = statusText2 = statusText;
        boolean bl = false;
        statusText.clear();
        if (errorMessage == null) {
            $this$handlePermissionDenied_u24lambda_u242.appendText("Request failed", UiUtilKt.getEMPTY_STATE_TITLE_FORMAT());
            v0 = $this$handlePermissionDenied_u24lambda_u242.appendLine("You do not have permission to fetch insights.", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
        } else {
            CharSequence charSequence = errorMessage;
            if (new Regex("Cloud AI Companion API has not been used in project .* before or it is disabled").containsMatchIn(charSequence)) {
                $this$handlePermissionDenied_u24lambda_u242.appendText("Insights not configured", UiUtilKt.getEMPTY_STATE_TITLE_FORMAT());
                $this$handlePermissionDenied_u24lambda_u242.appendLine("This project is not configured for insights generation", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                $this$handlePermissionDenied_u24lambda_u242.appendLine("To resolve this error, you can visit the ", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                $this$handlePermissionDenied_u24lambda_u242.appendText("console", UiUtilKt.getEMPTY_STATE_LINK_FORMAT(), arg_0 -> CrashlyticsInsightPermissionDeniedHandler.handlePermissionDenied$lambda$2$lambda$0(this, arg_0));
                v0 = $this$handlePermissionDenied_u24lambda_u242.appendText(" and follow the instructions.", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
            } else {
                charSequence = errorMessage;
                if (new Regex("Permission '.*' denied on resource '//cloudaicompanion.googleapis.com/projects/.*/locations/global/instances/default'").containsMatchIn(charSequence)) {
                    $this$handlePermissionDenied_u24lambda_u242.appendText("Insights not configured", UiUtilKt.getEMPTY_STATE_TITLE_FORMAT());
                    $this$handlePermissionDenied_u24lambda_u242.appendLine("You do not have permission to fetch insights", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                    $this$handlePermissionDenied_u24lambda_u242.appendLine("To resolve this error, you can visit the ", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                    $this$handlePermissionDenied_u24lambda_u242.appendText("console", UiUtilKt.getEMPTY_STATE_LINK_FORMAT(), arg_0 -> CrashlyticsInsightPermissionDeniedHandler.handlePermissionDenied$lambda$2$lambda$1(this, arg_0));
                    v0 = $this$handlePermissionDenied_u24lambda_u242.appendText(" and follow the instructions.", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                } else {
                    $this$handlePermissionDenied_u24lambda_u242.appendText("Request failed", UiUtilKt.getEMPTY_STATE_TITLE_FORMAT());
                    v0 = $this$handlePermissionDenied_u24lambda_u242.appendLine("You do not have permission to fetch insights.", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
                }
            }
        }
    }

    private final String getConsoleUrl() {
        AppInsightsState appInsightsState = (AppInsightsState)this.stateFlow.getValue();
        if (appInsightsState == null) {
            return "";
        }
        AppInsightsState state = appInsightsState;
        Connection connection = (Connection)state.getConnections().getSelected();
        if (connection == null) {
            return "";
        }
        Connection connection2 = connection;
        TimeIntervalFilter timeIntervalFilter = (TimeIntervalFilter)state.getFilters().getTimeInterval().getSelected();
        if (timeIntervalFilter == null || (timeIntervalFilter = timeIntervalFilter.asMillisFromNow()) == null) {
            return "";
        }
        TimeIntervalFilter timeFilter = timeIntervalFilter;
        MultiSelection $this$getConsoleUrl_u24lambda_u244 = state.getFilters().getVersions();
        boolean bl = false;
        Set version = $this$getConsoleUrl_u24lambda_u244.allSelected() ? SetsKt.emptySet() : SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$getConsoleUrl_u24lambda_u244.getItems()), CrashlyticsInsightPermissionDeniedHandler::getConsoleUrl$lambda$4$lambda$3));
        AppInsightsIssue appInsightsIssue = state.getSelectedIssue();
        if (appInsightsIssue == null) {
            return "";
        }
        AppInsightsIssue selectedIssue = appInsightsIssue;
        Object object = state.getSelectedEvent();
        if (object == null || (object = object.getEventId()) == null) {
            return "";
        }
        Object eventKey = object;
        return FirebaseConsoleUrlUtilKt.getFirebaseConsoleUrl-RZWg_EU(connection2, (Pair<Long, Long>)timeFilter, version, selectedIssue.getId-R6c53LY(), (String)eventKey);
    }

    private static final void handlePermissionDenied$lambda$2$lambda$0(CrashlyticsInsightPermissionDeniedHandler this$0, ActionEvent it) {
        BrowserUtil.browse((String)this$0.getConsoleUrl());
    }

    private static final void handlePermissionDenied$lambda$2$lambda$1(CrashlyticsInsightPermissionDeniedHandler this$0, ActionEvent it) {
        BrowserUtil.browse((String)this$0.getConsoleUrl());
    }

    private static final Version getConsoleUrl$lambda$4$lambda$3(WithCount it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Version)it.getValue();
    }
}

