/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.insights.AppInsightsConfigurationManager;
import com.android.tools.idea.insights.AppInsightsModel;
import com.android.tools.idea.insights.AppInsightsProjectLevelController;
import com.android.tools.idea.insights.analytics.AppInsightsTracker;
import com.android.tools.idea.insights.analytics.AppInsightsTrackerImpl;
import com.android.tools.idea.insights.ui.AppInsightsTabPanel;
import com.android.tools.idea.insights.ui.AppInsightsTabProvider;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.services.firebase.FirebaseLoginFeature;
import com.google.services.firebase.insights.CrashlyticsConfigurationService;
import com.google.services.firebase.insights.CrashlyticsInsightsProvider;
import com.google.services.firebase.insights.ui.CrashlyticsTab;
import com.google.services.firebase.insights.ui.CrashlyticsTabProvider;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import icons.FirebaseIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.time.Clock;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/google/services/firebase/insights/ui/CrashlyticsTabProvider;", "Lcom/android/tools/idea/insights/ui/AppInsightsTabProvider;", "<init>", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "populateTab", "", "project", "Lcom/intellij/openapi/project/Project;", "tabPanel", "Lcom/android/tools/idea/insights/ui/AppInsightsTabPanel;", "getConfigurationManager", "Lcom/android/tools/idea/insights/AppInsightsConfigurationManager;", "tabShell", "controller", "Lcom/android/tools/idea/insights/AppInsightsProjectLevelController;", "tracker", "Lcom/android/tools/idea/insights/analytics/AppInsightsTracker;", "placeholderContent", "Ljavax/swing/JPanel;", "loggedOutErrorStateComponent", "initialSyncFailedComponent", "firebase"})
@SourceDebugExtension(value={"SMAP\nCrashlyticsTabProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashlyticsTabProvider.kt\ncom/google/services/firebase/insights/ui/CrashlyticsTabProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n*L\n1#1,210:1\n31#2,2:211\n31#2,2:213\n39#3,4:215\n39#3,4:219\n*S KotlinDebug\n*F\n+ 1 CrashlyticsTabProvider.kt\ncom/google/services/firebase/insights/ui/CrashlyticsTabProvider\n*L\n54#1:211,2\n97#1:213,2\n154#1:215,4\n159#1:219,4\n*E\n"})
public final class CrashlyticsTabProvider
implements AppInsightsTabProvider {
    @NotNull
    private final String displayName = CrashlyticsInsightsProvider.INSTANCE.getDisplayName();
    @NotNull
    private final Icon icon;

    public CrashlyticsTabProvider() {
        Icon icon = FirebaseIcons.ACTION_ICON;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ACTION_ICON");
        this.icon = icon;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    public void populateTab(@NotNull Project project, @NotNull AppInsightsTabPanel tabPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tabPanel, (String)"tabPanel");
        PropertiesComponent.getInstance((Project)project).setValue("com.google.services.firebase.aqiPopupShown", true);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CrashlyticsConfigurationService> serviceClass$iv = CrashlyticsConfigurationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AppInsightsConfigurationManager insightsService = ((CrashlyticsConfigurationService)object).getManager();
        AppInsightsTrackerImpl tracker = new AppInsightsTrackerImpl(project, AppInsightsTracker.ProductType.CRASHLYTICS);
        tabPanel.setComponent((JComponent)this.placeholderContent());
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)((Disposable)tabPanel), null, (int)2, null), (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(insightsService, tabPanel, this, tracker, project, null){
            int label;
            final /* synthetic */ AppInsightsConfigurationManager $insightsService;
            final /* synthetic */ AppInsightsTabPanel $tabPanel;
            final /* synthetic */ CrashlyticsTabProvider this$0;
            final /* synthetic */ AppInsightsTrackerImpl $tracker;
            final /* synthetic */ Project $project;
            {
                this.$insightsService = $insightsService;
                this.$tabPanel = $tabPanel;
                this.this$0 = $receiver;
                this.$tracker = $tracker;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Ref.BooleanRef isLoggedIn = new Ref.BooleanRef();
                        isLoggedIn.element = true;
                        boolean $i$f$service = false;
                        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
                        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        GoogleLoginService loginService = (GoogleLoginService)object3;
                        Flow flow2 = FlowKt.flowCombine((Flow)((Flow)this.$insightsService.getConfiguration()), (Flow)((Flow)loginService.getActiveUserFlow()), (Function3)((Function3)new Function3<AppInsightsModel, CredentialedUser, Continuation<? super AppInsightsModel>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AppInsightsModel config = (AppInsightsModel)this.L$0;
                                        return config;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(AppInsightsModel p1, CredentialedUser p2, Continuation<? super AppInsightsModel> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p1;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        this.label = 1;
                        Object object4 = flow2.collect(new FlowCollector(this.$tabPanel, this.this$0, isLoggedIn, this.$tracker, this.$project){
                            final /* synthetic */ AppInsightsTabPanel $tabPanel;
                            final /* synthetic */ CrashlyticsTabProvider this$0;
                            final /* synthetic */ Ref.BooleanRef $isLoggedIn;
                            final /* synthetic */ AppInsightsTrackerImpl $tracker;
                            final /* synthetic */ Project $project;
                            {
                                this.$tabPanel = $tabPanel;
                                this.this$0 = $receiver;
                                this.$isLoggedIn = $isLoggedIn;
                                this.$tracker = $tracker;
                                this.$project = $project;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(AppInsightsModel appInsightsModel, Continuation<? super Unit> $completion) {
                                AppInsightsModel appInsightsModel2 = appInsightsModel;
                                if (Intrinsics.areEqual((Object)appInsightsModel2, (Object)AppInsightsModel.Unauthenticated.INSTANCE)) {
                                    this.$tabPanel.setComponent((JComponent)CrashlyticsTabProvider.access$loggedOutErrorStateComponent(this.this$0));
                                    if (this.$isLoggedIn.element) {
                                        void $this$emit_u24lambda_u240;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder;
                                        this.$isLoggedIn.element = false;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder2 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.newBuilder();
                                        AppInsightsTrackerImpl appInsightsTrackerImpl = this.$tracker;
                                        boolean bl = false;
                                        $this$emit_u24lambda_u240.setEmptyState(AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.EmptyState.NO_LOGIN);
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails appQualityInsightsZeroStateDetails = builder.build();
                                        Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsZeroStateDetails, (String)"build(...)");
                                        appInsightsTrackerImpl.logZeroState(appQualityInsightsZeroStateDetails);
                                    }
                                } else if (appInsightsModel2 instanceof AppInsightsModel.Authenticated) {
                                    if (!this.$isLoggedIn.element) {
                                        this.$isLoggedIn.element = true;
                                    }
                                    CrashlyticsTabProvider.access$populateTab(this.this$0, this.$tabPanel, ((AppInsightsModel.Authenticated)appInsightsModel).getController(), this.$project, (AppInsightsTracker)this.$tracker);
                                } else if (!Intrinsics.areEqual((Object)appInsightsModel2, (Object)AppInsightsModel.Uninitialized.INSTANCE)) {
                                    if (Intrinsics.areEqual((Object)appInsightsModel2, (Object)AppInsightsModel.InitializationFailed.INSTANCE)) {
                                        this.$tabPanel.setComponent((JComponent)CrashlyticsTabProvider.access$initialSyncFailedComponent(this.this$0));
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public AppInsightsConfigurationManager getConfigurationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CrashlyticsConfigurationService> serviceClass$iv = CrashlyticsConfigurationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((CrashlyticsConfigurationService)object).getManager();
    }

    private final void populateTab(AppInsightsTabPanel tabShell, AppInsightsProjectLevelController controller, Project project, AppInsightsTracker tracker) {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
        CrashlyticsTab tab = new CrashlyticsTab(controller, clock, project, tracker, (Disposable)tabShell);
        tabShell.setComponent((JComponent)tab);
    }

    private final JPanel placeholderContent() {
        return new JPanel(){
            private final placeholderContent.text.1 text;
            {
                void it;
                StatusText statusText;
                StatusText statusText2 = statusText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return true;
                    }
                };
                var var4_3 = this;
                boolean bl = false;
                it.appendLine("Waiting for initial sync...", SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
                it.attachTo((Component)this);
                var4_3.text = statusText;
            }

            public void paint(Graphics g) {
                super.paint(g);
                this.text.paint(this, g);
            }
        };
    }

    private final JPanel loggedOutErrorStateComponent() {
        StatusText statusText;
        StatusText $this$loggedOutErrorStateComponent_u24lambda_u243 = statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        boolean bl = false;
        $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine(FirebaseIcons.FIREBASE_LOGO, "", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine("See real-world app quality insights here", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, null);
        if (GoogleLoginService.Companion.getInstance().isLoggedIn()) {
            $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine("Authorize", SimpleTextAttributes.LINK_ATTRIBUTES, CrashlyticsTabProvider::loggedOutErrorStateComponent$lambda$3$lambda$0);
            v0 = $this$loggedOutErrorStateComponent_u24lambda_u243.appendText(" Android Studio to connect to your Firebase Account");
        } else {
            $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine("Log in", SimpleTextAttributes.LINK_ATTRIBUTES, CrashlyticsTabProvider::loggedOutErrorStateComponent$lambda$3$lambda$1);
            v0 = $this$loggedOutErrorStateComponent_u24lambda_u243.appendText(" to Android Studio to connect to your Firebase Account");
        }
        $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine("");
        $this$loggedOutErrorStateComponent_u24lambda_u243.appendLine(AllIcons.General.ContextHelp, "More Info", SimpleTextAttributes.LINK_ATTRIBUTES, CrashlyticsTabProvider::loggedOutErrorStateComponent$lambda$3$lambda$2);
        StatusText loggedOutText2 = statusText;
        return new JPanel(loggedOutText2){
            final /* synthetic */ loggedOutErrorStateComponent.loggedOutText.1 $loggedOutText;
            {
                this.$loggedOutText = $loggedOutText;
                $loggedOutText.attachTo(this);
            }

            public void paint(Graphics g) {
                super.paint(g);
                this.$loggedOutText.paint(this, g);
            }
        };
    }

    private final JPanel initialSyncFailedComponent() {
        StatusText statusText;
        StatusText $this$initialSyncFailedComponent_u24lambda_u244 = statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        boolean bl = false;
        $this$initialSyncFailedComponent_u24lambda_u244.appendLine("Could not detect Firebase apps due to Gradle Sync failure at startup");
        $this$initialSyncFailedComponent_u24lambda_u244.appendLine("Please fix the error and re-sync to view Crashlytics");
        StatusText failureText2 = statusText;
        return new JPanel(failureText2){
            final /* synthetic */ initialSyncFailedComponent.failureText.1 $failureText;
            {
                this.$failureText = $failureText;
                $failureText.attachTo(this);
            }

            public void paint(Graphics g) {
                super.paint(g);
                this.$failureText.paint(this, g);
            }
        };
    }

    private static final void loggedOutErrorStateComponent$lambda$3$lambda$0(ActionEvent it) {
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        LoginFeature.logInAsync$default((LoginFeature)loginFeature, null, null, null, (int)7, null);
    }

    private static final void loggedOutErrorStateComponent$lambda$3$lambda$1(ActionEvent it) {
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(FirebaseLoginFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(FirebaseLoginFeature.class) + ". Is your extension registered properly?");
        }
        LoginFeature.logInAsync$default((LoginFeature)loginFeature, null, null, null, (int)7, null);
    }

    private static final void loggedOutErrorStateComponent$lambda$3$lambda$2(ActionEvent it) {
        BrowserUtil.browse((String)" https://d.android.com/r/studio-ui/app-quality-insights/crashlytics/help ");
    }

    public static final /* synthetic */ JPanel access$loggedOutErrorStateComponent(CrashlyticsTabProvider $this) {
        return $this.loggedOutErrorStateComponent();
    }

    public static final /* synthetic */ void access$populateTab(CrashlyticsTabProvider $this, AppInsightsTabPanel tabShell, AppInsightsProjectLevelController controller, Project project, AppInsightsTracker tracker) {
        $this.populateTab(tabShell, controller, project, tracker);
    }

    public static final /* synthetic */ JPanel access$initialSyncFailedComponent(CrashlyticsTabProvider $this) {
        return $this.initialSyncFailedComponent();
    }
}

