/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import androidx.annotation.OpenForTesting;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.AuthorizationCodeFlowWithState;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginService;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginStateStore;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.OAuthDataStore;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.OAuthLocalServerReceiver;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.UserAccountInfoResponseHolder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0017J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0017J\b\u0010 \u001a\u00020\u0010H\u0016J\u0017\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0018H\u0011\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020&H\u0016J\u0016\u0010'\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J\u0016\u0010*\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J\u000f\u0010+\u001a\u0004\u0018\u00010\u0010H\u0011\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u0016H\u0016J\b\u0010.\u001a\u00020&H\u0017J\b\u0010/\u001a\u00020\u0010H\u0002J\u0012\u00100\u001a\u00020\u00162\b\u00101\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceImpl;", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginService;", "intellijLoginClient", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;)V", "googleLoginStateStore", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginStateStore;", "gson", "Lcom/google/gson/Gson;", "gsonFactory", "Lcom/google/api/client/json/gson/GsonFactory;", "kotlin.jvm.PlatformType", "netHttpTransport", "Lcom/google/api/client/http/javanet/NetHttpTransport;", "oAuthScopes", "", "", "oauthDataStore", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthDataStore;", "receiver", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthLocalServerReceiver;", "abortLogin", "", "createCredentials", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleCredential;", "deleteAdc", "getEmail", "getGoogleLoginStateStore", "getLoginCredentials", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginCredential;", "getOauth2RootUrl", "getOauthDataStore", "getOpenidConnectRootUrl", "getRequestFactory", "Lcom/google/api/client/http/HttpRequestFactory;", "googleCredential", "getRequestFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "isLoggedIn", "", "logInWithLocalServer", "onComplete", "Lkotlin/Function0;", "logOut", "queryEmail", "queryEmail$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "refreshCredentials", "revokeAccessToken", "revokeTokenUrl", "stageAdc", "quotaProjectId", "tokenServerUrl", "Ljava/net/URL;", "userInfoUrl", "Companion", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
@SourceDebugExtension(value={"SMAP\nGoogleLoginServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginServiceImpl.kt\ncom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
public class GoogleLoginServiceImpl
implements GoogleLoginService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntellijLoginClient intellijLoginClient;
    private GoogleLoginStateStore googleLoginStateStore;
    private OAuthDataStore oauthDataStore;
    @NotNull
    private final NetHttpTransport netHttpTransport;
    @NotNull
    private final Gson gson;
    private final GsonFactory gsonFactory;
    @Nullable
    private OAuthLocalServerReceiver receiver;
    @NotNull
    private final Set<String> oAuthScopes;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public GoogleLoginServiceImpl(@NotNull IntellijLoginClient intellijLoginClient) {
        void $this$oAuthScopes_u24lambda_u240;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)intellijLoginClient, (String)"intellijLoginClient");
        this.intellijLoginClient = intellijLoginClient;
        this.netHttpTransport = new NetHttpTransport();
        this.gson = new Gson();
        this.gsonFactory = GsonFactory.getDefaultInstance();
        HashSet hashSet2 = hashSet = new HashSet();
        GoogleLoginServiceImpl googleLoginServiceImpl = this;
        boolean bl = false;
        $this$oAuthScopes_u24lambda_u240.add("https://www.googleapis.com/auth/userinfo.email");
        $this$oAuthScopes_u24lambda_u240.add("https://www.googleapis.com/auth/cloud-platform");
        Set set = Collections.unmodifiableSet(hashSet);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        googleLoginServiceImpl.oAuthScopes = set;
    }

    @Override
    public void logInWithLocalServer(@NotNull Function0<Unit> onComplete) throws IOException {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        OAuthLocalServerReceiver receiver = new OAuthLocalServerReceiver(null, 0, this.intellijLoginClient.getLandingPages().getSuccessPage(), this.intellijLoginClient.getLandingPages().getFailurePage(), 3, null);
        AuthorizationCodeFlow authFlow = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), (HttpTransport)this.netHttpTransport, (JsonFactory)this.gsonFactory, new GenericUrl(this.tokenServerUrl()), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.intellijLoginClient.getOAuthClientId(), this.intellijLoginClient.getOAuthClientNotSoSecret()), this.intellijLoginClient.getOAuthClientId(), "https://accounts.google.com/o/oauth2/auth").setScopes((Collection)this.oAuthScopes).enablePKCE().build();
        String string = new BigInteger(130, new SecureRandom()).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String state = string;
        receiver.setState(state);
        Intrinsics.checkNotNull((Object)authFlow);
        Credential credentials = new AuthorizationCodeFlowWithState(authFlow, receiver, state).authorize(null);
        GoogleLoginStateStore googleLoginStateStore = this.getGoogleLoginStateStore();
        Intrinsics.checkNotNull((Object)credentials);
        googleLoginStateStore.updateAndSaveUserCredentials(credentials);
        this.getGoogleLoginStateStore().updateAndSaveEmail(this.queryEmail$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib());
        receiver.stop();
        onComplete.invoke();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.getGoogleLoginStateStore().getEmail();
    }

    @Override
    @Nullable
    public GoogleLoginCredential getLoginCredentials() {
        return this.getGoogleLoginStateStore().getGoogleLoginCredential();
    }

    @Override
    public void refreshCredentials() {
        this.getGoogleLoginStateStore().refreshCredentials();
    }

    @Override
    public void stageAdc(@Nullable String quotaProjectId) {
        this.getGoogleLoginStateStore().stageAdc(quotaProjectId);
    }

    @Override
    public void deleteAdc() {
        this.getGoogleLoginStateStore().deleteAdc();
    }

    @Override
    public void logOut(@NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        this.revokeAccessToken();
        this.getGoogleLoginStateStore().logOutAndDeleteCredentials();
        onComplete.invoke();
    }

    @Override
    public boolean isLoggedIn() {
        return this.getGoogleLoginStateStore().isLoggedIn();
    }

    @Override
    public void abortLogin() {
        block0: {
            OAuthLocalServerReceiver oAuthLocalServerReceiver = this.receiver;
            if (oAuthLocalServerReceiver == null) break block0;
            oAuthLocalServerReceiver.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @OpenForTesting
    @Nullable
    public String queryEmail$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        String string;
        try {
            InputStreamReader inputStreamReader;
            GoogleCredential credentials = this.createCredentials();
            HttpRequest request = this.getRequestFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(credentials).buildGetRequest(new GenericUrl(this.userInfoUrl()));
            HttpResponse response = request.execute();
            Type type = new TypeToken<UserAccountInfoResponseHolder>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            Type responseData2 = type;
            Gson gson = this.gson;
            Object object = response;
            if (object != null && (object = object.getContent()) != null) {
                void it;
                Object object2 = object;
                Gson gson2 = gson;
                boolean bl = false;
                inputStreamReader = new InputStreamReader((InputStream)it, StandardCharsets.UTF_8);
                gson = gson2;
            } else {
                inputStreamReader = null;
            }
            Object object3 = gson.fromJson((Reader)inputStreamReader, responseData2);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
            UserAccountInfoResponseHolder userAccountInfoResponseHolder = (UserAccountInfoResponseHolder)object3;
            string = userAccountInfoResponseHolder.getEmail();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve email after Google service sign-in", e);
            string = null;
        }
        return string;
    }

    @VisibleForTesting
    @OpenForTesting
    @NotNull
    public HttpRequestFactory getRequestFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(@Nullable GoogleCredential googleCredential) {
        HttpRequestFactory httpRequestFactory = this.netHttpTransport.createRequestFactory((HttpRequestInitializer)googleCredential);
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestFactory, (String)"createRequestFactory(...)");
        return httpRequestFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GoogleCredential createCredentials() {
        Long l;
        GoogleCredential googleCredential;
        GoogleLoginCredential credentials = this.getLoginCredentials();
        GoogleCredential $this$createCredentials_u24lambda_u243 = googleCredential = new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.gsonFactory).setTransport((HttpTransport)this.netHttpTransport).setTokenServerUrl(new GenericUrl(this.tokenServerUrl())).setClientSecrets(this.intellijLoginClient.getOAuthClientId(), this.intellijLoginClient.getOAuthClientNotSoSecret()).build();
        boolean bl = false;
        GoogleLoginCredential googleLoginCredential = credentials;
        $this$createCredentials_u24lambda_u243.setAccessToken(googleLoginCredential != null ? googleLoginCredential.getAccessToken() : null);
        GoogleLoginCredential googleLoginCredential2 = credentials;
        $this$createCredentials_u24lambda_u243.setRefreshToken(googleLoginCredential2 != null ? googleLoginCredential2.getRefreshToken() : null);
        GoogleCredential googleCredential2 = $this$createCredentials_u24lambda_u243;
        Object object = credentials;
        if (object != null && (object = ((GoogleLoginCredential)object).getAccessTokenExpiryTimeInSeconds()) != null) {
            void it;
            long l2 = ((Number)object).longValue();
            GoogleCredential googleCredential3 = googleCredential2;
            boolean bl2 = false;
            l = (long)(it * (long)1000);
            googleCredential2 = googleCredential3;
        } else {
            l = null;
        }
        googleCredential2.setExpirationTimeMilliseconds(l);
        GoogleCredential googleCredential4 = googleCredential;
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential4, (String)"apply(...)");
        return googleCredential4;
    }

    @Override
    @VisibleForTesting
    @CanIgnoreReturnValue
    public boolean revokeAccessToken() {
        boolean bl;
        GoogleCredential credentials = this.createCredentials();
        String urlWithAccessToken = this.revokeTokenUrl() + credentials.getAccessToken();
        HttpContent httpContent2 = new HttpContent(){

            public void writeTo(@Nullable OutputStream out) {
            }

            public long getLength() {
                return 0L;
            }

            @NotNull
            public String getType() {
                return "application/x-www-form-urlencoded";
            }

            public boolean retrySupported() {
                return true;
            }
        };
        try {
            HttpRequest request = this.getRequestFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(credentials).buildPostRequest(new GenericUrl(urlWithAccessToken), httpContent2);
            HttpResponse response = request.execute();
            bl = response.isSuccessStatusCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to revoke the access token", e);
            bl = false;
        }
        return bl;
    }

    @OpenForTesting
    @NotNull
    public OAuthDataStore getOauthDataStore() {
        OAuthDataStore oAuthDataStore;
        if (this.oauthDataStore == null) {
            this.oauthDataStore = new OAuthDataStore(this.intellijLoginClient);
        }
        if ((oAuthDataStore = this.oauthDataStore) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oauthDataStore");
            oAuthDataStore = null;
        }
        return oAuthDataStore;
    }

    @OpenForTesting
    @NotNull
    public GoogleLoginStateStore getGoogleLoginStateStore() {
        GoogleLoginStateStore googleLoginStateStore;
        if (this.googleLoginStateStore == null) {
            this.googleLoginStateStore = new GoogleLoginStateStore(this.getOauthDataStore(), this.intellijLoginClient);
        }
        if ((googleLoginStateStore = this.googleLoginStateStore) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"googleLoginStateStore");
            googleLoginStateStore = null;
        }
        return googleLoginStateStore;
    }

    @NotNull
    public String getOauth2RootUrl() {
        return "https://oauth2.googleapis.com/";
    }

    private final URL tokenServerUrl() {
        return new URL(new URL(this.getOauth2RootUrl()), "token");
    }

    private final String revokeTokenUrl() {
        String string = new URL(new URL(this.getOauth2RootUrl()), "revoke?token=").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String getOpenidConnectRootUrl() {
        return "https://openidconnect.googleapis.com/";
    }

    private final URL userInfoUrl() {
        return new URL(new URL(this.getOpenidConnectRootUrl()), "v1/userinfo");
    }

    static {
        Logger logger = Logger.getLogger(Companion.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GoogleLoginServiceImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceImpl$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

