/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudcode_pa.v1internal;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudcode_pa.v1internal.CloudCodePrivateRequest;
import com.google.api.services.cloudcode_pa.v1internal.CloudCodePrivateRequestInitializer;
import com.google.api.services.cloudcode_pa.v1internal.model.CodeAssistGlobalUserSettingResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.CompleteCodeRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.CompleteCodeResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.Empty;
import com.google.api.services.cloudcode_pa.v1internal.model.GenerateChatRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.GenerateChatResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.GenerateCodeRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.GenerateCodeResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.ListAgentsResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.ListCloudAICompanionProjectsResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.ListExperimentsRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.ListExperimentsResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.LoadCodeAssistRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.LoadCodeAssistResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.MigrateDatabaseCodeRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.MigrateDatabaseCodeResponse;
import com.google.api.services.cloudcode_pa.v1internal.model.OnboardUserRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.Operation;
import com.google.api.services.cloudcode_pa.v1internal.model.RecordCodeAssistMetricsRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.SetCodeAssistGlobalUserSettingRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.TransformCodeRequest;
import com.google.api.services.cloudcode_pa.v1internal.model.TransformCodeResponse;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudCodePrivate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudcode-pa.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudcode-pa.googleapis.com/";

    public CloudCodePrivate(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudCodePrivate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public V1internal v1internal() {
        return new V1internal();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0-SNAPSHOT of the Cloud Code Private API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://cloudcode-pa.googleapis.com/", CloudCodePrivate.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudCodePrivate.DEFAULT_BATCH_PATH);
        }

        public CloudCodePrivate build() {
            return new CloudCodePrivate(this);
        }

        @CanIgnoreReturnValue
        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        @CanIgnoreReturnValue
        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        @CanIgnoreReturnValue
        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        @CanIgnoreReturnValue
        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        @CanIgnoreReturnValue
        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        @CanIgnoreReturnValue
        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        @CanIgnoreReturnValue
        public Builder setCloudCodePrivateRequestInitializer(CloudCodePrivateRequestInitializer cloudcodeprivateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudcodeprivateRequestInitializer);
        }

        @CanIgnoreReturnValue
        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends CloudCodePrivateRequest<Operation> {
            private static final String REST_PATH = "v1internal/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudCodePrivate.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudCodePrivate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            @CanIgnoreReturnValue
            public Get setName(String name) {
                if (!CloudCodePrivate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class V1internal {
        public CompleteCode completeCode(CompleteCodeRequest content) throws IOException {
            CompleteCode result = new CompleteCode(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateChat generateChat(GenerateChatRequest content) throws IOException {
            GenerateChat result = new GenerateChat(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateCode generateCode(GenerateCodeRequest content) throws IOException {
            GenerateCode result = new GenerateCode(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetCodeAssistGlobalUserSetting getCodeAssistGlobalUserSetting() throws IOException {
            GetCodeAssistGlobalUserSetting result = new GetCodeAssistGlobalUserSetting(this);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAgents listAgents() throws IOException {
            ListAgents result = new ListAgents(this);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListCloudAICompanionProjects listCloudAICompanionProjects() throws IOException {
            ListCloudAICompanionProjects result = new ListCloudAICompanionProjects(this);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListExperiments listExperiments(ListExperimentsRequest content) throws IOException {
            ListExperiments result = new ListExperiments(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public LoadCodeAssist loadCodeAssist(LoadCodeAssistRequest content) throws IOException {
            LoadCodeAssist result = new LoadCodeAssist(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public MigrateDatabaseCode migrateDatabaseCode(MigrateDatabaseCodeRequest content) throws IOException {
            MigrateDatabaseCode result = new MigrateDatabaseCode(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public OnboardUser onboardUser(OnboardUserRequest content) throws IOException {
            OnboardUser result = new OnboardUser(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RecordCodeAssistMetrics recordCodeAssistMetrics(RecordCodeAssistMetricsRequest content) throws IOException {
            RecordCodeAssistMetrics result = new RecordCodeAssistMetrics(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetCodeAssistGlobalUserSetting setCodeAssistGlobalUserSetting(SetCodeAssistGlobalUserSettingRequest content) throws IOException {
            SetCodeAssistGlobalUserSetting result = new SetCodeAssistGlobalUserSetting(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TransformCode transformCode(TransformCodeRequest content) throws IOException {
            TransformCode result = new TransformCode(this, content);
            CloudCodePrivate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class CompleteCode
        extends CloudCodePrivateRequest<CompleteCodeResponse> {
            private static final String REST_PATH = "v1internal:completeCode";

            protected CompleteCode(V1internal this$1, CompleteCodeRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, CompleteCodeResponse.class);
            }

            @CanIgnoreReturnValue
            public CompleteCode set$Xgafv(String $Xgafv) {
                return (CompleteCode)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public CompleteCode setAccessToken(String accessToken) {
                return (CompleteCode)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public CompleteCode setAlt(String alt) {
                return (CompleteCode)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public CompleteCode setCallback(String callback) {
                return (CompleteCode)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public CompleteCode setFields(String fields) {
                return (CompleteCode)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public CompleteCode setKey(String key) {
                return (CompleteCode)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public CompleteCode setOauthToken(String oauthToken) {
                return (CompleteCode)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public CompleteCode setPrettyPrint(Boolean prettyPrint) {
                return (CompleteCode)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public CompleteCode setQuotaUser(String quotaUser) {
                return (CompleteCode)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public CompleteCode setUploadType(String uploadType) {
                return (CompleteCode)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public CompleteCode setUploadProtocol(String uploadProtocol) {
                return (CompleteCode)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public CompleteCode set(String parameterName, Object value) {
                return (CompleteCode)super.set(parameterName, value);
            }
        }

        public class GenerateChat
        extends CloudCodePrivateRequest<GenerateChatResponse> {
            private static final String REST_PATH = "v1internal:generateChat";

            protected GenerateChat(V1internal this$1, GenerateChatRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, GenerateChatResponse.class);
            }

            @CanIgnoreReturnValue
            public GenerateChat set$Xgafv(String $Xgafv) {
                return (GenerateChat)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public GenerateChat setAccessToken(String accessToken) {
                return (GenerateChat)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public GenerateChat setAlt(String alt) {
                return (GenerateChat)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public GenerateChat setCallback(String callback) {
                return (GenerateChat)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public GenerateChat setFields(String fields) {
                return (GenerateChat)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public GenerateChat setKey(String key) {
                return (GenerateChat)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public GenerateChat setOauthToken(String oauthToken) {
                return (GenerateChat)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public GenerateChat setPrettyPrint(Boolean prettyPrint) {
                return (GenerateChat)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public GenerateChat setQuotaUser(String quotaUser) {
                return (GenerateChat)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public GenerateChat setUploadType(String uploadType) {
                return (GenerateChat)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public GenerateChat setUploadProtocol(String uploadProtocol) {
                return (GenerateChat)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public GenerateChat set(String parameterName, Object value) {
                return (GenerateChat)super.set(parameterName, value);
            }
        }

        public class GenerateCode
        extends CloudCodePrivateRequest<GenerateCodeResponse> {
            private static final String REST_PATH = "v1internal:generateCode";

            protected GenerateCode(V1internal this$1, GenerateCodeRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, GenerateCodeResponse.class);
            }

            @CanIgnoreReturnValue
            public GenerateCode set$Xgafv(String $Xgafv) {
                return (GenerateCode)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public GenerateCode setAccessToken(String accessToken) {
                return (GenerateCode)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public GenerateCode setAlt(String alt) {
                return (GenerateCode)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public GenerateCode setCallback(String callback) {
                return (GenerateCode)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public GenerateCode setFields(String fields) {
                return (GenerateCode)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public GenerateCode setKey(String key) {
                return (GenerateCode)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public GenerateCode setOauthToken(String oauthToken) {
                return (GenerateCode)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public GenerateCode setPrettyPrint(Boolean prettyPrint) {
                return (GenerateCode)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public GenerateCode setQuotaUser(String quotaUser) {
                return (GenerateCode)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public GenerateCode setUploadType(String uploadType) {
                return (GenerateCode)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public GenerateCode setUploadProtocol(String uploadProtocol) {
                return (GenerateCode)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public GenerateCode set(String parameterName, Object value) {
                return (GenerateCode)super.set(parameterName, value);
            }
        }

        public class GetCodeAssistGlobalUserSetting
        extends CloudCodePrivateRequest<CodeAssistGlobalUserSettingResponse> {
            private static final String REST_PATH = "v1internal:getCodeAssistGlobalUserSetting";
            @Key
            private String cloudaicompanionProject;

            protected GetCodeAssistGlobalUserSetting(V1internal this$1) {
                super(this$1.CloudCodePrivate.this, "GET", REST_PATH, null, CodeAssistGlobalUserSettingResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting set$Xgafv(String $Xgafv) {
                return (GetCodeAssistGlobalUserSetting)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setAccessToken(String accessToken) {
                return (GetCodeAssistGlobalUserSetting)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setAlt(String alt) {
                return (GetCodeAssistGlobalUserSetting)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setCallback(String callback) {
                return (GetCodeAssistGlobalUserSetting)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setFields(String fields) {
                return (GetCodeAssistGlobalUserSetting)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setKey(String key) {
                return (GetCodeAssistGlobalUserSetting)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setOauthToken(String oauthToken) {
                return (GetCodeAssistGlobalUserSetting)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setPrettyPrint(Boolean prettyPrint) {
                return (GetCodeAssistGlobalUserSetting)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setQuotaUser(String quotaUser) {
                return (GetCodeAssistGlobalUserSetting)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setUploadType(String uploadType) {
                return (GetCodeAssistGlobalUserSetting)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setUploadProtocol(String uploadProtocol) {
                return (GetCodeAssistGlobalUserSetting)super.setUploadProtocol(uploadProtocol);
            }

            public String getCloudaicompanionProject() {
                return this.cloudaicompanionProject;
            }

            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting setCloudaicompanionProject(String cloudaicompanionProject) {
                this.cloudaicompanionProject = cloudaicompanionProject;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public GetCodeAssistGlobalUserSetting set(String parameterName, Object value) {
                return (GetCodeAssistGlobalUserSetting)super.set(parameterName, value);
            }
        }

        public class ListAgents
        extends CloudCodePrivateRequest<ListAgentsResponse> {
            private static final String REST_PATH = "v1internal:listAgents";

            protected ListAgents(V1internal this$1) {
                super(this$1.CloudCodePrivate.this, "GET", REST_PATH, null, ListAgentsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public ListAgents set$Xgafv(String $Xgafv) {
                return (ListAgents)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public ListAgents setAccessToken(String accessToken) {
                return (ListAgents)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public ListAgents setAlt(String alt) {
                return (ListAgents)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public ListAgents setCallback(String callback) {
                return (ListAgents)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public ListAgents setFields(String fields) {
                return (ListAgents)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public ListAgents setKey(String key) {
                return (ListAgents)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public ListAgents setOauthToken(String oauthToken) {
                return (ListAgents)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public ListAgents setPrettyPrint(Boolean prettyPrint) {
                return (ListAgents)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public ListAgents setQuotaUser(String quotaUser) {
                return (ListAgents)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public ListAgents setUploadType(String uploadType) {
                return (ListAgents)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public ListAgents setUploadProtocol(String uploadProtocol) {
                return (ListAgents)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public ListAgents set(String parameterName, Object value) {
                return (ListAgents)super.set(parameterName, value);
            }
        }

        public class ListCloudAICompanionProjects
        extends CloudCodePrivateRequest<ListCloudAICompanionProjectsResponse> {
            private static final String REST_PATH = "v1internal:listCloudAICompanionProjects";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String filter;

            protected ListCloudAICompanionProjects(V1internal this$1) {
                super(this$1.CloudCodePrivate.this, "GET", REST_PATH, null, ListCloudAICompanionProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects set$Xgafv(String $Xgafv) {
                return (ListCloudAICompanionProjects)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setAccessToken(String accessToken) {
                return (ListCloudAICompanionProjects)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setAlt(String alt) {
                return (ListCloudAICompanionProjects)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setCallback(String callback) {
                return (ListCloudAICompanionProjects)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setFields(String fields) {
                return (ListCloudAICompanionProjects)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setKey(String key) {
                return (ListCloudAICompanionProjects)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setOauthToken(String oauthToken) {
                return (ListCloudAICompanionProjects)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setPrettyPrint(Boolean prettyPrint) {
                return (ListCloudAICompanionProjects)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setQuotaUser(String quotaUser) {
                return (ListCloudAICompanionProjects)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setUploadType(String uploadType) {
                return (ListCloudAICompanionProjects)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setUploadProtocol(String uploadProtocol) {
                return (ListCloudAICompanionProjects)super.setUploadProtocol(uploadProtocol);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            @Override
            @CanIgnoreReturnValue
            public ListCloudAICompanionProjects set(String parameterName, Object value) {
                return (ListCloudAICompanionProjects)super.set(parameterName, value);
            }
        }

        public class ListExperiments
        extends CloudCodePrivateRequest<ListExperimentsResponse> {
            private static final String REST_PATH = "v1internal:listExperiments";

            protected ListExperiments(V1internal this$1, ListExperimentsRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, ListExperimentsResponse.class);
            }

            @CanIgnoreReturnValue
            public ListExperiments set$Xgafv(String $Xgafv) {
                return (ListExperiments)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public ListExperiments setAccessToken(String accessToken) {
                return (ListExperiments)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public ListExperiments setAlt(String alt) {
                return (ListExperiments)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public ListExperiments setCallback(String callback) {
                return (ListExperiments)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public ListExperiments setFields(String fields) {
                return (ListExperiments)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public ListExperiments setKey(String key) {
                return (ListExperiments)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public ListExperiments setOauthToken(String oauthToken) {
                return (ListExperiments)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public ListExperiments setPrettyPrint(Boolean prettyPrint) {
                return (ListExperiments)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public ListExperiments setQuotaUser(String quotaUser) {
                return (ListExperiments)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public ListExperiments setUploadType(String uploadType) {
                return (ListExperiments)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public ListExperiments setUploadProtocol(String uploadProtocol) {
                return (ListExperiments)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public ListExperiments set(String parameterName, Object value) {
                return (ListExperiments)super.set(parameterName, value);
            }
        }

        public class LoadCodeAssist
        extends CloudCodePrivateRequest<LoadCodeAssistResponse> {
            private static final String REST_PATH = "v1internal:loadCodeAssist";

            protected LoadCodeAssist(V1internal this$1, LoadCodeAssistRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, LoadCodeAssistResponse.class);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist set$Xgafv(String $Xgafv) {
                return (LoadCodeAssist)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setAccessToken(String accessToken) {
                return (LoadCodeAssist)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setAlt(String alt) {
                return (LoadCodeAssist)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setCallback(String callback) {
                return (LoadCodeAssist)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setFields(String fields) {
                return (LoadCodeAssist)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setKey(String key) {
                return (LoadCodeAssist)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setOauthToken(String oauthToken) {
                return (LoadCodeAssist)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setPrettyPrint(Boolean prettyPrint) {
                return (LoadCodeAssist)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setQuotaUser(String quotaUser) {
                return (LoadCodeAssist)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setUploadType(String uploadType) {
                return (LoadCodeAssist)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public LoadCodeAssist setUploadProtocol(String uploadProtocol) {
                return (LoadCodeAssist)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public LoadCodeAssist set(String parameterName, Object value) {
                return (LoadCodeAssist)super.set(parameterName, value);
            }
        }

        public class MigrateDatabaseCode
        extends CloudCodePrivateRequest<MigrateDatabaseCodeResponse> {
            private static final String REST_PATH = "v1internal:migrateDatabaseCode";

            protected MigrateDatabaseCode(V1internal this$1, MigrateDatabaseCodeRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, MigrateDatabaseCodeResponse.class);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode set$Xgafv(String $Xgafv) {
                return (MigrateDatabaseCode)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setAccessToken(String accessToken) {
                return (MigrateDatabaseCode)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setAlt(String alt) {
                return (MigrateDatabaseCode)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setCallback(String callback) {
                return (MigrateDatabaseCode)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setFields(String fields) {
                return (MigrateDatabaseCode)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setKey(String key) {
                return (MigrateDatabaseCode)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setOauthToken(String oauthToken) {
                return (MigrateDatabaseCode)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setPrettyPrint(Boolean prettyPrint) {
                return (MigrateDatabaseCode)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setQuotaUser(String quotaUser) {
                return (MigrateDatabaseCode)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setUploadType(String uploadType) {
                return (MigrateDatabaseCode)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public MigrateDatabaseCode setUploadProtocol(String uploadProtocol) {
                return (MigrateDatabaseCode)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public MigrateDatabaseCode set(String parameterName, Object value) {
                return (MigrateDatabaseCode)super.set(parameterName, value);
            }
        }

        public class OnboardUser
        extends CloudCodePrivateRequest<Operation> {
            private static final String REST_PATH = "v1internal:onboardUser";

            protected OnboardUser(V1internal this$1, OnboardUserRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            @CanIgnoreReturnValue
            public OnboardUser set$Xgafv(String $Xgafv) {
                return (OnboardUser)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public OnboardUser setAccessToken(String accessToken) {
                return (OnboardUser)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public OnboardUser setAlt(String alt) {
                return (OnboardUser)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public OnboardUser setCallback(String callback) {
                return (OnboardUser)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public OnboardUser setFields(String fields) {
                return (OnboardUser)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public OnboardUser setKey(String key) {
                return (OnboardUser)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public OnboardUser setOauthToken(String oauthToken) {
                return (OnboardUser)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public OnboardUser setPrettyPrint(Boolean prettyPrint) {
                return (OnboardUser)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public OnboardUser setQuotaUser(String quotaUser) {
                return (OnboardUser)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public OnboardUser setUploadType(String uploadType) {
                return (OnboardUser)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public OnboardUser setUploadProtocol(String uploadProtocol) {
                return (OnboardUser)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public OnboardUser set(String parameterName, Object value) {
                return (OnboardUser)super.set(parameterName, value);
            }
        }

        public class RecordCodeAssistMetrics
        extends CloudCodePrivateRequest<Empty> {
            private static final String REST_PATH = "v1internal:recordCodeAssistMetrics";

            protected RecordCodeAssistMetrics(V1internal this$1, RecordCodeAssistMetricsRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics set$Xgafv(String $Xgafv) {
                return (RecordCodeAssistMetrics)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setAccessToken(String accessToken) {
                return (RecordCodeAssistMetrics)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setAlt(String alt) {
                return (RecordCodeAssistMetrics)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setCallback(String callback) {
                return (RecordCodeAssistMetrics)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setFields(String fields) {
                return (RecordCodeAssistMetrics)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setKey(String key) {
                return (RecordCodeAssistMetrics)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setOauthToken(String oauthToken) {
                return (RecordCodeAssistMetrics)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setPrettyPrint(Boolean prettyPrint) {
                return (RecordCodeAssistMetrics)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setQuotaUser(String quotaUser) {
                return (RecordCodeAssistMetrics)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setUploadType(String uploadType) {
                return (RecordCodeAssistMetrics)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics setUploadProtocol(String uploadProtocol) {
                return (RecordCodeAssistMetrics)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public RecordCodeAssistMetrics set(String parameterName, Object value) {
                return (RecordCodeAssistMetrics)super.set(parameterName, value);
            }
        }

        public class SetCodeAssistGlobalUserSetting
        extends CloudCodePrivateRequest<CodeAssistGlobalUserSettingResponse> {
            private static final String REST_PATH = "v1internal:setCodeAssistGlobalUserSetting";

            protected SetCodeAssistGlobalUserSetting(V1internal this$1, SetCodeAssistGlobalUserSettingRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, CodeAssistGlobalUserSettingResponse.class);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting set$Xgafv(String $Xgafv) {
                return (SetCodeAssistGlobalUserSetting)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setAccessToken(String accessToken) {
                return (SetCodeAssistGlobalUserSetting)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setAlt(String alt) {
                return (SetCodeAssistGlobalUserSetting)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setCallback(String callback) {
                return (SetCodeAssistGlobalUserSetting)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setFields(String fields) {
                return (SetCodeAssistGlobalUserSetting)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setKey(String key) {
                return (SetCodeAssistGlobalUserSetting)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setOauthToken(String oauthToken) {
                return (SetCodeAssistGlobalUserSetting)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setPrettyPrint(Boolean prettyPrint) {
                return (SetCodeAssistGlobalUserSetting)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setQuotaUser(String quotaUser) {
                return (SetCodeAssistGlobalUserSetting)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setUploadType(String uploadType) {
                return (SetCodeAssistGlobalUserSetting)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting setUploadProtocol(String uploadProtocol) {
                return (SetCodeAssistGlobalUserSetting)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public SetCodeAssistGlobalUserSetting set(String parameterName, Object value) {
                return (SetCodeAssistGlobalUserSetting)super.set(parameterName, value);
            }
        }

        public class TransformCode
        extends CloudCodePrivateRequest<TransformCodeResponse> {
            private static final String REST_PATH = "v1internal:transformCode";

            protected TransformCode(V1internal this$1, TransformCodeRequest content) {
                super(this$1.CloudCodePrivate.this, "POST", REST_PATH, (Object)content, TransformCodeResponse.class);
            }

            @CanIgnoreReturnValue
            public TransformCode set$Xgafv(String $Xgafv) {
                return (TransformCode)super.set$Xgafv($Xgafv);
            }

            @CanIgnoreReturnValue
            public TransformCode setAccessToken(String accessToken) {
                return (TransformCode)super.setAccessToken(accessToken);
            }

            @CanIgnoreReturnValue
            public TransformCode setAlt(String alt) {
                return (TransformCode)super.setAlt(alt);
            }

            @CanIgnoreReturnValue
            public TransformCode setCallback(String callback) {
                return (TransformCode)super.setCallback(callback);
            }

            @CanIgnoreReturnValue
            public TransformCode setFields(String fields) {
                return (TransformCode)super.setFields(fields);
            }

            @CanIgnoreReturnValue
            public TransformCode setKey(String key) {
                return (TransformCode)super.setKey(key);
            }

            @CanIgnoreReturnValue
            public TransformCode setOauthToken(String oauthToken) {
                return (TransformCode)super.setOauthToken(oauthToken);
            }

            @CanIgnoreReturnValue
            public TransformCode setPrettyPrint(Boolean prettyPrint) {
                return (TransformCode)super.setPrettyPrint(prettyPrint);
            }

            @CanIgnoreReturnValue
            public TransformCode setQuotaUser(String quotaUser) {
                return (TransformCode)super.setQuotaUser(quotaUser);
            }

            @CanIgnoreReturnValue
            public TransformCode setUploadType(String uploadType) {
                return (TransformCode)super.setUploadType(uploadType);
            }

            @CanIgnoreReturnValue
            public TransformCode setUploadProtocol(String uploadProtocol) {
                return (TransformCode)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            @CanIgnoreReturnValue
            public TransformCode set(String parameterName, Object value) {
                return (TransformCode)super.set(parameterName, value);
            }
        }
    }
}

