/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.util.PsiUtils;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.google.gct.idea.appengine.validation.InvalidAnnotationException;
import com.google.gct.idea.appengine.validation.MissingAttributeException;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestSignatureInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("unique.rest.signature.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return EndpointBundle.message("unique.rest.signature.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return EndpointBundle.message("unique.rest.signature.short.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)aClass)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)aClass)) {
                    return;
                }
                PsiMethod[] allMethods = aClass.getMethods();
                HashMap restfulSignatures = Maps.newHashMap();
                for (PsiMethod aMethod : allMethods) {
                    this.validateRestSignatureUnique(aMethod, restfulSignatures);
                }
            }

            private void validateRestSignatureUnique(PsiMethod psiMethod, Map<String, PsiMethod> restfulSignatures) {
                if (!EndpointUtilities.isApiMethod(psiMethod)) {
                    return;
                }
                if (psiMethod.isConstructor()) {
                    return;
                }
                String restSignature = RestSignatureInspection.this.getRestfulSignature(psiMethod);
                PsiMethod seenMethod = restfulSignatures.get(restSignature);
                if (seenMethod == null) {
                    restfulSignatures.put(restSignature, psiMethod);
                } else {
                    holder.registerProblem((PsiElement)psiMethod, RestSignatureInspection.this.getErrorMessage(restSignature, psiMethod.getName(), seenMethod.getName()), LocalQuickFix.EMPTY_ARRAY);
                }
            }
        };
    }

    public String getRestfulSignature(PsiMethod psiMethod) {
        return this.getHttpMethod(psiMethod) + " " + this.getPath(psiMethod).replaceAll("\\{([^\\}]*)\\}", "\\{\\}");
    }

    public String getHttpMethod(PsiMethod psiMethod) {
        PsiModifierList modifierList = psiMethod.getModifierList();
        String httpMethod = null;
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            try {
                httpMethod = this.getAttributeFromAnnotation(annotation, "com.google.api.server.spi.config.ApiMethod", "httpMethod");
            }
            catch (InvalidAnnotationException invalidAnnotationException) {
            }
            catch (MissingAttributeException e) {
                break;
            }
            if (httpMethod == null || httpMethod.isEmpty()) continue;
            return httpMethod;
        }
        return this.getDefaultRestMethod(psiMethod).getHttpMethod();
    }

    public String getPath(PsiMethod psiMethod) {
        PsiModifierList modifierList = psiMethod.getModifierList();
        String path = null;
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            try {
                path = this.getAttributeFromAnnotation(annotation, "com.google.api.server.spi.config.ApiMethod", "path");
            }
            catch (InvalidAnnotationException invalidAnnotationException) {
            }
            catch (MissingAttributeException e) {
                break;
            }
            if (path == null) continue;
            if (path.isEmpty()) break;
            return path;
        }
        return this.getDefaultPath(psiMethod);
    }

    private String getDefaultPath(PsiMethod psiMethod) {
        String apiDefaultResource = this.getResourceProperty(psiMethod);
        if (apiDefaultResource != null) {
            return apiDefaultResource.toLowerCase() + this.getPathParameter(psiMethod);
        }
        String guessedResourceName = this.guessResourceName(psiMethod);
        if (guessedResourceName != null) {
            return guessedResourceName + this.getPathParameter(psiMethod);
        }
        return psiMethod.getName() + this.getPathParameter(psiMethod);
    }

    private RestMethod getDefaultRestMethod(PsiMethod psiMethod) {
        String methodName = psiMethod.getName();
        for (RestMethod entry : RestMethod.values()) {
            if (!methodName.startsWith(entry.getMethodNamePrefix())) continue;
            return entry;
        }
        throw new AssertionError((Object)("It's impossible for method" + psiMethod.getName() + " to map to no REST path."));
    }

    @Nullable
    private String getResourceProperty(PsiMethod psiMethod) {
        PsiClass psiClass = psiMethod.getContainingClass();
        PsiModifierList modifierList = psiClass.getModifierList();
        String resource = null;
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            try {
                resource = this.getAttributeFromAnnotation(annotation, "com.google.api.server.spi.config.ApiClass", "resource");
            }
            catch (InvalidAnnotationException invalidAnnotationException) {
            }
            catch (MissingAttributeException e) {
                break;
            }
            if (resource == null || resource.isEmpty()) continue;
            return resource;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            try {
                resource = this.getAttributeFromAnnotation(annotation, "com.google.api.server.spi.config.Api", "resource");
            }
            catch (InvalidAnnotationException e) {
            }
            catch (MissingAttributeException e) {
                break;
            }
            if (resource == null) continue;
            if (resource.isEmpty()) break;
            return resource;
        }
        return null;
    }

    private String getAttributeFromAnnotation(PsiAnnotation annotation, String annotationType, String attribute) throws InvalidAnnotationException, MissingAttributeException {
        if (annotation.getQualifiedName().equals(annotationType)) {
            PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue(attribute);
            if (annotationMemberValue == null) {
                throw new MissingAttributeException(annotation, attribute);
            }
            String httpMethodWithQuotes = annotationMemberValue.getText();
            return httpMethodWithQuotes.substring(1, httpMethodWithQuotes.length() - 1);
        }
        throw new InvalidAnnotationException(annotation, annotationType);
    }

    private String getErrorMessage(String restSignature, String method1, String method2) {
        return String.format("Multiple methods with same rest path \"%s\": \"%s\" and \"%s\"", restSignature, method1, method2);
    }

    @Nullable
    private String guessResourceName(PsiMethod method) {
        if (method.getReturnType().equals(PsiTypes.voidType())) {
            return null;
        }
        RestMethod restMethod = this.getDefaultRestMethod(method);
        return restMethod.guessResourceName(method);
    }

    private String getPathParameter(PsiMethod method) {
        Object path = "";
        EndpointPsiElementVisitor elementVisitor = new EndpointPsiElementVisitor();
        List<String> annotions = Arrays.asList("com.google.api.server.spi.config.Nullable", "javax.annotation.Nullable", "com.google.api.server.spi.config.DefaultValue");
        for (PsiParameter aParameter : method.getParameterList().getParameters()) {
            PsiAnnotationMemberValue namedValue;
            PsiModifierList modifierList = aParameter.getModifierList();
            if (modifierList == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)aParameter, annotions) || (namedValue = elementVisitor.getNamedAnnotationValue(aParameter)) == null) continue;
            path = (String)path + "/{}";
        }
        return path;
    }

    @Nullable
    private static Project getProject(PsiMethod method) {
        Project project;
        try {
            project = method.getContainingFile().getProject();
        }
        catch (PsiInvalidElementAccessException e) {
            LOG.error("Error getting project with parameter " + method.getText(), (Throwable)e);
            return null;
        }
        return project;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class RestMethod
    extends Enum<RestMethod> {
        public static final /* enum */ RestMethod LIST = new RestMethod("list", "GET"){

            @Override
            @Nullable
            public String guessResourceName(PsiMethod method) {
                Project project = RestSignatureInspection.getProject(method);
                if (project == null) {
                    return null;
                }
                PsiType returnType = method.getReturnType();
                if (this.isValidCollectionType(project, returnType)) {
                    assert (returnType instanceof PsiClassType);
                    PsiClassType classType = (PsiClassType)returnType;
                    PsiType[] typeParams = classType.getParameters();
                    return typeParams.length > 0 ? RestMethod.getSimpleName(project, typeParams[0]).toLowerCase() : null;
                }
                return null;
            }

            private boolean isValidCollectionType(Project project, PsiType type) {
                if (PsiUtils.isParameterizedType(type)) {
                    PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
                    PsiClassType collectionResponseType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("com.google.api.server.spi.response.CollectionResponse");
                    return collectionType.isAssignableFrom(type) || collectionResponseType.isAssignableFrom(type);
                }
                return false;
            }
        };
        public static final /* enum */ RestMethod GET = new RestMethod("get", "GET");
        public static final /* enum */ RestMethod INSERT = new RestMethod("insert", "POST");
        public static final /* enum */ RestMethod UPDATE = new RestMethod("update", "PUT");
        public static final /* enum */ RestMethod DELETE = new RestMethod("delete", "DELETE"){

            @Override
            public String guessResourceName(PsiMethod method) {
                String methodName = method.getName();
                return this.methodNamePrefix.length() >= methodName.length() ? null : methodName.substring(this.methodNamePrefix.length()).toLowerCase();
            }
        };
        public static final /* enum */ RestMethod REMOVE = new RestMethod("remove", "DELETE"){

            @Override
            public String guessResourceName(PsiMethod method) {
                String methodName = method.getName();
                return this.methodNamePrefix.length() >= methodName.length() ? null : methodName.substring(this.methodNamePrefix.length()).toLowerCase();
            }
        };
        public static final /* enum */ RestMethod DEFAULT = new RestMethod("", "POST"){

            @Override
            @Nullable
            public String guessResourceName(PsiMethod method) {
                return null;
            }
        };
        protected final String methodNamePrefix;
        private final String httpMethod;
        private static final /* synthetic */ RestMethod[] $VALUES;

        public static RestMethod[] values() {
            return (RestMethod[])$VALUES.clone();
        }

        public static RestMethod valueOf(String name) {
            return Enum.valueOf(RestMethod.class, name);
        }

        private RestMethod(String methodNamePrefix, String httpMethod) {
            this.methodNamePrefix = methodNamePrefix;
            this.httpMethod = httpMethod;
        }

        public String getMethodNamePrefix() {
            return this.methodNamePrefix;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        @Nullable
        public String guessResourceName(PsiMethod method) {
            Project project = RestSignatureInspection.getProject(method);
            if (project == null) {
                return null;
            }
            return RestMethod.getSimpleName(project, method.getReturnType()).toLowerCase();
        }

        @Nullable
        private static String getSimpleName(Project project, PsiType type) {
            PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
            if (type == null) {
                return null;
            }
            if (type instanceof PsiArrayType) {
                PsiType arrayComponentType = ((PsiArrayType)type).getComponentType();
                return RestMethod.getSimpleName(project, arrayComponentType) + "collection";
            }
            if (collectionType.isAssignableFrom(type)) {
                assert (type instanceof PsiClassType);
                PsiClassType classType = (PsiClassType)type;
                PsiType[] typeParams = classType.getParameters();
                return typeParams.length > 0 ? RestMethod.getSimpleName(project, typeParams[0]) + "collection" : null;
            }
            if (PsiUtils.isParameterizedType(type)) {
                PsiType[] typeParams;
                assert (type instanceof PsiClassType);
                StringBuilder builder = new StringBuilder();
                PsiClassType classType = (PsiClassType)type;
                builder.append(RestMethod.getSimpleName(project, (PsiType)classType.rawType()));
                for (PsiType aType : typeParams = classType.getParameters()) {
                    builder.append('_');
                    builder.append(RestMethod.getSimpleName(project, aType));
                }
                return builder.toString();
            }
            return type.getPresentableText();
        }

        private static /* synthetic */ RestMethod[] $values() {
            return new RestMethod[]{LIST, GET, INSERT, UPDATE, DELETE, REMOVE, DEFAULT};
        }

        static {
            $VALUES = RestMethod.$values();
        }
    }
}

