/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sourcerepo.v1.CloudSourceRepositories;
import com.google.api.services.sourcerepo.v1.model.ListReposResponse;
import com.google.gct.login.CredentialedUser;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class CloudRepositoryService {
    private static final String CLOUD_SOURCE_API_ROOT_URL = "https://sourcerepo.googleapis.com/";
    private static int LIST_TIMEOUT_MS = 5000;
    private static final String USER_AGENT = "gcloud-intellij-cloud-tools-plugin";

    @NotNull
    public ListReposResponse list(CredentialedUser user, String cloudProject) throws CloudRepositoryServiceException {
        try {
            Credential credential = user.credential;
            HttpRequestInitializer initializer = httpRequest -> {
                HttpHeaders headers = new HttpHeaders();
                httpRequest.setConnectTimeout(LIST_TIMEOUT_MS);
                httpRequest.setReadTimeout(LIST_TIMEOUT_MS);
                httpRequest.setHeaders(headers);
                credential.initialize(httpRequest);
            };
            NetHttpTransport httpTransport = new NetHttpTransport();
            CloudSourceRepositories source = new CloudSourceRepositories.Builder((HttpTransport)httpTransport, (JsonFactory)GsonFactory.getDefaultInstance(), initializer).setRootUrl(CLOUD_SOURCE_API_ROOT_URL).setServicePath("").setApplicationName(USER_AGENT).build();
            return (ListReposResponse)source.projects().repos().list(cloudProject).execute();
        }
        catch (IOException ex) {
            throw new CloudRepositoryServiceException();
        }
    }

    public CompletableFuture<ListReposResponse> listAsync(CredentialedUser user, String cloudProject) {
        return CompletableFuture.supplyAsync(() -> this.list(user, cloudProject));
    }

    public static class CloudRepositoryServiceException
    extends RuntimeException {
    }
}

