/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.cloudresourcemanager.v3.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.v3.model.Project;
import com.google.api.services.cloudresourcemanager.v3.model.SearchProjectsResponse;
import com.google.common.base.Strings;
import com.google.gct.idea.resources.ResourceErrorModelItem;
import com.google.gct.idea.resources.ResourceLoadingModelItem;
import com.google.gct.idea.resources.ResourceNewProjectModelItem;
import com.google.gct.idea.resources.ResourceProjectModelItem;
import com.google.gct.login.CredentialedUser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

class GoogleUserModelItem
extends DefaultMutableTreeNode {
    private static final Logger LOG = Logger.getInstance(GoogleUserModelItem.class);
    private static final String PROJECT_DELETE_REQUESTED = "DELETE_REQUESTED";
    private final CredentialedUser myUser;
    private final DefaultTreeModel myTreeModel;
    private volatile boolean myIsSynchronizing;
    private volatile boolean myNeedsSynchronizing;

    GoogleUserModelItem(@NotNull CredentialedUser user, @NotNull DefaultTreeModel treeModel) {
        this.myUser = user;
        this.myTreeModel = treeModel;
        this.setNeedsSynchronizing();
    }

    public CredentialedUser getCredentialedUser() {
        return this.myUser;
    }

    public Image getImage() {
        return this.myUser.getPicture();
    }

    public String getName() {
        return this.myUser.getName();
    }

    public String getEmail() {
        return this.myUser.email;
    }

    public void setNeedsSynchronizing() {
        this.myNeedsSynchronizing = true;
        this.removeAllChildren();
        this.add(new ResourceLoadingModelItem());
        this.myTreeModel.reload(this);
    }

    public void synchronize() {
        if (!this.myNeedsSynchronizing || this.myIsSynchronizing) {
            return;
        }
        this.myIsSynchronizing = true;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    GoogleUserModelItem.this.loadUserProjects(GoogleUserModelItem.this.myUser);
                    GoogleUserModelItem.this.myNeedsSynchronizing = false;
                }
                finally {
                    GoogleUserModelItem.this.myIsSynchronizing = false;
                }
            }
        });
    }

    public boolean isSynchronizing() {
        return this.myIsSynchronizing;
    }

    private void loadErrorState(final @NotNull Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleUserModelItem.this.removeAllChildren();
                GoogleUserModelItem.this.add(new ResourceErrorModelItem("Error: " + ex.toString()));
                GoogleUserModelItem.this.myTreeModel.reload(GoogleUserModelItem.this);
            }
        });
    }

    private void loadUserProjects(CredentialedUser user) {
        final ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        CloudResourceManager cloudResourceManagerClient = new CloudResourceManager.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)user.credential).setApplicationName("Android Studio").build();
        try {
            String pageToken = null;
            do {
                SearchProjectsResponse response;
                if ((response = (SearchProjectsResponse)cloudResourceManagerClient.projects().search().setPageSize(Integer.valueOf(2000)).setPageToken(pageToken).execute()) == null || response.getProjects() == null) continue;
                pageToken = response.getNextPageToken();
                for (Project pantheonProject : response.getProjects()) {
                    if (Strings.isNullOrEmpty((String)pantheonProject.getProjectId()) || !Strings.isNullOrEmpty((String)pantheonProject.getDeleteTime())) continue;
                    result.add(new ResourceProjectModelItem(pantheonProject));
                }
            } while (pageToken != null);
        }
        catch (Exception e) {
            LOG.error("Exception loading projects for " + this.myUser.getName(), (Throwable)e);
            this.loadErrorState(e);
            return;
        }
        result.add(new ResourceNewProjectModelItem());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GoogleUserModelItem.this.removeAllChildren();
                    for (DefaultMutableTreeNode item : result) {
                        GoogleUserModelItem.this.add(item);
                    }
                    GoogleUserModelItem.this.myTreeModel.reload(GoogleUserModelItem.this);
                }
            });
        }
        catch (InterruptedException ex) {
            LOG.error("InterruptedException loading projects for " + this.myUser.getName(), (Throwable)ex);
            this.loadErrorState(ex);
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException ex) {
            LOG.error("InvocationTargetException loading projects for " + this.myUser.getName(), (Throwable)ex);
            this.loadErrorState(ex);
        }
    }
}

