/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;

public class CloudCodePluginCheck {
    public static boolean isPresentAndEnabled() {
        PluginId cloudCodePluginId = PluginId.findId((String)"com.google.gct.core");
        return cloudCodePluginId != null && PluginManager.getInstance().findEnabledPlugin(cloudCodePluginId) != null;
    }

    public static boolean shouldShowDeprecationWarning() {
        return (Boolean)StudioFlags.SHOW_CLOUD_DEPRECATION_MESSAGES.get() != false || CloudCodePluginCheck.isPresentAndEnabled();
    }

    public static void showDeprecationWarningIfNecessary() {
        if (CloudCodePluginCheck.shouldShowDeprecationWarning()) {
            Messages.showWarningDialog((String)"Cloud Tools for Android Studio is deprecated and will be removed in a future version of Android Studio. Please migrate to <a href=\"https://cloud.google.com/code/docs/intellij/install\">Cloud Code for Android Studio</a>.", (String)"Cloud Tools Is Deprecated");
        }
    }
}

