/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.notification;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.io.File;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineStatusNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        AppEngineConfigurationProperties state;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(module);
        if (facet != null && (state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null && !new File(state.APPENGINE_SDKROOT).exists()) {
            VirtualFile buildFile = GradleProjectSystemUtil.getGradleBuildFile((Module)module);
            return editor -> new DownloadSdkNotification(project, buildFile, module.getName());
        }
        return null;
    }

    private static class DownloadSdkNotification
    extends EditorNotificationPanel {
        DownloadSdkNotification(final Project myProject, final VirtualFile buildFile, String moduleName) {
            this.setText(GctStudioBundle.message("appengine.sdk.invalid", moduleName));
            this.createActionLabel(GctStudioBundle.message("appengine.sdk.gradle.install", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    GradleBuildInvoker.getInstance((Project)myProject).executeTasks(GradleBuildInvoker.Request.builder((Project)myProject, (File)new File(myProject.getBasePath()), (String[])new String[]{"appengineDownloadSdk"}).build());
                }
            });
            if (buildFile != null && buildFile.exists()) {
                this.createActionLabel(GctStudioBundle.message("appengine.sdk.open.gradle.build", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManager.getInstance((Project)myProject).openFile(buildFile, true);
                    }
                });
            }
        }
    }
}

