/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.schema.DataClass;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.TypeRefContext;
import org.gradle.internal.declarativedsl.language.DataTypeInternal;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a3\u0010\u000f\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0080\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"checkIsAssignable", "", "valueType", "Lorg/gradle/declarative/dsl/schema/DataType;", "isAssignableTo", "checkAccessOnCurrentReceiver", "", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "access", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "getDataType", "Lorg/gradle/internal/declarativedsl/analysis/TypeRefContext;", "objectOrigin", "withScope", "scope", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisScope;", "action", "Lkotlin/Function0;", "declarative-dsl-core"})
public final class UtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withScope(@NotNull AnalysisContext $this$withScope, @NotNull AnalysisScope scope, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withScope = false;
        $this$withScope.enterScope(scope);
        try {
            action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withScope.leaveScope(scope);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final boolean checkIsAssignable(@NotNull DataType valueType, @NotNull DataType isAssignableTo) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)isAssignableTo, (String)"isAssignableTo");
        DataType dataType = isAssignableTo;
        if (dataType instanceof DataType.ConstantType) {
            bl = Intrinsics.areEqual((Object)valueType, (Object)isAssignableTo);
        } else if (dataType instanceof DataClass) {
            bl = valueType instanceof DataClass && (Intrinsics.areEqual((Object)isAssignableTo, (Object)valueType) || ((DataClass)valueType).getSupertypes().contains(((DataClass)isAssignableTo).getName()));
        } else if (dataType instanceof DataType.NullType) {
            bl = false;
        } else if (dataType instanceof DataType.UnitType) {
            bl = valueType instanceof DataType.UnitType;
        } else {
            throw new IllegalStateException(("Unhandled data type: " + isAssignableTo.getClass().getSimpleName()).toString());
        }
        return bl;
    }

    @NotNull
    public static final DataType getDataType(@NotNull TypeRefContext $this$getDataType, @NotNull ObjectOrigin objectOrigin) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)$this$getDataType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectOrigin, (String)"objectOrigin");
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin) {
            dataType = UtilsKt.getDataType($this$getDataType, ((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
            dataType = (DataType)((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getType();
        } else if (objectOrigin2 instanceof ObjectOrigin.External) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.External)objectOrigin).getKey().getObjectType());
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromMemberFunction) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getFunction().getReturnValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromTopLevelFunction) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.NewObjectFromTopLevelFunction)objectOrigin).getFunction().getReturnValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.PropertyReference)objectOrigin).getProperty().getValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.PropertyDefaultValue)objectOrigin).getProperty().getValueType());
        } else if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
            dataType = ((ObjectOrigin.TopLevelReceiver)objectOrigin).getType();
        } else if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
            dataType = (DataType)DataTypeInternal.DefaultNullType.INSTANCE;
        } else if (objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.CustomConfigureAccessor)objectOrigin).getAccessedType());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
            dataType = $this$getDataType.resolveRef(((ObjectOrigin.ConfiguringLambdaReceiver)objectOrigin).getLambdaReceiverType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataType;
    }

    public static final void checkAccessOnCurrentReceiver(@NotNull AnalysisContext $this$checkAccessOnCurrentReceiver, @NotNull ObjectOrigin receiver, @NotNull LanguageTreeElement access) {
        Intrinsics.checkNotNullParameter((Object)$this$checkAccessOnCurrentReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (!(receiver instanceof ObjectOrigin.ImplicitThisReceiver) || !((ObjectOrigin.ImplicitThisReceiver)receiver).isCurrentScopeReceiver()) {
            $this$checkAccessOnCurrentReceiver.getErrorCollector().collect(new ResolutionError(access, ErrorReason.AccessOnCurrentReceiverOnlyViolation.INSTANCE));
        }
    }
}

