/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.mappingToJvm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gradle.declarative.dsl.schema.DataBuilderFunction;
import org.gradle.declarative.dsl.schema.DataParameter;
import org.gradle.declarative.dsl.schema.DataProperty;
import org.gradle.declarative.dsl.schema.ExternalObjectProviderKey;
import org.gradle.declarative.dsl.schema.SchemaFunction;
import org.gradle.declarative.dsl.schema.SchemaMemberFunction;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.OperationId;
import org.gradle.internal.declarativedsl.analysis.ParameterValueBinding;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeRuntimeFunction;
import org.gradle.internal.declarativedsl.mappingToJvm.ReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.objectGraph.ObjectReflection;
import org.gradle.internal.declarativedsl.objectGraph.PropertyValueReflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00019B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001bH\u0002J \u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010-\u001a\u00020\u00102\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u000201H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u000203H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u000205H\u0002J\n\u00106\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u00107\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001b2\b\u00108\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/ReflectionToObjectConverter;", "externalObjectsMap", "", "Lorg/gradle/declarative/dsl/schema/ExternalObjectProviderKey;", "", "topLevelObject", "functionResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;", "propertyResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;", "customAccessors", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;", "(Ljava/util/Map;Ljava/lang/Object;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;)V", "reflectionIdentityObjects", "", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "apply", "", "objectReflection", "Lorg/gradle/internal/declarativedsl/objectGraph/ObjectReflection;", "conversionFilter", "Lorg/gradle/internal/declarativedsl/mappingToJvm/ReflectionToObjectConverter$ConversionFilter;", "applyPropertyValue", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "property", "Lorg/gradle/declarative/dsl/schema/DataProperty;", "assigned", "Lorg/gradle/internal/declarativedsl/objectGraph/PropertyValueReflection;", "getObjectByResolvedOrigin", "objectOrigin", "getPropertyValue", "dataProperty", "invokeBuilderFunction", "receiverOrigin", "function", "Lorg/gradle/declarative/dsl/schema/DataBuilderFunction;", "valueOrigin", "invokeFunctionAndGetResult", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeRuntimeFunction$InvocationResult;", "receiverInstance", "origin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionInvocationOrigin;", "objectByIdentity", "key", "newObject", "Lkotlin/Function0;", "objectFromConfiguringLambda", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ConfiguringLambdaReceiver;", "objectFromCustomAccessor", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$CustomConfigureAccessor;", "objectFromMemberFunction", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$NewObjectFromMemberFunction;", "objectFromTopLevelFunction", "setPropertyValue", "value", "ObjectAccessKey", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nDeclarativeReflectionToObjectConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,195:1\n1855#2,2:196\n1855#2,2:198\n1855#2,2:200\n1855#2,2:202\n1238#2,4:206\n1238#2,4:212\n453#3:204\n403#3:205\n453#3:210\n403#3:211\n*S KotlinDebug\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n*L\n25#1:196,2\n33#1:198,2\n40#1:200,2\n45#1:202,2\n124#1:206,4\n161#1:212,4\n124#1:204\n124#1:205\n161#1:210\n161#1:211\n*E\n"})
public final class DeclarativeReflectionToObjectConverter
implements ReflectionToObjectConverter {
    @NotNull
    private final Map<ExternalObjectProviderKey, Object> externalObjectsMap;
    @NotNull
    private final Object topLevelObject;
    @NotNull
    private final RuntimeFunctionResolver functionResolver;
    @NotNull
    private final RuntimePropertyResolver propertyResolver;
    @NotNull
    private final RuntimeCustomAccessors customAccessors;
    @NotNull
    private final Map<ObjectAccessKey, Object> reflectionIdentityObjects;

    public DeclarativeReflectionToObjectConverter(@NotNull Map<ExternalObjectProviderKey, ? extends Object> externalObjectsMap, @NotNull Object topLevelObject, @NotNull RuntimeFunctionResolver functionResolver, @NotNull RuntimePropertyResolver propertyResolver, @NotNull RuntimeCustomAccessors customAccessors) {
        Intrinsics.checkNotNullParameter(externalObjectsMap, (String)"externalObjectsMap");
        Intrinsics.checkNotNullParameter((Object)topLevelObject, (String)"topLevelObject");
        Intrinsics.checkNotNullParameter((Object)functionResolver, (String)"functionResolver");
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        Intrinsics.checkNotNullParameter((Object)customAccessors, (String)"customAccessors");
        this.externalObjectsMap = externalObjectsMap;
        this.topLevelObject = topLevelObject;
        this.functionResolver = functionResolver;
        this.propertyResolver = propertyResolver;
        this.customAccessors = customAccessors;
        this.reflectionIdentityObjects = new LinkedHashMap();
    }

    @Override
    public void apply(@NotNull ObjectReflection objectReflection, @NotNull ReflectionToObjectConverter.ConversionFilter conversionFilter) {
        Intrinsics.checkNotNullParameter((Object)objectReflection, (String)"objectReflection");
        Intrinsics.checkNotNullParameter((Object)conversionFilter, (String)"conversionFilter");
        if (objectReflection instanceof ObjectReflection.DataObjectReflection) {
            Iterable $this$forEach$iv = conversionFilter.filterProperties((ObjectReflection.DataObjectReflection)objectReflection);
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                DataProperty property = element$iv = iterator.next();
                boolean bl = false;
                PropertyValueReflection assigned = (PropertyValueReflection)MapsKt.getValue(((ObjectReflection.DataObjectReflection)objectReflection).getProperties(), (Object)property);
                this.applyPropertyValue(objectReflection.getObjectOrigin(), property, assigned);
                this.apply(assigned.getValue(), conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getAddedObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection addedObject = (ObjectReflection)element$iv;
                boolean bl = false;
                this.getObjectByResolvedOrigin(addedObject.getObjectOrigin());
                this.apply(addedObject, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getCustomAccessorObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection customAccessor = (ObjectReflection)element$iv;
                boolean bl = false;
                if (this.getObjectByResolvedOrigin(customAccessor.getObjectOrigin()) == null) {
                    throw new IllegalStateException(("could not get object by custom accessor " + customAccessor.getObjectOrigin()).toString());
                }
                this.apply(customAccessor, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getLambdaAccessedObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection lambdaAccessedObject = (ObjectReflection)element$iv;
                boolean bl = false;
                if (this.getObjectByResolvedOrigin(lambdaAccessedObject.getObjectOrigin()) == null) {
                    throw new IllegalStateException(("could not get object from lambda passed to " + lambdaAccessedObject.getObjectOrigin()).toString());
                }
                this.apply(lambdaAccessedObject, conversionFilter);
            }
        }
    }

    private final Object objectByIdentity(ObjectAccessKey key, Function0<? extends Object> newObject) {
        if (!this.reflectionIdentityObjects.containsKey(key)) {
            Object newInstance = newObject.invoke();
            this.reflectionIdentityObjects.put(key, newInstance);
            return newInstance;
        }
        return this.reflectionIdentityObjects.get(key);
    }

    private final void applyPropertyValue(ObjectOrigin receiver, DataProperty property, PropertyValueReflection assigned) {
        AssignmentMethod assignmentMethod = assigned.getAssignmentMethod();
        if (assignmentMethod instanceof AssignmentMethod.Property) {
            this.setPropertyValue(receiver, property, this.getObjectByResolvedOrigin(assigned.getValue().getObjectOrigin()));
        } else if (assignmentMethod instanceof AssignmentMethod.BuilderFunction) {
            this.invokeBuilderFunction(receiver, ((AssignmentMethod.BuilderFunction)assigned.getAssignmentMethod()).getFunction(), assigned.getValue().getObjectOrigin());
        } else if (assignmentMethod instanceof AssignmentMethod.AsConstructed) {
            // empty if block
        }
    }

    private final Object getObjectByResolvedOrigin(ObjectOrigin objectOrigin) {
        Object object;
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin) {
            object = this.getObjectByResolvedOrigin(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
            object = ((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getValue();
        } else if (objectOrigin2 instanceof ObjectOrigin.External) {
            object = this.externalObjectsMap.get(((ObjectOrigin.External)objectOrigin).getKey());
            if (object == null) {
                throw new IllegalStateException(("No external object provided for external object key of " + ((ObjectOrigin.External)objectOrigin).getKey()).toString());
            }
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromMemberFunction) {
            object = this.objectByIdentity(new ObjectAccessKey.Identity(((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getInvocationId()), (Function0<? extends Object>)((Function0)new Function0<Object>(this, objectOrigin){
                final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
                final /* synthetic */ ObjectOrigin $objectOrigin;
                {
                    this.this$0 = $receiver;
                    this.$objectOrigin = $objectOrigin;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return DeclarativeReflectionToObjectConverter.access$objectFromMemberFunction(this.this$0, (ObjectOrigin.NewObjectFromMemberFunction)this.$objectOrigin);
                }
            }));
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromTopLevelFunction) {
            object = this.objectByIdentity(new ObjectAccessKey.Identity(((ObjectOrigin.NewObjectFromTopLevelFunction)objectOrigin).getInvocationId()), (Function0<? extends Object>)((Function0)new Function0<Object>(this){
                final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return DeclarativeReflectionToObjectConverter.access$objectFromTopLevelFunction(this.this$0);
                }
            }));
        } else if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
            object = null;
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
            object = this.getPropertyValue(((ObjectOrigin.PropertyDefaultValue)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyDefaultValue)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
            object = this.getPropertyValue(((ObjectOrigin.PropertyReference)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyReference)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
            object = this.topLevelObject;
        } else if (objectOrigin2 instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
            object = this.objectFromConfiguringLambda((ObjectOrigin.ConfiguringLambdaReceiver)objectOrigin);
        } else if (objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor) {
            object = this.objectFromCustomAccessor((ObjectOrigin.CustomConfigureAccessor)objectOrigin);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Object objectFromMemberFunction(ObjectOrigin.NewObjectFromMemberFunction origin) {
        SchemaMemberFunction dataFun = origin.getFunction();
        Object object = this.getObjectByResolvedOrigin(origin.getReceiver());
        if (object == null) {
            throw new IllegalStateException(("Tried to invoke a function " + dataFun + " on a null receiver " + origin.getReceiver()).toString());
        }
        Object receiverInstance = object;
        DeclarativeRuntimeFunction.InvocationResult callResult = this.invokeFunctionAndGetResult(receiverInstance, origin);
        return callResult.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarativeRuntimeFunction.InvocationResult invokeFunctionAndGetResult(Object receiverInstance, ObjectOrigin.FunctionInvocationOrigin origin) {
        Map destination$iv$iv;
        SchemaFunction dataFun = origin.getFunction();
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, dataFun.getSimpleName(), origin.getParameterBindings());
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            void $this$mapValuesTo$iv$iv;
            Map<DataParameter, ObjectOrigin> $this$mapValues$iv = origin.getParameterBindings().getBindingMap();
            boolean $i$f$mapValues = false;
            Map<DataParameter, ObjectOrigin> map = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object = this.getObjectByResolvedOrigin((ObjectOrigin)it.getValue());
                map3.put(k, object);
            }
        } else {
            if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
                throw new IllegalStateException(("could not resolve a member function " + dataFun + " call in the owner class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        Map bindingWithValues = destination$iv$iv;
        return ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction().callByWithErrorHandling(receiverInstance, bindingWithValues, origin.getParameterBindings().getProvidesConfigureBlock());
    }

    private final Object objectFromConfiguringLambda(ObjectOrigin.ConfiguringLambdaReceiver origin) {
        return this.objectByIdentity(new ObjectAccessKey.ConfiguringLambda(origin.getReceiver(), origin.getFunction()), (Function0<? extends Object>)((Function0)new Function0<Object>(origin, this){
            final /* synthetic */ ObjectOrigin.ConfiguringLambdaReceiver $origin;
            final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
            {
                this.$origin = $origin;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                SchemaFunction function = this.$origin.getFunction();
                Object object = DeclarativeReflectionToObjectConverter.access$getObjectByResolvedOrigin(this.this$0, this.$origin.getReceiver());
                if (object == null) {
                    throw new IllegalStateException(("Tried to invoke a function " + function + " on a null receiver " + this.$origin.getReceiver()).toString());
                }
                Object receiverInstance = object;
                return DeclarativeReflectionToObjectConverter.access$invokeFunctionAndGetResult(this.this$0, receiverInstance, this.$origin).getCapturedValue();
            }
        }));
    }

    private final Object objectFromCustomAccessor(ObjectOrigin.CustomConfigureAccessor origin) {
        return this.objectByIdentity(new ObjectAccessKey.CustomAccessor(origin.getReceiver(), origin.getAccessor().getCustomAccessorIdentifier()), (Function0<? extends Object>)((Function0)new Function0<Object>(this, origin){
            final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
            final /* synthetic */ ObjectOrigin.CustomConfigureAccessor $origin;
            {
                this.this$0 = $receiver;
                this.$origin = $origin;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                Object object = DeclarativeReflectionToObjectConverter.access$getObjectByResolvedOrigin(this.this$0, this.$origin.getReceiver());
                if (object == null) {
                    throw new IllegalStateException("receiver for custom accessor is null".toString());
                }
                return DeclarativeReflectionToObjectConverter.access$getCustomAccessors$p(this.this$0).getObjectFromCustomAccessor(object, this.$origin.getAccessor());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeBuilderFunction(ObjectOrigin receiverOrigin, DataBuilderFunction function, ObjectOrigin valueOrigin) {
        Object object = this.getObjectByResolvedOrigin(receiverOrigin);
        if (object == null) {
            throw new IllegalStateException(("Tried to invoke a function " + function + " on a null receiver " + receiverOrigin).toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        ParameterValueBinding parameterBinding = new ParameterValueBinding(MapsKt.mapOf((Pair)TuplesKt.to((Object)function.getDataParameter(), (Object)valueOrigin)), false);
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, function.getSimpleName(), parameterBinding);
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<DataParameter, ObjectOrigin> map2 = parameterBinding.getBindingMap();
            Object object2 = receiverInstance;
            DeclarativeRuntimeFunction declarativeRuntimeFunction = ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction();
            boolean $i$f$mapValues = false;
            void var10_12 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map = map3;
                boolean bl2 = false;
                Object object3 = this.getObjectByResolvedOrigin((ObjectOrigin)it.getValue());
                map.put(k, object3);
            }
            map = destination$iv$iv;
            declarativeRuntimeFunction.callByWithErrorHandling(object2, map, parameterBinding.getProvidesConfigureBlock()).getResult();
        } else if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
            throw new IllegalStateException(("could not resolve a member function " + function + " call in the owner class " + receiverKClass).toString());
        }
    }

    private final Object objectFromTopLevelFunction() {
        String string = "support calls to top-level functions: they need to carry the owner class information to get resolved";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Object getPropertyValue(ObjectOrigin receiver, DataProperty dataProperty) {
        Object object = this.getObjectByResolvedOrigin(receiver);
        if (object == null) {
            throw new IllegalStateException(("tried to access a property " + dataProperty.getName() + " on a null receiver").toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimePropertyResolver.ReadResolution property = this.propertyResolver.resolvePropertyRead(receiverKClass, dataProperty.getName());
        if (!(property instanceof RuntimePropertyResolver.ReadResolution.ResolvedRead)) {
            if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.ReadResolution.UnresolvedRead.INSTANCE)) {
                throw new IllegalStateException(("cannot get property " + dataProperty.getName() + " from the receiver class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((RuntimePropertyResolver.ReadResolution.ResolvedRead)property).getGetter().getValue(receiverInstance);
    }

    private final void setPropertyValue(ObjectOrigin receiver, DataProperty dataProperty, Object value) {
        Object object = this.getObjectByResolvedOrigin(receiver);
        if (object == null) {
            throw new IllegalStateException(("tried to access a property " + dataProperty.getName() + " on a null receiver").toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimePropertyResolver.WriteResolution property = this.propertyResolver.resolvePropertyWrite(receiverKClass, dataProperty.getName());
        if (property instanceof RuntimePropertyResolver.WriteResolution.ResolvedWrite) {
            ((RuntimePropertyResolver.WriteResolution.ResolvedWrite)property).getSetter().setValue(receiverInstance, value);
        } else if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.WriteResolution.UnresolvedWrite.INSTANCE)) {
            throw new IllegalStateException(("cannot set property " + dataProperty.getName() + " in the receiver class " + receiverKClass).toString());
        }
    }

    public static final /* synthetic */ Object access$objectFromMemberFunction(DeclarativeReflectionToObjectConverter $this, ObjectOrigin.NewObjectFromMemberFunction origin) {
        return $this.objectFromMemberFunction(origin);
    }

    public static final /* synthetic */ Object access$objectFromTopLevelFunction(DeclarativeReflectionToObjectConverter $this) {
        return $this.objectFromTopLevelFunction();
    }

    public static final /* synthetic */ Object access$getObjectByResolvedOrigin(DeclarativeReflectionToObjectConverter $this, ObjectOrigin objectOrigin) {
        return $this.getObjectByResolvedOrigin(objectOrigin);
    }

    public static final /* synthetic */ DeclarativeRuntimeFunction.InvocationResult access$invokeFunctionAndGetResult(DeclarativeReflectionToObjectConverter $this, Object receiverInstance, ObjectOrigin.FunctionInvocationOrigin origin) {
        return $this.invokeFunctionAndGetResult(receiverInstance, origin);
    }

    public static final /* synthetic */ RuntimeCustomAccessors access$getCustomAccessors$p(DeclarativeReflectionToObjectConverter $this) {
        return $this.customAccessors;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "", "ConfiguringLambda", "CustomAccessor", "Identity", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$ConfiguringLambda;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$CustomAccessor;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$Identity;", "declarative-dsl-core"})
    private static interface ObjectAccessKey {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$ConfiguringLambda;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "owner", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "function", "Lorg/gradle/declarative/dsl/schema/SchemaFunction;", "(Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;Lorg/gradle/declarative/dsl/schema/SchemaFunction;)V", "getFunction", "()Lorg/gradle/declarative/dsl/schema/SchemaFunction;", "getOwner", "()Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "declarative-dsl-core"})
        public static final class ConfiguringLambda
        implements ObjectAccessKey {
            @NotNull
            private final ObjectOrigin owner;
            @NotNull
            private final SchemaFunction function;

            public ConfiguringLambda(@NotNull ObjectOrigin owner, @NotNull SchemaFunction function) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.owner = owner;
                this.function = function;
            }

            @NotNull
            public final ObjectOrigin getOwner() {
                return this.owner;
            }

            @NotNull
            public final SchemaFunction getFunction() {
                return this.function;
            }

            @NotNull
            public final ObjectOrigin component1() {
                return this.owner;
            }

            @NotNull
            public final SchemaFunction component2() {
                return this.function;
            }

            @NotNull
            public final ConfiguringLambda copy(@NotNull ObjectOrigin owner, @NotNull SchemaFunction function) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                return new ConfiguringLambda(owner, function);
            }

            public static /* synthetic */ ConfiguringLambda copy$default(ConfiguringLambda configuringLambda, ObjectOrigin objectOrigin, SchemaFunction schemaFunction, int n, Object object) {
                if ((n & 1) != 0) {
                    objectOrigin = configuringLambda.owner;
                }
                if ((n & 2) != 0) {
                    schemaFunction = configuringLambda.function;
                }
                return configuringLambda.copy(objectOrigin, schemaFunction);
            }

            @NotNull
            public String toString() {
                return "ConfiguringLambda(owner=" + this.owner + ", function=" + this.function + ')';
            }

            public int hashCode() {
                int result = this.owner.hashCode();
                result = result * 31 + this.function.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConfiguringLambda)) {
                    return false;
                }
                ConfiguringLambda configuringLambda = (ConfiguringLambda)other;
                if (!Intrinsics.areEqual((Object)this.owner, (Object)configuringLambda.owner)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.function, (Object)configuringLambda.function);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$CustomAccessor;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "owner", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "accessorId", "", "(Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;Ljava/lang/String;)V", "getAccessorId", "()Ljava/lang/String;", "getOwner", "()Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "declarative-dsl-core"})
        public static final class CustomAccessor
        implements ObjectAccessKey {
            @NotNull
            private final ObjectOrigin owner;
            @NotNull
            private final String accessorId;

            public CustomAccessor(@NotNull ObjectOrigin owner, @NotNull String accessorId) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)accessorId, (String)"accessorId");
                this.owner = owner;
                this.accessorId = accessorId;
            }

            @NotNull
            public final ObjectOrigin getOwner() {
                return this.owner;
            }

            @NotNull
            public final String getAccessorId() {
                return this.accessorId;
            }

            @NotNull
            public final ObjectOrigin component1() {
                return this.owner;
            }

            @NotNull
            public final String component2() {
                return this.accessorId;
            }

            @NotNull
            public final CustomAccessor copy(@NotNull ObjectOrigin owner, @NotNull String accessorId) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)accessorId, (String)"accessorId");
                return new CustomAccessor(owner, accessorId);
            }

            public static /* synthetic */ CustomAccessor copy$default(CustomAccessor customAccessor, ObjectOrigin objectOrigin, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    objectOrigin = customAccessor.owner;
                }
                if ((n & 2) != 0) {
                    string = customAccessor.accessorId;
                }
                return customAccessor.copy(objectOrigin, string);
            }

            @NotNull
            public String toString() {
                return "CustomAccessor(owner=" + this.owner + ", accessorId=" + this.accessorId + ')';
            }

            public int hashCode() {
                int result = this.owner.hashCode();
                result = result * 31 + this.accessorId.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CustomAccessor)) {
                    return false;
                }
                CustomAccessor customAccessor = (CustomAccessor)other;
                if (!Intrinsics.areEqual((Object)this.owner, (Object)customAccessor.owner)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.accessorId, (Object)customAccessor.accessorId);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$Identity;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "id", "Lorg/gradle/internal/declarativedsl/analysis/OperationId;", "(Lorg/gradle/internal/declarativedsl/analysis/OperationId;)V", "getId", "()Lorg/gradle/internal/declarativedsl/analysis/OperationId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "declarative-dsl-core"})
        public static final class Identity
        implements ObjectAccessKey {
            @NotNull
            private final OperationId id;

            public Identity(@NotNull OperationId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.id = id;
            }

            @NotNull
            public final OperationId getId() {
                return this.id;
            }

            @NotNull
            public final OperationId component1() {
                return this.id;
            }

            @NotNull
            public final Identity copy(@NotNull OperationId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return new Identity(id);
            }

            public static /* synthetic */ Identity copy$default(Identity identity, OperationId operationId, int n, Object object) {
                if ((n & 1) != 0) {
                    operationId = identity.id;
                }
                return identity.copy(operationId);
            }

            @NotNull
            public String toString() {
                return "Identity(id=" + this.id + ')';
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Identity)) {
                    return false;
                }
                Identity identity = (Identity)other;
                return Intrinsics.areEqual((Object)this.id, (Object)identity.id);
            }
        }
    }
}

