/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerContributor;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"getUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Artifact;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Module;", "getParentModule", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getModule", "intellij.gradle"})
public final class GradleDependencyAnalyzerUtilKt {
    @Nullable
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency dependency) {
        UnifiedCoordinates unifiedCoordinates;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencyAnalyzerDependency.Data data = dependency.getData();
        if (data instanceof DependencyAnalyzerDependency.Data.Artifact) {
            unifiedCoordinates = GradleDependencyAnalyzerUtilKt.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Artifact)data);
        } else if (data instanceof DependencyAnalyzerDependency.Data.Module) {
            unifiedCoordinates = GradleDependencyAnalyzerUtilKt.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Module)data);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unifiedCoordinates;
    }

    @NotNull
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency.Data.Artifact data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new UnifiedCoordinates(data.getGroupId(), data.getArtifactId(), data.getVersion());
    }

    @Nullable
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency.Data.Module data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ModuleData moduleData = (ModuleData)data.getUserData(GradleDependencyAnalyzerContributor.Companion.getMODULE_DATA$intellij_gradle());
        if (moduleData == null) {
            return null;
        }
        ModuleData moduleData2 = moduleData;
        return new UnifiedCoordinates(moduleData2.getGroup(), moduleData2.getExternalName(), moduleData2.getVersion());
    }

    @Nullable
    public static final Module getParentModule(@NotNull Project project2, @NotNull DependencyAnalyzerDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencyAnalyzerDependency dependencyAnalyzerDependency = dependency.getParent();
        DependencyAnalyzerDependency.Data data = dependencyAnalyzerDependency != null ? dependencyAnalyzerDependency.getData() : null;
        DependencyAnalyzerDependency.Data.Module module = data instanceof DependencyAnalyzerDependency.Data.Module ? (DependencyAnalyzerDependency.Data.Module)data : null;
        if (module == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data.Module parentData = module;
        return GradleDependencyAnalyzerUtilKt.getModule(project2, parentData);
    }

    @Nullable
    public static final Module getModule(@NotNull Project project2, @NotNull DependencyAnalyzerDependency.Data.Module data) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ModuleData moduleData = (ModuleData)data.getUserData(GradleDependencyAnalyzerContributor.Companion.getMODULE_DATA$intellij_gradle());
        if (moduleData == null) {
            return null;
        }
        ModuleData moduleData2 = moduleData;
        return GradleUtil.findGradleModule(project2, moduleData2);
    }
}

