/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/ViewDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/view/ExternalSystemNode;", "<init>", "()V", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "kotlin.jvm.PlatformType", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSelectedData", "getModule", "Lcom/intellij/openapi/module/Module;", "selectedData", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getDependencyScope", "", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDependencyAnalyzerAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyAnalyzerAction.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/ViewDependencyAnalyzerAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class ViewDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction<ExternalSystemNode<?>> {
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return GradleConstants.SYSTEM_ID;
    }

    @Nullable
    public ExternalSystemNode<?> getSelectedData(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        return list != null ? (ExternalSystemNode)CollectionsKt.firstOrNull((List)list) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Module getModule(@NotNull AnActionEvent e, @NotNull ExternalSystemNode<?> selectedData) {
        ProjectNode projectNode;
        Module module;
        ModuleData moduleData;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(selectedData, (String)"selectedData");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        ModuleNode moduleNode = (ModuleNode)selectedData.findNode(ModuleNode.class);
        if (moduleNode != null && (moduleData = (ModuleData)moduleNode.getData()) != null) {
            ModuleData it = moduleData;
            boolean bl = false;
            Module module2 = GradleUtil.findGradleModule(project3, it);
            if (module2 != null) {
                module = module2;
                return module;
            }
        }
        if ((projectNode = (ProjectNode)selectedData.findNode(ProjectNode.class)) == null) return null;
        ProjectData projectData = (ProjectData)projectNode.getData();
        if (projectData == null) return null;
        ProjectData it = projectData;
        boolean bl = false;
        module = GradleUtil.findGradleModule(project3, it);
        return module;
    }

    @Nullable
    public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull ExternalSystemNode<?> selectedData) {
        DependencyAnalyzerDependency.Data data;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(selectedData, (String)"selectedData");
        Object data2 = selectedData.getData();
        if (data2 instanceof ProjectData) {
            String string = ((ProjectData)data2).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
            data = (DependencyAnalyzerDependency.Data)new DAModule(string);
        } else if (data2 instanceof ModuleData) {
            String string = ((ModuleData)data2).getModuleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
            data = (DependencyAnalyzerDependency.Data)new DAModule(string);
        } else {
            UserDataHolder userDataHolder;
            DependencyNode node = selectedData.getDependencyNode();
            if (node instanceof ProjectDependencyNode) {
                String string = ((ProjectDependencyNode)node).getProjectName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectName(...)");
                userDataHolder = (UserDataHolder)new DAModule(string);
            } else if (node instanceof ArtifactDependencyNode) {
                String string = ((ArtifactDependencyNode)node).getGroup();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
                String string2 = ((ArtifactDependencyNode)node).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
                String string3 = ((ArtifactDependencyNode)node).getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                userDataHolder = (UserDataHolder)new DAArtifact(string, string2, string3);
            } else {
                userDataHolder = null;
            }
            data = (DependencyAnalyzerDependency.Data)userDataHolder;
        }
        return data;
    }

    @Nullable
    public String getDependencyScope(@NotNull AnActionEvent e, @NotNull ExternalSystemNode<?> selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(selectedData, (String)"selectedData");
        DependencyScopeNode dependencyScopeNode = (DependencyScopeNode)selectedData.findDependencyNode(DependencyScopeNode.class);
        return dependencyScopeNode != null ? dependencyScopeNode.getScope() : null;
    }
}

