/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavadocFixer;
import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBasicJavaSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(AbstractBasicJavaSmartEnterProcessor.class);
    private final List<Fixer> ourFixers;
    private final EnterProcessor[] ourEnterProcessors;
    private final EnterProcessor[] ourAfterCompletionEnterProcessors;
    protected int myFirstErrorOffset;
    protected boolean mySkipEnter;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    private final EnterProcessor myBreakerEnterProcessor;
    private final AbstractBasicJavadocFixer myJavadocFixer;

    protected void insertBraces(@NotNull Editor editor, int offset) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        Document document = editor.getDocument();
        document.insertString(offset, (CharSequence)"{");
        this.insertCloseBrace(editor, offset + 1);
    }

    protected void insertCloseBrace(@NotNull Editor editor, int offset) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        document.insertString(offset, (CharSequence)"}");
    }

    protected void insertBracesWithNewLine(Editor editor, int offset) {
        Document document = editor.getDocument();
        document.insertString(offset, (CharSequence)"{\n");
        this.insertCloseBrace(editor, offset + 2);
    }

    protected AbstractBasicJavaSmartEnterProcessor(@NotNull List<Fixer> fixers, EnterProcessor @NotNull [] enterProcessors, EnterProcessor @NotNull [] afterCompletionEnterProcessors, @NotNull AbstractBasicJavadocFixer thinJavadocFixer, @NotNull EnterProcessor breakerEnterProcessor) {
        if (fixers == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (thinJavadocFixer == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (breakerEnterProcessor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        if (enterProcessors == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(5);
        }
        if (afterCompletionEnterProcessors == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(6);
        }
        this.myFirstErrorOffset = Integer.MAX_VALUE;
        this.myBreakerEnterProcessor = breakerEnterProcessor;
        this.ourFixers = fixers;
        this.ourEnterProcessors = enterProcessors;
        this.ourAfterCompletionEnterProcessors = afterCompletionEnterProcessors;
        this.myJavadocFixer = thinJavadocFixer;
    }

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(9);
        }
        return this.invokeProcessor(editor, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(11);
        }
        return this.invokeProcessor(editor, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeProcessor(Editor editor, PsiFile psiFile, boolean afterCompletion) {
        Document document = editor.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.mySkipEnter = false;
            this.process(editor, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Editor editor, @NotNull PsiFile file, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(12);
        }
        if (file == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(13);
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                if (this.myJavadocFixer.process(editor, file)) {
                    return;
                }
                if (!this.myBreakerEnterProcessor.doEnter(editor, (PsiElement)file, false)) {
                    AbstractBasicJavaSmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<ASTNode> queue = new ArrayList<ASTNode>();
            ASTNode caretNode = atCaret.getNode();
            AbstractBasicJavaSmartEnterProcessor.collectAllElements(caretNode, queue, true);
            queue.add(caretNode);
            for (ASTNode astNode : queue) {
                for (Fixer fixer : this.ourFixers) {
                    Document document = editor.getDocument();
                    int offset = this.myFirstErrorOffset;
                    long stamp = document.getModificationStamp();
                    fixer.apply(editor, this, astNode);
                    Project project = file.getProject();
                    if (document.getModificationStamp() != stamp || offset != this.myFirstErrorOffset) {
                        this.log(fixer, project);
                    }
                    if (LookupManager.getInstance((Project)project).getActiveLookup() != null) {
                        return;
                    }
                    PsiElement psi = BasicJavaAstTreeUtil.toPsi(astNode);
                    if (!AbstractBasicJavaSmartEnterProcessor.isUncommited((Project)project) && psi != null && psi.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(editor, file, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, editor, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected abstract void log(@NotNull Fixer var1, @NotNull Project var2);

    public void reformat(PsiElement atCaretElement) throws IncorrectOperationException {
        PsiFile file;
        Document document;
        if (atCaretElement == null) {
            return;
        }
        ASTNode atCaret = atCaretElement.getNode();
        ASTNode parent = atCaret.getTreeParent();
        if (BasicJavaAstTreeUtil.is(parent, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            atCaret = parent;
        }
        if (BasicJavaAstTreeUtil.is(parent, BasicJavaElementType.BASIC_IF_STATEMENT) && atCaret == BasicJavaAstTreeUtil.getElseBranch(parent) && (document = (file = atCaretElement.getContainingFile()).getViewProvider().getDocument()) != null) {
            TextRange elseIfRange = atCaret.getTextRange();
            int lineStart = document.getLineStartOffset(document.getLineNumber(elseIfRange.getStartOffset()));
            CodeStyleManager.getInstance((Project)atCaretElement.getProject()).reformatText(file, lineStart, elseIfRange.getEndOffset());
            return;
        }
        super.reformat(atCaretElement);
    }

    private void doEnter(PsiElement atCaret, Editor editor, boolean afterCompletion) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat(editor, atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker(atCaret);
        this.reformat(editor, atCaret);
        this.commit(editor);
        if (!this.mySkipEnter) {
            ASTNode atCaretNode = BasicJavaAstTreeUtil.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getNode().getElementType());
            for (EnterProcessor processor : afterCompletion ? this.ourAfterCompletionEnterProcessors : this.ourEnterProcessors) {
                if (atCaretNode == null) break;
                if (!processor.doEnter(editor, BasicJavaAstTreeUtil.toPsi(atCaretNode), AbstractBasicJavaSmartEnterProcessor.isModified(editor))) continue;
                rangeMarker.dispose();
                return;
            }
            if (!AbstractBasicJavaSmartEnterProcessor.isModified(editor) && !afterCompletion) {
                AbstractBasicJavaSmartEnterProcessor.plainEnter(editor);
            } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
        }
        rangeMarker.dispose();
    }

    private static void collectAllElements(ASTNode atCaret, List<? super ASTNode> res, boolean recurse) {
        res.add(0, (ASTNode)atCaret);
        if (AbstractBasicJavaSmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        List<ASTNode> children = BasicJavaAstTreeUtil.getChildren(atCaret);
        for (ASTNode child : children) {
            if (BasicJavaAstTreeUtil.is(atCaret, BasicJavaElementType.STATEMENT_SET) && BasicJavaAstTreeUtil.is(child, BasicJavaElementType.STATEMENT_SET) && (!BasicJavaAstTreeUtil.is(atCaret, BasicJavaElementType.BASIC_FOR_STATEMENT) || child != BasicJavaAstTreeUtil.getForInitialization(atCaret))) continue;
            AbstractBasicJavaSmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(ASTNode element) {
        return BasicJavaAstTreeUtil.is(element, BasicJavaElementType.CLASS_SET) || BasicJavaAstTreeUtil.is(element, BasicJavaElementType.BASIC_CODE_BLOCK) || BasicJavaAstTreeUtil.is(element, BasicJavaElementType.STATEMENT_SET) || BasicJavaAstTreeUtil.is(element, BasicJavaElementType.BASIC_METHOD);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement atCaretElement = super.getStatementAtCaret(editor, psiFile);
        if (atCaretElement == null) {
            return null;
        }
        ASTNode atCaret = atCaretElement.getNode();
        if (BasicJavaAstTreeUtil.isWhiteSpace(atCaret)) {
            return null;
        }
        if (BasicJavaAstTreeUtil.is(atCaret, JavaTokenType.RBRACE)) {
            boolean expressionEndingWithBrace;
            boolean bl = expressionEndingWithBrace = BasicJavaAstTreeUtil.is(atCaret = atCaret.getTreeParent(), BasicJavaElementType.BASIC_ANONYMOUS_CLASS) || BasicJavaAstTreeUtil.is(atCaret, BasicJavaElementType.BASIC_ARRAY_INITIALIZER_EXPRESSION) || BasicJavaAstTreeUtil.is(atCaret, BasicJavaElementType.BASIC_CODE_BLOCK) && (BasicJavaAstTreeUtil.is(atCaret.getTreeParent(), BasicJavaElementType.BASIC_LAMBDA_EXPRESSION) || BasicJavaAstTreeUtil.is(atCaret.getTreeParent(), BasicJavaElementType.BASIC_SWITCH_EXPRESSION));
            if (!expressionEndingWithBrace) {
                return null;
            }
        }
        for (ASTNode each : SyntaxTraverser.astApi().parents((Object)atCaret).skip(1)) {
            PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(each);
            if (BasicJavaAstTreeUtil.is(each, BasicJavaElementType.MEMBER_SET) || this.isImportStatementBase(psiElement) || BasicJavaAstTreeUtil.is(each, BasicJavaElementType.BASIC_PACKAGE_STATEMENT) || BasicJavaAstTreeUtil.is(each, BasicJavaElementType.BASIC_ANNOTATION) && psiElement != null && PsiTreeUtil.hasErrorElements((PsiElement)psiElement)) {
                return each.getPsi();
            }
            if (BasicJavaAstTreeUtil.is(each, BasicJavaElementType.BASIC_CODE_BLOCK) || BasicJavaAstTreeUtil.is(each, BasicElementTypes.BASIC_JAVA_COMMENT_BIT_SET)) {
                return null;
            }
            if (BasicJavaAstTreeUtil.is(each, BasicJavaElementType.STATEMENT_SET)) {
                return BasicJavaAstTreeUtil.is(each.getTreeParent(), BasicJavaElementType.BASIC_FOR_STATEMENT) && !PsiTreeUtil.hasErrorElements((PsiElement)each.getPsi()) ? each.getPsi().getParent() : each.getPsi();
            }
            if (!BasicJavaAstTreeUtil.is(each, BasicJavaElementType.BASIC_CONDITIONAL_EXPRESSION) || !PsiUtilCore.hasErrorElementChild((PsiElement)each.getPsi())) continue;
            return each.getPsi();
        }
        return null;
    }

    protected abstract boolean isImportStatementBase(PsiElement var1);

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(14);
        }
        if (file == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(15);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CommonCodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file).getCommonSettings((Language)JavaLanguage.INSTANCE);
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement leaf = file.findElementAt(caretOffset - 1);
            PsiElement elt = BasicJavaAstTreeUtil.toPsi(BasicJavaAstTreeUtil.getParentOfType(BasicJavaAstTreeUtil.toNode(leaf), BasicJavaElementType.BASIC_CODE_BLOCK));
            if (elt == null && leaf != null && leaf.getParent() != null && BasicJavaAstTreeUtil.is(leaf.getParent().getNode(), BasicJavaElementType.CLASS_SET)) {
                elt = leaf.getParent();
            }
            this.reformatAndMove(editor, elt, caretOffset);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            this.reformatBlockParentIfNeeded(editor, file);
        }
    }

    protected void reformatAndMove(@NotNull Editor editor, @Nullable PsiElement elt, int caretOffset) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(16);
        }
        this.reformat(elt);
        editor.getCaretModel().moveToOffset(caretOffset - 1);
    }

    protected void reformat(@NotNull Editor editor, @Nullable PsiElement elt) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(17);
        }
        this.reformat(elt);
    }

    private void reformatBlockParentIfNeeded(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(18);
        }
        if (file == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(19);
        }
        this.commit(editor);
        ASTNode block = BasicJavaAstTreeUtil.findElementOfClassAtOffset(file, editor.getCaretModel().getOffset(), BasicJavaElementType.BASIC_CODE_BLOCK, false);
        if (block != null && BasicJavaAstTreeUtil.is(block.getTreeParent(), BasicJavaElementType.BASIC_BLOCK_STATEMENT) && BasicJavaAstTreeUtil.is(block.getTreeParent().getTreeParent(), BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            this.reformat(block.getTreeParent().getTreeParent().getPsi());
        }
        if (block != null && BasicJavaAstTreeUtil.is(block.getTreeParent(), BasicJavaElementType.BASIC_SWITCH_EXPRESSION)) {
            this.reformat(block.getTreeParent().getPsi());
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    public void setSkipEnter(boolean skipEnter) {
        this.mySkipEnter = skipEnter;
    }

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(20);
        }
        AbstractBasicJavaSmartEnterProcessor.getEnterHandler().execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        Long timestamp;
        if (editor == null) {
            AbstractBasicJavaSmartEnterProcessor.$$$reportNull$$$0(21);
        }
        return (timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP)) != null && editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thinJavadocFixer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakerEnterProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enterProcessors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterCompletionEnterProcessors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/AbstractBasicJavaSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertBraces";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insertCloseBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterCompletion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretInsideBracesIfAny";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatAndMove";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "reformat";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatBlockParentIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "plainEnter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TooManyAttemptsException
    extends Exception {
        private TooManyAttemptsException() {
        }
    }
}

