/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.AnnotationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.BlockFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ClassFilter;
import com.intellij.structuralsearch.impl.matcher.filters.CommentFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ConstantFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DeclarationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ExpressionFilter;
import com.intellij.structuralsearch.impl.matcher.filters.JavaDocFilter;
import com.intellij.structuralsearch.impl.matcher.filters.MethodFilter;
import com.intellij.structuralsearch.impl.matcher.filters.StatementFilter;
import com.intellij.structuralsearch.impl.matcher.filters.SymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeParameterFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypedSymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.AnnotationHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DeclarationStatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DocDataHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.ExpressionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.StatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SymbolHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TypedSymbolHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.ExprTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilingVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final GlobalCompilingVisitor myCompilingVisitor;
    @NonNls
    private static final Pattern COMMENT_PATTERN = Pattern.compile("__\\$_\\w+");
    private static final Set<String> excludedKeywords = ContainerUtil.newHashSet((Object[])new String[]{"class", "interface", "enum", "throws", "extends", "implements"});

    public JavaCompilingVisitor(@NotNull GlobalCompilingVisitor compilingVisitor) {
        if (compilingVisitor == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(0);
        }
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement @NotNull [] topLevelElements) {
        CompileContext context;
        if (topLevelElements == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(1);
        }
        JavaWordOptimizer optimizer = DumbService.isDumb((Project)(context = this.myCompilingVisitor.getContext()).getProject()) ? null : new JavaWordOptimizer();
        CompiledPattern pattern = context.getPattern();
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            if (optimizer != null) {
                element.accept((PsiElementVisitor)optimizer);
            }
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    public void visitDocTag(@NotNull PsiDocTag psiDocTag) {
        if (psiDocTag == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(2);
        }
        super.visitDocTag(psiDocTag);
        DocValuesIterator nodes = new DocValuesIterator(psiDocTag.getFirstChild());
        while (nodes.hasNext()) {
            this.myCompilingVisitor.setHandler(nodes.current(), (MatchingHandler)new DocDataHandler());
            nodes.advance();
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(3);
        }
        super.visitComment(comment);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        GlobalCompilingVisitor.setFilter((MatchingHandler)pattern.getHandler((PsiElement)comment), (NodeFilter)CommentFilter.getInstance());
        String commentText = JavaMatchUtil.getCommentText(comment).trim();
        if (COMMENT_PATTERN.matcher(commentText).matches()) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler(commentText);
            if (handler == null) {
                throw new MalformedPatternException();
            }
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            RegExpPredicate predicate = (RegExpPredicate)handler.findPredicate(RegExpPredicate.class);
            if (GlobalCompilingVisitor.isSuitablePredicate((RegExpPredicate)predicate, (SubstitutionHandler)handler)) {
                this.myCompilingVisitor.processTokenizedName(predicate.getRegExp(), GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
        } else if (!commentText.isEmpty()) {
            if (this.myCompilingVisitor.hasFragments(commentText)) {
                MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(comment instanceof PsiDocComment ? comment.getText() : JavaMatchUtil.getCommentText(comment).trim(), GlobalCompilingVisitor.OccurenceKind.COMMENT);
                if (handler != null) {
                    comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                }
            } else {
                this.myCompilingVisitor.processTokenizedName(commentText, GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
        }
    }

    public void visitExpression(@NotNull PsiExpression expression) {
        MatchingHandler handler;
        if (expression == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(4);
        }
        super.visitExpression(expression);
        if (!(expression.getParent() instanceof PsiExpressionStatement) && !(expression instanceof PsiParenthesizedExpression) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)expression)).getFilter() == null) {
            handler.setFilter(e -> DefaultFilter.accepts((PsiElement)expression, (PsiElement)(e instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)e)) : e)));
        }
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        String text;
        if (expression == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(5);
        }
        if (StringUtil.isQuotedString((String)(text = expression.getText()))) {
            @Nullable MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.LITERAL);
            if (PsiTypes.charType().equals((Object)expression.getType()) && (handler instanceof LiteralWithSubstitutionHandler || handler == null && expression.getValue() == null)) {
                throw new MalformedPatternException(SSRBundle.message((String)"error.bad.character.literal", (Object[])new Object[0]));
            }
            if (handler != null) {
                expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        } else if (!PsiTypes.nullType().equals(expression.getType()) && expression.getValue() == null) {
            throw new MalformedPatternException(SSRBundle.message((String)"error.bad.literal", (Object[])new Object[0]));
        }
        super.visitLiteralExpression(expression);
    }

    public void visitField(@NotNull PsiField psiField) {
        if (psiField == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(6);
        }
        super.visitField(psiField);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiField);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiField, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperFields(true);
        }
    }

    public void visitMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(7);
        }
        super.visitMethod(psiMethod);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiMethod);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiMethod, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperMethods(true);
        }
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)MethodFilter.getInstance());
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        if (reference == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(8);
        }
        this.visitElement((PsiElement)reference);
        PsiElement referenceParent = reference.getParent();
        CompileContext context = this.myCompilingVisitor.getContext();
        CompiledPattern pattern = context.getPattern();
        boolean typedVar = pattern.isRealTypedVar((PsiElement)reference) && reference.getQualifierExpression() == null && !(referenceParent instanceof PsiExpressionStatement);
        MatchingHandler handler = pattern.getHandler((PsiElement)reference);
        if (reference.getParent() instanceof PsiLambdaExpression) {
            GlobalCompilingVisitor.setFilter((MatchingHandler)handler, element -> true);
        } else {
            GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)ExpressionFilter.getInstance());
        }
        String referencedName = reference.getReferenceName();
        if (!typedVar && !(handler instanceof SubstitutionHandler)) {
            PsiElement resolve = DumbService.isDumb((Project)context.getProject()) ? null : reference.resolve();
            PsiElement referenceQualifier = reference.getQualifier();
            if (resolve instanceof PsiClass || resolve == null && (referencedName != null && Character.isUpperCase(referencedName.charAt(0)) || referenceQualifier == null)) {
                PsiExpression qualifier;
                boolean hasNoNestedSubstitutionHandlers = false;
                PsiReferenceExpression currentReference = reference;
                while ((qualifier = currentReference.getQualifierExpression()) != null) {
                    if (!(qualifier instanceof PsiReferenceExpression) || pattern.getHandler((PsiElement)qualifier) instanceof SubstitutionHandler) {
                        hasNoNestedSubstitutionHandlers = true;
                        break;
                    }
                    currentReference = (PsiReferenceExpression)qualifier;
                }
                if (!hasNoNestedSubstitutionHandlers && PsiTreeUtil.getChildOfType((PsiElement)reference, PsiAnnotation.class) == null) {
                    String fqName;
                    String text = resolve != null ? ((fqName = ((PsiClass)resolve).getQualifiedName()) == null ? reference.getText() : fqName) : reference.getText();
                    this.createAndSetSubstitutionHandlerFromReference((PsiElement)reference, text, referenceParent instanceof PsiReferenceExpression);
                }
            }
        }
    }

    public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
        if (statement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(9);
        }
        super.visitBlockStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, BlockFilter.getInstance());
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(10);
        }
        super.visitSwitchStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchBlock);
    }

    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        if (statement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(11);
        }
        super.visitSwitchLabelStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchLabelStatementBase);
    }

    public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
        if (statement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(12);
        }
        super.visitSwitchLabeledRuleStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchLabelStatementBase);
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(13);
        }
        super.visitVariable(variable);
        this.myCompilingVisitor.setFilterSimple((PsiElement)variable, e -> e instanceof PsiVariable);
    }

    public void visitParameter(@NotNull PsiParameter parameter) {
        SubstitutionHandler substitutionHandler;
        if (parameter == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(14);
        }
        super.visitParameter(parameter);
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandlerSimple((PsiElement)parameter);
        @NonNls String name = "__catch_" + parent.getTextOffset();
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler parameterHandler = (SubstitutionHandler)handler;
            substitutionHandler = new SubstitutionHandler(name, false, parameterHandler.getMinOccurs(), parameterHandler.isTarget() ? Integer.MAX_VALUE : parameterHandler.getMaxOccurs(), true);
        } else {
            substitutionHandler = new SubstitutionHandler(name, false, 1, 1, true);
        }
        pattern.setHandler(parent, (MatchingHandler)substitutionHandler);
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement psiDeclarationStatement) {
        if (psiDeclarationStatement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(15);
        }
        super.visitDeclarationStatement(psiDeclarationStatement);
        PsiElement firstChild = psiDeclarationStatement.getFirstChild();
        if (firstChild instanceof PsiTypeElement) {
            PsiTypeElement[] typeParameterElements;
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement reference = ((PsiTypeElement)firstChild).getInnermostComponentReferenceElement();
            if (reference != null && (parameterList = reference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0) {
                this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)new TypedSymbolHandler());
                this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, TypedSymbolNodeFilter.getInstance());
                for (PsiTypeElement param : typeParameterElements) {
                    if (param.getInnermostComponentReferenceElement() == null || !this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(param.getInnermostComponentReferenceElement().getReferenceNameElement())) continue;
                    this.myCompilingVisitor.setFilterSimple((PsiElement)param, TypeParameterFilter.getInstance());
                }
                return;
            }
        } else if (firstChild instanceof PsiModifierList) {
            PsiModifierList modifierList = (PsiModifierList)firstChild;
            PsiAnnotation[] annotations = modifierList.getAnnotations();
            if (annotations.length != 1) {
                throw new MalformedPatternException();
            }
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                throw new MalformedPatternException();
            }
            this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)new AnnotationHandler());
            this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, AnnotationFilter.getInstance());
            return;
        }
        DeclarationStatementHandler handler = new DeclarationStatementHandler();
        this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)handler);
        PsiElement previousNonWhiteSpace = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiDeclarationStatement);
        if (previousNonWhiteSpace instanceof PsiComment) {
            handler.setCommentHandler(this.myCompilingVisitor.getContext().getPattern().getHandler(previousNonWhiteSpace));
            this.myCompilingVisitor.getContext().getPattern().setHandler(previousNonWhiteSpace, (MatchingHandler)handler);
        }
        handler.setFilter(DeclarationFilter.getInstance());
    }

    public void visitDocComment(@NotNull PsiDocComment psiDocComment) {
        if (psiDocComment == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(16);
        }
        super.visitDocComment(psiDocComment);
        this.myCompilingVisitor.setFilterSimple((PsiElement)psiDocComment, JavaDocFilter.getInstance());
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(17);
        }
        super.visitReferenceElement(reference);
        PsiElement parent = reference.getParent();
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference);
        if (parent != null && parent.getParent() instanceof PsiClass) {
            GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)TypeFilter.getInstance());
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            if (newExpression.isArrayCreation()) {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiJavaCodeReferenceElement || e instanceof PsiKeyword);
            } else {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiJavaCodeReferenceElement);
            }
        } else if (!(parent instanceof PsiAnnotation)) {
            GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiJavaCodeReferenceElement);
        }
    }

    public void visitTypeElement(@NotNull PsiTypeElement type) {
        if (type == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(18);
        }
        super.visitTypeElement(type);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)type);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiTypeElement);
    }

    public void visitClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(19);
        }
        super.visitClass(psiClass);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiClass);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiClass, handler)) {
            ((JavaCompiledPattern)pattern).setRequestsSuperInners(true);
        }
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)ClassFilter.getInstance());
    }

    private void createAndSetSubstitutionHandlerFromReference(PsiElement expr, String referenceText, boolean classQualifier) {
        SubstitutionHandler substitutionHandler = new SubstitutionHandler("__" + referenceText.replace('.', '_'), false, classQualifier ? 0 : 1, 1, true);
        if (classQualifier) {
            substitutionHandler.setSubtype(true);
        }
        boolean caseSensitive = this.myCompilingVisitor.getContext().getOptions().isCaseSensitiveMatch();
        substitutionHandler.setPredicate((MatchPredicate)new RegExpPredicate(MatchUtil.shieldRegExpMetaChars((String)referenceText), caseSensitive, null, false, false));
        this.myCompilingVisitor.getContext().getPattern().setHandler(expr, (MatchingHandler)substitutionHandler);
    }

    public void visitExpressionStatement(@NotNull PsiExpressionStatement expressionStatement) {
        MatchingHandler handler;
        if (expressionStatement == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(20);
        }
        super.visitExpressionStatement(expressionStatement);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        PsiElement child = expressionStatement.getLastChild();
        PsiElement parent = expressionStatement.getParent();
        if (!(child instanceof PsiJavaToken) && !(child instanceof PsiComment) && parent instanceof PsiCodeFragment) {
            SubstitutionHandler substitutionHandler;
            PsiElement reference = expressionStatement.getFirstChild();
            MatchingHandler referenceHandler = pattern.getHandler(reference);
            if (referenceHandler instanceof SubstitutionHandler && (substitutionHandler = (SubstitutionHandler)referenceHandler).findPredicate(ExprTypePredicate.class) == null && reference instanceof PsiReferenceExpression) {
                pattern.setHandler((PsiElement)expressionStatement, referenceHandler);
                referenceHandler.setFilter(SymbolNodeFilter.getInstance());
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)new SymbolHandler(substitutionHandler));
            } else if (reference instanceof PsiLiteralExpression) {
                ExpressionHandler handler2 = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)handler2);
                handler2.setFilter(ConstantFilter.getInstance());
            } else {
                ExpressionHandler handler3 = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)handler3);
                handler3.setFilter(ExpressionFilter.getInstance());
            }
        } else if (expressionStatement.getExpression() instanceof PsiReferenceExpression && pattern.isRealTypedVar((PsiElement)expressionStatement) && (handler = pattern.getHandler((PsiElement)expressionStatement)) instanceof SubstitutionHandler) {
            PsiForStatement forStatement;
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            if (parent instanceof PsiForStatement && ((forStatement = (PsiForStatement)parent).getInitialization() == expressionStatement || forStatement.getUpdate() == expressionStatement)) {
                substitutionHandler.setFilter(e -> e instanceof PsiExpression || e instanceof PsiExpressionListStatement || e instanceof PsiDeclarationStatement || e instanceof PsiEmptyStatement);
            } else {
                substitutionHandler.setFilter((NodeFilter)new StatementFilter());
                substitutionHandler.setMatchHandler((MatchingHandler)new StatementHandler());
            }
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(21);
        }
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitCodeBlock(@NotNull PsiCodeBlock block) {
        if (block == null) {
            JavaCompilingVisitor.$$$reportNull$$$0(22);
        }
        for (PsiElement el = block.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                if (!(el instanceof PsiWhiteSpace)) continue;
                this.myCompilingVisitor.addLexicalNode(el);
                continue;
            }
            el.accept((PsiElementVisitor)this);
        }
    }

    private static boolean needsSupers(PsiElement element, MatchingHandler handler) {
        if (element.getParent() instanceof PsiClass && handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            return handler2.isStrictSubtype() || handler2.isSubtype();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocTag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDeclarationStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocComment";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/JavaCompilingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocTag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlockStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchLabelStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchLabeledRuleStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParameter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDeclarationStatement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocComment";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClass";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpressionStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCodeBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JavaWordOptimizer
    extends JavaRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private JavaWordOptimizer() {
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                JavaWordOptimizer.$$$reportNull$$$0(0);
            }
            String word = reference.getReferenceName();
            PsiElement target = reference.resolve();
            if (target == null && Strings.isCapitalized((String)word)) {
                return;
            }
            if (!(!this.handleWord(word, GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext()) || JavaWordOptimizer.isStaticAccessibleFromSubclass(target) || reference.isQualified() && JavaWordOptimizer.isClassFromJavaLangPackage(target))) {
                super.visitReferenceElement(reference);
            }
        }

        private static boolean isStaticAccessibleFromSubclass(PsiElement element) {
            PsiMember member;
            if (!(element instanceof PsiMember) || !(member = (PsiMember)element).hasModifierProperty("static")) {
                return false;
            }
            PsiClass aClass = member.getContainingClass();
            return aClass == null || !aClass.isInterface() && !aClass.hasModifierProperty("final");
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                JavaWordOptimizer.$$$reportNull$$$0(1);
            }
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private static boolean isClassFromJavaLangPackage(PsiElement target) {
            PsiJavaFile javaFile;
            PsiFile psiFile;
            return target instanceof PsiClass && (psiFile = target.getContainingFile()) instanceof PsiJavaFile && "java.lang".equals((javaFile = (PsiJavaFile)psiFile).getPackageName());
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                JavaWordOptimizer.$$$reportNull$$$0(2);
            }
            if (!this.handleWord(method.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitMethod(method);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                JavaWordOptimizer.$$$reportNull$$$0(3);
            }
            if (!this.handleWord(variable.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitCatchSection(@NotNull PsiCatchSection section) {
            PsiParameter parameter;
            if (section == null) {
                JavaWordOptimizer.$$$reportNull$$$0(4);
            }
            if ((parameter = section.getParameter()) != null && !this.handleWord(parameter.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitCatchSection(section);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                JavaWordOptimizer.$$$reportNull$$$0(5);
            }
            CompileContext context = JavaCompilingVisitor.this.myCompilingVisitor.getContext();
            if (!this.handleWord(aClass.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, context)) {
                return;
            }
            if (aClass.isInterface()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"interface", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            } else if (aClass.isEnum()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"enum", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            } else if (aClass.isRecord()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"record", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            } else {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"interface", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"enum", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"record", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"class", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            }
            super.visitClass(aClass);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                JavaWordOptimizer.$$$reportNull$$$0(6);
            }
            PsiType type = expression.getType();
            if ((PsiTypes.booleanType().equals((Object)type) || PsiTypes.nullType().equals(type)) && !this.handleWord(expression.getText(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitLiteralExpression(expression);
        }

        public void visitElement(@NotNull PsiElement element) {
            String keyword;
            if (element == null) {
                JavaWordOptimizer.$$$reportNull$$$0(7);
            }
            super.visitElement(element);
            if (element instanceof PsiMethodReferenceExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"::", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiLambdaExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"->", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiKeyword && (!excludedKeywords.contains(keyword = element.getText()) || element.getParent() instanceof PsiExpression)) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)keyword, (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }

        @NotNull
        public List<String> getDescendantsOf(@NotNull String className, boolean includeSelf, @NotNull Project project) {
            if (className == null) {
                JavaWordOptimizer.$$$reportNull$$$0(8);
            }
            if (project == null) {
                JavaWordOptimizer.$$$reportNull$$$0(9);
            }
            SmartList result = new SmartList();
            GlobalSearchScope projectAndLibraries = ProjectScope.getAllScope((Project)project);
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(className, projectAndLibraries);
            if (classes.length == 0) {
                result.add(className);
                SmartList smartList = result;
                if (smartList == null) {
                    JavaWordOptimizer.$$$reportNull$$$0(10);
                }
                return smartList;
            }
            for (PsiClass aClass : classes) {
                String name;
                if (includeSelf && (name = aClass.getName()) != null) {
                    result.add(name);
                }
                ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)projectAndLibraries, (boolean)true).forEach(arg_0 -> JavaWordOptimizer.lambda$getDescendantsOf$0((List)result, arg_0));
            }
            SmartList smartList = result;
            if (smartList == null) {
                JavaWordOptimizer.$$$reportNull$$$0(11);
            }
            return smartList;
        }

        private static /* synthetic */ boolean lambda$getDescendantsOf$0(List result, PsiClass c) {
            String name = c.getName();
            if (name != null) {
                result.add(name);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "section";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/JavaCompilingVisitor$JavaWordOptimizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/JavaCompilingVisitor$JavaWordOptimizer";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescendantsOf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCatchSection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLiteralExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitElement";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescendantsOf";
                    break;
                }
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

