/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.JavaApiUsageInspectionKt;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uast.UastVisitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/codeInspection/JavaApiUsageInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "effectiveLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "readSettings", "", "node", "Lorg/jdom/Element;", "writeSettings", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "shouldReportSinceLevelForElement", "lastIncompatibleLevel", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/pom/java/LanguageLevel;Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "registerError", "reference", "sinceLanguageLevel", "getEffectiveLanguageLevel", "module", "Lcom/intellij/openapi/module/Module;", "JavaApiUsageVisitor", "JavaApiUsageProcessor", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJavaApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,255:1\n11165#2:256\n11500#2,3:257\n37#3,2:260\n207#4:262\n*S KotlinDebug\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection\n*L\n54#1:256\n54#1:257,3\n57#1:260,2\n240#1:262\n*E\n"})
public final class JavaApiUsageInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    private LanguageLevel effectiveLanguageLevel;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OptPane getOptionsPane() {
        void $this$mapTo$iv$iv;
        LanguageLevel[] $this$map$iv = LanguageLevel.values();
        boolean $i$f$map = false;
        LanguageLevel[] languageLevelArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OptPane.option((String)it.name(), (String)it.getPresentableText()));
        }
        List levels = (List)destination$iv$iv;
        levels = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)OptPane.option((String)"null", (String)JavaBundle.message((String)"label.forbid.api.usages.project", (Object[])new Object[0]))), (Iterable)levels);
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[1];
        Collection $this$toTypedArray$iv = levels;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        languageLevelArray = thisCollection$iv.toArray(new OptDropdown.Option[0]);
        optRegularComponentArray[0] = OptPane.dropdown((String)"effectiveLanguageLevel", (String)JavaBundle.message((String)"label.forbid.api.usages", (Object[])new Object[0]), (OptDropdown.Option[])((OptDropdown.Option[])Arrays.copyOf(languageLevelArray, languageLevelArray.length)));
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("effectiveLanguageLevel", () -> JavaApiUsageInspection.getOptionController$lambda$1(this), arg_0 -> JavaApiUsageInspection.getOptionController$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        return optionController;
    }

    /*
     * WARNING - void declaration
     */
    public void readSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element element = node.getChild("effectiveLL");
        if (element != null) {
            LanguageLevel languageLevel;
            JavaApiUsageInspection javaApiUsageInspection = this;
            String string = element.getAttributeValue("value");
            if (string != null) {
                void it;
                String string2 = string;
                JavaApiUsageInspection javaApiUsageInspection2 = javaApiUsageInspection;
                boolean bl = false;
                languageLevel = LanguageLevel.valueOf((String)it);
                javaApiUsageInspection = javaApiUsageInspection2;
            } else {
                languageLevel = null;
            }
            javaApiUsageInspection.effectiveLanguageLevel = languageLevel;
        }
    }

    public void writeSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.effectiveLanguageLevel != null) {
            Element llElement = new Element("effectiveLL");
            llElement.setAttribute("value", String.valueOf(this.effectiveLanguageLevel));
            node.addContent(llElement);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new UastVisitorAdapter((AbstractUastNonRecursiveVisitor)new JavaApiUsageVisitor(new JavaApiUsageProcessor(isOnTheFly, holder), holder, isOnTheFly), true);
    }

    private final Boolean shouldReportSinceLevelForElement(LanguageLevel lastIncompatibleLevel, PsiElement context) {
        JavaSdkVersion javaSdkVersion = JavaVersionService.getInstance().getJavaSdkVersion(context);
        if (javaSdkVersion == null) {
            return null;
        }
        JavaSdkVersion jdkVersion = javaSdkVersion;
        return lastIncompatibleLevel.isAtLeast(jdkVersion.getMaxLanguageLevel()) && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private final void registerError(PsiElement reference, LanguageLevel sinceLanguageLevel, ProblemsHolder holder, boolean isOnTheFly) {
        LocalQuickFix localQuickFix;
        LanguageLevel languageLevel = LanguageLevelUtil.getNextLanguageLevel((LanguageLevel)sinceLanguageLevel);
        if (languageLevel == null) {
            JavaApiUsageInspection $this$registerError_u24lambda_u244 = this;
            boolean bl = false;
            JavaApiUsageInspectionKt.access$getLogger$p().error("Unable to get the next language level for " + sinceLanguageLevel);
            return;
        }
        LanguageLevel targetLanguageLevel = languageLevel;
        PsiElement $this$getUastParentOfType_u24default$iv = reference;
        boolean strict$iv22 = false;
        boolean $i$f$getUastParentOfType = false;
        if (UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UComment.class, (boolean)strict$iv22) != null) {
            return;
        }
        Object[] strict$iv22 = new Object[]{LanguageLevelUtil.getShortMessage((LanguageLevel)sinceLanguageLevel)};
        String message = JvmAnalysisBundle.message("jvm.inspections.1.5.problem.descriptor", strict$iv22);
        if (isOnTheFly) {
            IntentionAction intentionAction = QuickFixFactory.getInstance().createIncreaseLanguageLevelFix(targetLanguageLevel);
            Intrinsics.checkNotNull((Object)intentionAction, (String)"null cannot be cast to non-null type com.intellij.codeInspection.LocalQuickFix");
            localQuickFix = (LocalQuickFix)intentionAction;
        } else {
            localQuickFix = null;
        }
        LocalQuickFix fix = localQuickFix;
        LocalQuickFix[] localQuickFixArray = LocalQuickFix.notNullElements((LocalQuickFix)fix);
        holder.registerProblem(reference, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
    }

    @NotNull
    public final LanguageLevel getEffectiveLanguageLevel(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LanguageLevel languageLevel = this.effectiveLanguageLevel;
        if (languageLevel == null) {
            LanguageLevel languageLevel2 = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            languageLevel = languageLevel2;
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"getEffectiveLanguageLevel(...)");
        }
        return languageLevel;
    }

    private static final String getOptionController$lambda$1(JavaApiUsageInspection this$0) {
        Object object = this$0.effectiveLanguageLevel;
        if (object == null || (object = object.name()) == null) {
            object = "null";
        }
        return object;
    }

    private static final void getOptionController$lambda$2(JavaApiUsageInspection this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.effectiveLanguageLevel = switch (value.hashCode()) {
            case 3392903 -> {
                if (value.equals("null")) {
                    yield null;
                }
            }
            default -> LanguageLevel.valueOf((String)value);
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00142\u000e\u0010!\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\"H\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006%"}, d2={"Lcom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "isOnTheFly", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/JavaApiUsageInspection;ZLcom/intellij/codeInspection/ProblemsHolder;)V", "ignored6ClassesApi", "", "", "getIgnored6ClassesApi", "()Ljava/util/Set;", "generifiedClasses", "getGenerifiedClasses", "processConstructorInvocation", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processReference", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "isRawInheritance", "generifiedClassQName", "currentClass", "visited", "", "isIgnored", "psiClass", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nJavaApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,255:1\n151#1:256\n150#1:259\n12574#2,2:257\n*S KotlinDebug\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageProcessor\n*L\n199#1:256\n225#1:259\n213#1:257,2\n*E\n"})
    public final class JavaApiUsageProcessor
    implements ApiUsageProcessor {
        private final boolean isOnTheFly;
        @NotNull
        private final ProblemsHolder holder;

        public JavaApiUsageProcessor(@NotNull boolean isOnTheFly, ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.isOnTheFly = isOnTheFly;
            this.holder = holder;
        }

        private final Set<String> getIgnored6ClassesApi() {
            boolean $i$f$getIgnored6ClassesApi = false;
            return SetsKt.setOf((Object)"java.awt.geom.GeneralPath");
        }

        private final Set<String> getGenerifiedClasses() {
            boolean $i$f$getGenerifiedClasses = false;
            Object[] objectArray = new String[]{"javax.swing.JComboBox", "javax.swing.ListModel", "javax.swing.JList"};
            return SetsKt.setOf((Object[])objectArray);
        }

        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)instantiatedClass, (String)"instantiatedClass");
            if (constructor == null) {
                return;
            }
            PsiElement psiElement = sourceNode.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            if (module == null) {
                return;
            }
            Module module2 = module;
            LanguageLevel languageLevel = JavaApiUsageInspection.this.getEffectiveLanguageLevel(module2);
            LanguageLevel languageLevel2 = LanguageLevelUtil.getLastIncompatibleLanguageLevel((PsiMember)((PsiMember)constructor), (LanguageLevel)languageLevel);
            if (languageLevel2 == null) {
                return;
            }
            LanguageLevel lastIncompatibleLevel = languageLevel2;
            if (Intrinsics.areEqual((Object)JavaApiUsageInspection.this.shouldReportSinceLevelForElement(lastIncompatibleLevel, sourcePsi), (Object)true)) {
                return;
            }
            JavaApiUsageInspection.this.registerError(sourcePsi, lastIncompatibleLevel, this.holder, this.isOnTheFly);
        }

        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            PsiElement psiElement = sourceNode.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            if (!(target instanceof PsiMember)) {
                return;
            }
            LanguageLevel languageLevel = null;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            if (module != null) {
                languageLevel = JavaApiUsageInspection.this.getEffectiveLanguageLevel(module);
                if (languageLevel.isUnsupported()) {
                    languageLevel = languageLevel.getNonPreviewLevel();
                }
            } else if (sourcePsi.getContainingFile().getVirtualFile() instanceof LightVirtualFile) {
                languageLevel = (LanguageLevel)sourcePsi.getContainingFile().getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
            }
            if (languageLevel == null) {
                return;
            }
            LanguageLevel lastIncompatibleLevel = LanguageLevelUtil.getLastIncompatibleLanguageLevel((PsiMember)((PsiMember)target), (LanguageLevel)languageLevel);
            if (lastIncompatibleLevel != null) {
                PsiClass psiClass;
                if (Intrinsics.areEqual((Object)JavaApiUsageInspection.this.shouldReportSinceLevelForElement(lastIncompatibleLevel, sourcePsi), (Object)true)) {
                    return;
                }
                if (qualifier != null) {
                    v1 = PsiUtil.resolveClassInType((PsiType)qualifier.getExpressionType());
                } else {
                    UClass uClass = UastUtils.getContainingUClass((UElement)sourceNode);
                    v1 = psiClass = uClass != null ? uClass.getJavaPsi() : null;
                }
                if (psiClass != null) {
                    if (this.isIgnored(psiClass)) {
                        return;
                    }
                    for (PsiClass superClass : psiClass.getSupers()) {
                        Intrinsics.checkNotNull((Object)superClass);
                        if (!this.isIgnored(superClass)) continue;
                        return;
                    }
                }
                JavaApiUsageInspection.this.registerError(sourcePsi, lastIncompatibleLevel, this.holder, this.isOnTheFly);
            } else if (target instanceof PsiClass && !languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                JavaApiUsageProcessor this_$iv = this;
                boolean $i$f$getGenerifiedClasses = false;
                Object[] objectArray = new String[]{"javax.swing.JComboBox", "javax.swing.ListModel", "javax.swing.JList"};
                for (String generifiedClass : SetsKt.setOf((Object[])objectArray)) {
                    if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)target), (String)generifiedClass) || this.isRawInheritance(generifiedClass, (PsiClass)target, new LinkedHashSet())) continue;
                    objectArray = new Object[]{LanguageLevelUtil.getJdkName((LanguageLevel)languageLevel)};
                    String message = JvmAnalysisBundle.message("jvm.inspections.1.7.problem.descriptor", objectArray);
                    this.holder.registerProblem(sourcePsi, message, new LocalQuickFix[0]);
                    break;
                }
            }
        }

        private final boolean isRawInheritance(String generifiedClassQName, PsiClass currentClass, Set<? super PsiClass> visited) {
            boolean bl;
            block2: {
                PsiClassType[] psiClassTypeArray = currentClass.getSuperTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getSuperTypes(...)");
                Object[] $this$any$iv = psiClassTypeArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiClass superClass;
                    PsiClassType.ClassResolveResult resolveResult;
                    PsiClassType classType = (PsiClassType)element$iv;
                    boolean bl2 = false;
                    if (classType.isRaw()) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)classType.resolveGenerics(), (String)"resolveGenerics(...)");
                    if (!(resolveResult.getElement() == null ? false : visited.add((PsiClass)superClass) && InheritanceUtil.isInheritor((PsiClass)superClass, (String)generifiedClassQName) && this.isRawInheritance(generifiedClassQName, superClass, visited))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isIgnored(PsiClass psiClass) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) return false;
            JavaApiUsageProcessor this_$iv = this;
            boolean $i$f$getIgnored6ClassesApi = false;
            if (!SetsKt.setOf((Object)"java.awt.geom.GeneralPath").contains(qualifiedName)) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00108\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageVisitor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageUastVisitor;", "apiUsageProcessor", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "<init>", "(Lcom/intellij/codeInspection/JavaApiUsageInspection;Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "defaultMethods", "", "", "getDefaultMethods", "()Ljava/util/Set;", "overrideModifierLanguages", "", "getOverrideModifierLanguages", "()Ljava/util/List;", "visitClass", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "processMethodOverriding", "", "method", "overriddenMethods", "", "Lcom/intellij/psi/PsiMethod;", "(Lorg/jetbrains/uast/UMethod;[Lcom/intellij/psi/PsiMethod;)V", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nJavaApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n95#1:258\n96#1:260\n774#2:256\n865#2:257\n866#2:259\n1755#2,3:261\n11483#3,9:264\n13409#3:273\n13410#3:275\n11492#3:276\n1#4:274\n*S KotlinDebug\n*F\n+ 1 JavaApiUsageInspection.kt\ncom/intellij/codeInspection/JavaApiUsageInspection$JavaApiUsageVisitor\n*L\n106#1:258\n134#1:260\n106#1:256\n106#1:257\n106#1:259\n134#1:261,3\n139#1:264,9\n139#1:273\n139#1:275\n139#1:276\n139#1:274\n*E\n"})
    public final class JavaApiUsageVisitor
    extends ApiUsageUastVisitor {
        @NotNull
        private final ProblemsHolder holder;
        private final boolean isOnTheFly;

        public JavaApiUsageVisitor(@NotNull ApiUsageProcessor apiUsageProcessor, ProblemsHolder holder, boolean isOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)apiUsageProcessor, (String)"apiUsageProcessor");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(apiUsageProcessor);
            this.holder = holder;
            this.isOnTheFly = isOnTheFly;
        }

        private final Set<String> getDefaultMethods() {
            boolean $i$f$getDefaultMethods = false;
            return SetsKt.setOf((Object)"java.util.Iterator#remove()");
        }

        private final List<String> getOverrideModifierLanguages() {
            boolean $i$f$getOverrideModifierLanguages = false;
            Object[] objectArray = new String[]{"kotlin", "scala"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiClass javaPsi = node.getJavaPsi();
            if (!javaPsi.hasModifierProperty("abstract") && !(javaPsi instanceof PsiTypeParameter)) {
                JavaSdkVersion version;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)javaPsi));
                if (module == null) {
                    return true;
                }
                Module module2 = module;
                LanguageLevel effectiveLanguageLevel = JavaApiUsageInspection.this.getEffectiveLanguageLevel(module2);
                if (!effectiveLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (version = JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)javaPsi)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_8)) {
                    void $this$filterTo$iv$iv;
                    Collection collection = javaPsi.getVisibleSignatures();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVisibleSignatures(...)");
                    Object[] $this$filter$iv = (Object[])collection;
                    boolean $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv$iv;
                        boolean bl = false;
                        JavaApiUsageVisitor this_$iv = this;
                        boolean $i$f$getDefaultMethods = false;
                        if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object)"java.util.Iterator#remove()"), (Object)LanguageLevelUtil.getSignature((PsiMember)((PsiMember)it.getMethod())))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List mSignatures = (List)destination$iv$iv;
                    if (!((Collection)mSignatures).isEmpty()) {
                        String string;
                        String jdkName = LanguageLevelUtil.getJdkName((LanguageLevel)effectiveLanguageLevel);
                        if (mSignatures.size() == 1) {
                            objectArray = new Object[]{((HierarchicalMethodSignature)CollectionsKt.first((List)mSignatures)).getName(), jdkName};
                            string = JvmAnalysisBundle.message("jvm.inspections.1.8.problem.single.descriptor", objectArray);
                        } else {
                            objectArray = new Object[]{mSignatures.size(), jdkName};
                            string = JvmAnalysisBundle.message("jvm.inspections.1.8.problem.descriptor", objectArray);
                        }
                        String message = string;
                        UDeclaration uDeclaration = (UDeclaration)node;
                        Intrinsics.checkNotNull((Object)message);
                        objectArray = new LocalQuickFix[]{QuickFixFactory.getInstance().createImplementMethodsFix(javaPsi)};
                        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])objectArray, null, (int)8, null);
                    }
                }
            }
            return true;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.isConstructor()) {
                this.checkImplicitCallOfSuperEmptyConstructor(node);
            } else {
                PsiMethod[] psiMethodArray = node.getJavaPsi().findSuperMethods(true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                this.processMethodOverriding(node, psiMethodArray);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final void processMethodOverriding(UMethod method, PsiMethod[] overriddenMethods) {
            void $this$mapNotNullTo$iv$iv;
            boolean hasOverrideModifier;
            UAnnotation overrideAnnotation;
            block11: {
                void $this$any$iv;
                overrideAnnotation = method.findAnnotation("java.lang.Override");
                Object this_$iv = this;
                boolean $i$f$getOverrideModifierLanguages = false;
                String[] stringArray = new String[]{"kotlin", "scala"};
                this_$iv = CollectionsKt.listOf((Object[])stringArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        PsiElement psiElement = method.getSourcePsi();
                        if (!(!Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)Language.findLanguageByID((String)it)))) continue;
                        v0 = true;
                        break block11;
                    }
                    v0 = hasOverrideModifier = false;
                }
            }
            if (overrideAnnotation == null && !hasOverrideModifier) {
                return;
            }
            PsiElement psiElement = method.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            if (module == null) {
                return;
            }
            Module module2 = module;
            LanguageLevel languageLevel = JavaApiUsageInspection.this.getEffectiveLanguageLevel(module2);
            PsiMethod[] $this$mapNotNull$iv = overriddenMethods;
            boolean $i$f$mapNotNull = false;
            PsiMethod[] psiMethodArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                LanguageLevel it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void overriddenMethod = element$iv$iv;
                boolean bl2 = false;
                if (LanguageLevelUtil.getLastIncompatibleLanguageLevel((PsiMember)((PsiMember)overriddenMethod), (LanguageLevel)languageLevel) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            LanguageLevel languageLevel2 = (LanguageLevel)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
            if (languageLevel2 == null) {
                return;
            }
            LanguageLevel lastIncompatibleLevel = languageLevel2;
            Object object = overrideAnnotation;
            if (object == null || (object = object.getUastAnchor()) == null || (object = object.getSourcePsi()) == null) {
                UElement uElement = method.getUastAnchor();
                object = uElement != null ? uElement.getSourcePsi() : null;
                if (object == null) {
                    return;
                }
            }
            UAnnotation toHighlight = object;
            if (Intrinsics.areEqual((Object)JavaApiUsageInspection.this.shouldReportSinceLevelForElement(lastIncompatibleLevel, sourcePsi), (Object)true)) {
                return;
            }
            JavaApiUsageInspection.this.registerError((PsiElement)toHighlight, lastIncompatibleLevel, this.holder, this.isOnTheFly);
        }
    }
}

