/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sourceToSink;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.sourceToSink.DeepTaintAnalyzerException;
import com.intellij.codeInspection.sourceToSink.SourceToSinkProvider;
import com.intellij.codeInspection.sourceToSink.TaintAnalyzer;
import com.intellij.codeInspection.sourceToSink.TaintValue;
import com.intellij.codeInspection.sourceToSink.TaintValueFactory;
import com.intellij.codeInspection.sourceToSink.UntaintedConfiguration;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.JvmNamedElement;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeTypeRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

class MarkAsSafeFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final TaintValueFactory myTaintValueFactory;

    protected MarkAsSafeFix(@NotNull PsiElement sourcePsi, @NotNull TaintValueFactory taintValueFactory) {
        if (sourcePsi == null) {
            MarkAsSafeFix.$$$reportNull$$$0(0);
        }
        if (taintValueFactory == null) {
            MarkAsSafeFix.$$$reportNull$$$0(1);
        }
        super(sourcePsi);
        this.myTaintValueFactory = taintValueFactory;
    }

    @NotNull
    public String getText() {
        String string = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.mark.as.safe.text", new Object[0]);
        if (string == null) {
            MarkAsSafeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.mark.as.safe.family", new Object[0]);
        if (string == null) {
            MarkAsSafeFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        UExpression uExpression;
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            MarkAsSafeFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MarkAsSafeFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MarkAsSafeFix.$$$reportNull$$$0(7);
        }
        if ((uExpression = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)startElement, (Class[])new Class[]{UExpression.class})) == null) {
            return;
        }
        List<PsiElement> elements = this.getElementsToMark(uExpression);
        if (elements == null) {
            return;
        }
        MarkAsSafeFix.markAsSafe(project, elements, this.myTaintValueFactory);
    }

    @Nullable
    private List<PsiElement> getElementsToMark(@NotNull UExpression uExpression) {
        if (uExpression == null) {
            MarkAsSafeFix.$$$reportNull$$$0(8);
        }
        TaintAnalyzer taintAnalyzer = new TaintAnalyzer(this.myTaintValueFactory);
        try {
            TaintValue taintValue = taintAnalyzer.analyzeExpression(uExpression, false, TaintValue.TAINTED);
            if (taintValue != TaintValue.UNKNOWN) {
                return null;
            }
        }
        catch (DeepTaintAnalyzerException e2) {
            return null;
        }
        return taintAnalyzer.getNonMarkedElements().stream().map(e -> e.myNonMarked).distinct().sorted(Comparator.comparing(e -> e instanceof PsiMethod)).toList();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        UExpression uExpression;
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(9);
        }
        if (previewDescriptor == null) {
            MarkAsSafeFix.$$$reportNull$$$0(10);
        }
        if ((uExpression = (UExpression)UastContextKt.getUastParentOfTypes((PsiElement)previewDescriptor.getStartElement(), (Class[])new Class[]{UExpression.class})) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MarkAsSafeFix.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        List<PsiElement> toAnnotate = this.getElementsToMark(uExpression);
        if (toAnnotate == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MarkAsSafeFix.$$$reportNull$$$0(12);
            }
            return intentionPreviewInfo;
        }
        PsiElement sourcePsi = uExpression.getSourcePsi();
        if (sourcePsi == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MarkAsSafeFix.$$$reportNull$$$0(13);
            }
            return intentionPreviewInfo;
        }
        PsiFile file = sourcePsi.getContainingFile();
        String message = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.preview", new Object[0]);
        if (ContainerUtil.exists(toAnnotate, e -> MarkAsSafeFix.fileToAnnotate(e) != file)) {
            return new IntentionPreviewInfo.Html(message);
        }
        ArrayList<PsiElement> ignoredElements = new ArrayList<PsiElement>();
        MarkAsSafeFix.annotateInCode(project, toAnnotate, this.myTaintValueFactory, true, ignoredElements);
        if (ignoredElements.isEmpty()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                MarkAsSafeFix.$$$reportNull$$$0(14);
            }
            return intentionPreviewInfo;
        }
        return new IntentionPreviewInfo.Html(message);
    }

    public static void markAsSafe(@NotNull Project project, @NotNull Collection<PsiElement> toAnnotate, @NotNull TaintValueFactory taintValueFactory) {
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(15);
        }
        if (toAnnotate == null) {
            MarkAsSafeFix.$$$reportNull$$$0(16);
        }
        if (taintValueFactory == null) {
            MarkAsSafeFix.$$$reportNull$$$0(17);
        }
        Map<PsiElement, ExternalAnnotationsManager.AnnotationPlace> placedElements = MarkAsSafeFix.getPlace(project, toAnnotate);
        MarkAsSafeFix.annotate(project, placedElements, taintValueFactory);
    }

    @NotNull
    private static Map<PsiElement, ExternalAnnotationsManager.AnnotationPlace> getPlace(Project project, @NotNull Collection<PsiElement> toAnnotate) {
        if (toAnnotate == null) {
            MarkAsSafeFix.$$$reportNull$$$0(18);
        }
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        Map map = ((StreamEx)StreamEx.of(toAnnotate).distinct()).toMap(e -> e, e -> annotationsManager.chooseAnnotationsPlaceNoUi(e));
        if (map == null) {
            MarkAsSafeFix.$$$reportNull$$$0(19);
        }
        return map;
    }

    private static void annotate(@NotNull Project project, @NotNull Map<PsiElement, ExternalAnnotationsManager.AnnotationPlace> placedElement, @NotNull TaintValueFactory taintValueFactory) {
        ConflictsDialog conflictsDialog;
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(20);
        }
        if (placedElement == null) {
            MarkAsSafeFix.$$$reportNull$$$0(21);
        }
        if (taintValueFactory == null) {
            MarkAsSafeFix.$$$reportNull$$$0(22);
        }
        MultiMap problems = new MultiMap();
        ArrayList<PsiElement> toAnnotate = new ArrayList<PsiElement>();
        for (Map.Entry<PsiElement, ExternalAnnotationsManager.AnnotationPlace> entry : placedElement.entrySet()) {
            PsiElement element = entry.getKey();
            ExternalAnnotationsManager.AnnotationPlace annotationPlace = entry.getValue();
            if (annotationPlace != ExternalAnnotationsManager.AnnotationPlace.IN_CODE) {
                String message = element instanceof JvmField || element instanceof JvmMethod ? JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.config", MarkAsSafeFix.getRepresentText(element)) : JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.impossible", MarkAsSafeFix.getRepresentText(element));
                problems.put((Object)element, List.of(message));
                continue;
            }
            toAnnotate.add(element);
        }
        ArrayList<PsiElement> ignoredElements = new ArrayList<PsiElement>();
        MarkAsSafeFix.annotateInCode(project, toAnnotate, taintValueFactory, false, ignoredElements);
        for (PsiElement element : ignoredElements) {
            String message;
            if (element instanceof JvmField || element instanceof JvmMethod) {
                placedElement.put(element, ExternalAnnotationsManager.AnnotationPlace.EXTERNAL);
                message = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.config", MarkAsSafeFix.getRepresentText(element));
                problems.put((Object)element, List.of(message));
                continue;
            }
            message = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.impossible", MarkAsSafeFix.getRepresentText(element));
            problems.put((Object)element, List.of(message));
        }
        if (!problems.isEmpty() && !(conflictsDialog = new ConflictsDialog(project, problems)).showAndGet()) {
            return;
        }
        MarkAsSafeFix.run(project, placedElement, taintValueFactory);
    }

    @NotNull
    private static String getRepresentText(@NotNull PsiElement element) {
        JvmNamedElement jvmNamedElement;
        if (element == null) {
            MarkAsSafeFix.$$$reportNull$$$0(23);
        }
        if (element instanceof JvmNamedElement && (jvmNamedElement = (JvmNamedElement)element).getName() != null) {
            String string = jvmNamedElement.getName();
            if (string == null) {
                MarkAsSafeFix.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            MarkAsSafeFix.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static void run(@NotNull Project project, @NotNull Map<PsiElement, ExternalAnnotationsManager.AnnotationPlace> placedElement, @NotNull TaintValueFactory taintValueFactory) {
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(26);
        }
        if (placedElement == null) {
            MarkAsSafeFix.$$$reportNull$$$0(27);
        }
        if (taintValueFactory == null) {
            MarkAsSafeFix.$$$reportNull$$$0(28);
        }
        String title = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.mark.as.safe.command.name", new Object[0]);
        ArrayList<PsiElement> toAnnotate = new ArrayList<PsiElement>();
        ArrayList<PsiElement> toConfig = new ArrayList<PsiElement>();
        for (Map.Entry<PsiElement, ExternalAnnotationsManager.AnnotationPlace> entry : placedElement.entrySet()) {
            ExternalAnnotationsManager.AnnotationPlace annotationPlace = entry.getValue();
            if (annotationPlace == ExternalAnnotationsManager.AnnotationPlace.IN_CODE) {
                toAnnotate.add(entry.getKey());
            }
            if (annotationPlace != ExternalAnnotationsManager.AnnotationPlace.EXTERNAL && annotationPlace != ExternalAnnotationsManager.AnnotationPlace.NEED_ASK_USER) continue;
            toConfig.add(entry.getKey());
        }
        PsiFile[] files = MarkAsSafeFix.filesToAnnotate(toAnnotate);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)title, null, () -> {
            MarkAsSafeFix.annotateInCode(project, toAnnotate, taintValueFactory, true, new ArrayList<PsiElement>());
            MarkAsSafeFix.addToConfig(project, toConfig, taintValueFactory.getConfiguration());
        }, (PsiFile[])files);
    }

    private static void addToConfig(final @NotNull Project project, @NotNull List<PsiElement> config, final @NotNull UntaintedConfiguration context) {
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(29);
        }
        if (config == null) {
            MarkAsSafeFix.$$$reportNull$$$0(30);
        }
        if (context == null) {
            MarkAsSafeFix.$$$reportNull$$$0(31);
        }
        final UntaintedConfiguration previousContext = context.copy();
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> {
            for (PsiElement element : config) {
                JvmField jvmField;
                JvmClass containingClass;
                if (element instanceof JvmMethod) {
                    JvmMethod jvmMethod = (JvmMethod)element;
                    containingClass = jvmMethod.getContainingClass();
                    if (containingClass == null) continue;
                    context.getMethodClass().add(containingClass.getQualifiedName());
                    context.getMethodNames().add(jvmMethod.getName());
                }
                if (!(element instanceof JvmField) || (containingClass = (jvmField = (JvmField)element).getContainingClass()) == null) continue;
                context.getFieldClass().add(containingClass.getQualifiedName());
                context.getFieldNames().add(jvmField.getName());
            }
        });
        final UntaintedConfiguration newContext = context.copy();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> 1.copyContext(context, previousContext));
            }

            public void redo() {
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> 1.copyContext(context, newContext));
            }

            private static void copyContext(@NotNull UntaintedConfiguration context2, UntaintedConfiguration newContext2) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                context2.getMethodNames().clear();
                context2.getMethodClass().clear();
                context2.getFieldClass().clear();
                context2.getFieldNames().clear();
                context2.getMethodNames().addAll(newContext2.getMethodNames());
                context2.getMethodClass().addAll(newContext2.getMethodClass());
                context2.getFieldNames().addAll(newContext2.getFieldNames());
                context2.getFieldClass().addAll(newContext2.getFieldClass());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/sourceToSink/MarkAsSafeFix$1", "copyContext"));
            }
        });
    }

    @Nullable
    static PsiElement getSourcePsi(@NotNull PsiElement element) {
        if (element == null) {
            MarkAsSafeFix.$$$reportNull$$$0(32);
        }
        if (element.isPhysical()) {
            return element;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)element);
        if (uElement == null) {
            return null;
        }
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (sourcePsi == null) {
            SourceToSinkProvider provider = (SourceToSinkProvider)SourceToSinkProvider.sourceToSinkLanguageProvider.forLanguage(element.getLanguage());
            if (provider == null) {
                return null;
            }
            sourcePsi = provider.getPhysicalForLightElement(element);
        }
        return sourcePsi;
    }

    @Nullable
    private static PsiFile fileToAnnotate(@NotNull PsiElement element) {
        PsiElement sourcePsi;
        if (element == null) {
            MarkAsSafeFix.$$$reportNull$$$0(33);
        }
        if ((sourcePsi = MarkAsSafeFix.getSourcePsi(element)) == null) {
            return null;
        }
        return sourcePsi.getContainingFile();
    }

    private static PsiFile[] filesToAnnotate(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            MarkAsSafeFix.$$$reportNull$$$0(34);
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        for (PsiElement element : elements) {
            PsiFile psiFile = MarkAsSafeFix.fileToAnnotate(element);
            if (psiFile == null) continue;
            files.add(psiFile);
        }
        return files.toArray(PsiFile.EMPTY_ARRAY);
    }

    private static void annotateInCode(@NotNull Project project, @NotNull Collection<PsiElement> toAnnotate, @NotNull TaintValueFactory taintValueFactory, boolean makeAction, @NotNull List<PsiElement> notProcessed) {
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(35);
        }
        if (toAnnotate == null) {
            MarkAsSafeFix.$$$reportNull$$$0(36);
        }
        if (taintValueFactory == null) {
            MarkAsSafeFix.$$$reportNull$$$0(37);
        }
        if (notProcessed == null) {
            MarkAsSafeFix.$$$reportNull$$$0(38);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        String annotation = taintValueFactory.getAnnotation();
        Set<PsiAnnotation.TargetType> targets = taintValueFactory.getAnnotationTarget(project, scope);
        if (!targets.isEmpty() && annotation != null) {
            for (PsiElement element : toAnnotate) {
                if (MarkAsSafeFix.annotateElement(project, annotation, targets, element, makeAction)) continue;
                notProcessed.add(element);
            }
        } else {
            notProcessed.addAll(toAnnotate);
        }
    }

    private static boolean annotateElement(@NotNull Project project, String annotation, Set<PsiAnnotation.TargetType> targets, PsiElement element, boolean makeAction) {
        JvmModifiersOwner jvmModifiersOwner;
        JvmField jvmField;
        if (project == null) {
            MarkAsSafeFix.$$$reportNull$$$0(39);
        }
        if (!element.isValid()) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiModifierListOwner listOwner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)element, PsiModifierListOwner.class);
        if (listOwner == null) {
            return false;
        }
        PsiAnnotation.TargetType[] location = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)listOwner.getModifierList());
        EnumSet<PsiAnnotation.TargetType> currentTypes = EnumSet.copyOf(targets);
        currentTypes.retainAll(Arrays.asList(location));
        if (currentTypes.isEmpty()) {
            return false;
        }
        if (currentTypes.contains(PsiAnnotation.TargetType.TYPE_USE)) {
            List actions = List.of();
            if (listOwner instanceof JvmParameter) {
                JvmParameter jvmParameter = (JvmParameter)listOwner;
                ChangeTypeRequest changeTypeRequest = MarkAsSafeFix.createTypeRequest(jvmParameter.getType(), annotation);
                actions = JvmElementActionFactories.createChangeTypeActions((JvmParameter)jvmParameter, (ChangeTypeRequest)changeTypeRequest);
            } else if (listOwner instanceof JvmField) {
                jvmField = (JvmField)listOwner;
                ChangeTypeRequest changeTypeRequest = MarkAsSafeFix.createTypeRequest(jvmField.getType(), annotation);
                actions = JvmElementActionFactories.createChangeTypeActions((JvmField)jvmField, (ChangeTypeRequest)changeTypeRequest);
            } else if (listOwner instanceof JvmMethod) {
                Object[] annotations;
                UMethod rereadUMethod;
                UMethod uMethod;
                JvmMethod jvmMethod = (JvmMethod)listOwner;
                UElement uElement = UastContextKt.toUElement((PsiElement)listOwner);
                if (uElement instanceof UMethod && (uMethod = (UMethod)uElement).getSourcePsi() != null && (uElement = UastContextKt.toUElement((PsiElement)uMethod.getSourcePsi())) instanceof UMethod && (rereadUMethod = (UMethod)uElement).getReturnType() != null && ContainerUtil.exists((Object[])(annotations = rereadUMethod.getReturnType().getAnnotations()), fromType -> fromType.hasQualifiedName(annotation))) {
                    return true;
                }
                JvmType type = jvmMethod.getReturnType();
                if (type == null) {
                    return false;
                }
                ChangeTypeRequest changeTypeRequest = MarkAsSafeFix.createTypeRequest(type, annotation);
                actions = JvmElementActionFactories.createChangeTypeActions((JvmMethod)jvmMethod, (ChangeTypeRequest)changeTypeRequest);
            }
            if (actions.size() == 1) {
                if (makeAction) {
                    ((IntentionAction)actions.get(0)).invoke(project, null, psiFile);
                }
                return true;
            }
        }
        UElement sourceUElement = UastContextKt.toUElement((PsiElement)element);
        if (element instanceof PsiMethod && sourceUElement != null && (jvmField = UastContextKt.toUElement((PsiElement)sourceUElement.getSourcePsi())) instanceof UField) {
            UField uField = (UField)jvmField;
            element = uField.getJavaPsi();
        }
        if ((jvmModifiersOwner = (JvmModifiersOwner)ObjectUtils.tryCast((Object)element, JvmModifiersOwner.class)) == null) {
            return false;
        }
        AnnotationRequest request = AnnotationRequestsKt.annotationRequest((String)annotation, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]);
        List actions = JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)jvmModifiersOwner, (AnnotationRequest)request);
        if (actions.size() == 1) {
            if (makeAction) {
                ((IntentionAction)actions.get(0)).invoke(project, null, psiFile);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static ChangeTypeRequest createTypeRequest(@NotNull JvmType jvmType, @NotNull String defaultUntaintedAnnotation) {
        if (jvmType == null) {
            MarkAsSafeFix.$$$reportNull$$$0(40);
        }
        if (defaultUntaintedAnnotation == null) {
            MarkAsSafeFix.$$$reportNull$$$0(41);
        }
        List annotations = (List)StreamEx.of((Object[])jvmType.getAnnotations()).map(annotation -> AnnotationRequestsKt.annotationRequest((JvmAnnotation)annotation)).append((Object)AnnotationRequestsKt.annotationRequest((String)defaultUntaintedAnnotation, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])).collect(Collectors.toList());
        ChangeTypeRequest changeTypeRequest = MethodRequestsKt.typeRequest(null, (List)annotations);
        if (changeTypeRequest == null) {
            MarkAsSafeFix.$$$reportNull$$$0(42);
        }
        return changeTypeRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 11, 12, 13, 14, 19, 24, 25, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePsi";
                break;
            }
            case 1: 
            case 17: 
            case 22: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taintValueFactory";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sourceToSink/MarkAsSafeFix";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 20: 
            case 26: 
            case 29: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 16: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAnnotate";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placedElement";
                break;
            }
            case 23: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notProcessed";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultUntaintedAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sourceToSink/MarkAsSafeFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 24: 
            case 25: 
            case 42: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToMark";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markAsSafe";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPlace";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRepresentText";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addToConfig";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePsi";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fileToAnnotate";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filesToAnnotate";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "annotateInCode";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "annotateElement";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTypeRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 11, 12, 13, 14, 19, 24, 25, 42 -> new IllegalStateException(string);
        };
    }
}

