/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.markdown;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.internal.renderer.NodeRendererMap;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.markdown.CoreMarkdownNodeRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import org.commonmark.renderer.markdown.MarkdownWriter;

public class MarkdownRenderer
implements Renderer {
    private final List<MarkdownNodeRendererFactory> nodeRendererFactories;

    private MarkdownRenderer(Builder builder) {
        this.nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new MarkdownNodeRendererFactory(){

            @Override
            public NodeRenderer create(MarkdownNodeRendererContext context) {
                return new CoreMarkdownNodeRenderer(context);
            }

            @Override
            public Set<Character> getSpecialCharacters() {
                return Collections.emptySet();
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable output) {
        RendererContext context = new RendererContext(new MarkdownWriter(output));
        context.render(node);
    }

    @Override
    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    private class RendererContext
    implements MarkdownNodeRendererContext {
        private final MarkdownWriter writer;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();
        private final Set<Character> additionalTextEscapes;

        private RendererContext(MarkdownWriter writer) {
            this.writer = writer;
            HashSet<Character> escapes = new HashSet<Character>();
            for (MarkdownNodeRendererFactory factory : MarkdownRenderer.this.nodeRendererFactories) {
                escapes.addAll(factory.getSpecialCharacters());
            }
            this.additionalTextEscapes = Collections.unmodifiableSet(escapes);
            for (int i = MarkdownRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                MarkdownNodeRendererFactory nodeRendererFactory = MarkdownRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public MarkdownWriter getWriter() {
            return this.writer;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        @Override
        public Set<Character> getSpecialCharacters() {
            return this.additionalTextEscapes;
        }
    }

    public static interface MarkdownRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private final List<MarkdownNodeRendererFactory> nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>();

        public MarkdownRenderer build() {
            return new MarkdownRenderer(this);
        }

        public Builder nodeRendererFactory(MarkdownNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof MarkdownRendererExtension)) continue;
                MarkdownRendererExtension markdownRendererExtension = (MarkdownRendererExtension)extension;
                markdownRendererExtension.extend(this);
            }
            return this;
        }
    }
}

