/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.filter;

import com.google.targetsdkversionassistant.filter.ElementLocationProvider;
import com.google.targetsdkversionassistant.filter.FilterResultElement;
import com.google.targetsdkversionassistant.filter.Location;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.google.targetsdkversionassistant.filter.PsiElementLocationProvider;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"relativeName", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "toLoc", "Lcom/google/targetsdkversionassistant/filter/Location;", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "toLocation", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "result", "", "targetsdkversion-upgrade-assistant"})
public final class LocationProviderKt {
    @NotNull
    public static final String relativeName(@NotNull VirtualFile $this$relativeName, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$relativeName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ScratchUtil.isScratch((VirtualFile)$this$relativeName) || $this$relativeName instanceof LightVirtualFile) {
            String string = $this$relativeName.getPresentableName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        } else {
            Path path = $this$relativeName.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            Path path2 = Path.of(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            object = PathsKt.relativeToOrNull((Path)path, (Path)path2);
            if (object == null || (object = object.toString()) == null) {
                String string2 = $this$relativeName.getPresentableName();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
            }
        }
        return object;
    }

    @NotNull
    public static final Location toLoc(@NotNull OpenFileDescriptor $this$toLoc) {
        Intrinsics.checkNotNullParameter((Object)$this$toLoc, (String)"<this>");
        VirtualFile virtualFile = $this$toLoc.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        Project project = $this$toLoc.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String fp = LocationProviderKt.relativeName(virtualFile, project);
        RangeMarker rm = $this$toLoc.getRangeMarker();
        int l = rm.getDocument().getLineNumber(rm.getStartOffset());
        int c = rm.getStartOffset() - rm.getDocument().getLineStartOffset(l);
        return new Location(fp, l, c);
    }

    @NotNull
    public static final LocationProvider toLocation(@NotNull Object result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return (LocationProvider)ActionsKt.runReadAction(() -> LocationProviderKt.toLocation$lambda$0(result));
    }

    private static final LocationProvider toLocation$lambda$0(Object $result) {
        LocationProvider locationProvider;
        Object object = $result;
        if (object instanceof PsiElement) {
            locationProvider = new PsiElementLocationProvider((PsiElement)$result);
        } else if (object instanceof Element) {
            locationProvider = new ElementLocationProvider((Element)$result);
        } else if (object instanceof FilterResultElement) {
            locationProvider = ((FilterResultElement)$result).getLocationProvider();
        } else {
            throw new IllegalStateException(("No source location for " + $result.getClass()).toString());
        }
        return locationProvider;
    }
}

