/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.Api29Kt;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api30;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api30 {
    @NotNull
    public static final Api30 INSTANCE = new Api30();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 10 / API level 29", "Android 11 / API level 30");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 10 (API level 29) to Android 11 (API level 30).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    For the complete list of changes introduced in Android 11 (API level 30), see the\n    " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Behavior Changes", "https://developer.android.com/about/versions/11/behavior-changes-11") + " page.\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api30::steps$lambda$11));

    private Api30() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$0(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Apps can no longer opt out of\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("scoped storage", "https://developer.android.com/training/data-storage#scoped-storage") + ". With scoped storage, apps cannot access " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("other") + " apps' app-specific\n          directories within external storage.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          " + Api29Kt.getScopedStorage() + "\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$1(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          When an app\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("isn\u2019t used", "https://developer.android.com/topic/performance/app-hibernation#app-usage") + " for a few months,\n          the system auto-resets the app\u2019s sensitive runtime permissions.\n          This action has the same effect as if the user viewed a permission\n          in system settings and changed your app's access level to " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Deny") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app follows best practices for\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("requesting permissions at runtime", "https://developer.android.com/training/permissions/requesting") + ", you shouldn't need to make any changes to your app.\n          That's because, as the user interacts with features in your app,\n          you should verify that the features have the permissions that they need.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app primarily works in the background without user interactions,\n          you might consider\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("requesting that the user disable app hibernation", "https://developer.android.com/topic/performance/app-hibernation#request-user-disable-hibernation") + ".\n          To check whether the user has already disabled hibernation for your app,\n          use the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getUnusedAppRestrictionsStatus()", "https://developer.android.com/reference/androidx/core/content/PackageManagerCompat#getUnusedAppRestrictionsStatus(android.content.Context)") + " API.\n          The following API code example shows how to check whether hibernation is enabled\n          for your app, and the correct way to ask users to disable hibernation for your app.\n        ")));
        $this$raw.kotlin("val future: ListenableFuture<Int> =\n    PackageManagerCompat.getUnusedAppRestrictionsStatus(context)\nfuture.addListener({ onResult(future.get()) }, ContextCompat.getMainExecutor(context))\n\nfun onResult(appRestrictionsStatus: Int) {\n  when (appRestrictionsStatus) {\n    // Couldn't fetch status. Check logs for details.\n    ERROR -> { }\n\n    // Restrictions don't apply to your app on this device.\n    FEATURE_NOT_AVAILABLE -> { }\n\n    // The user has disabled restrictions for your app.\n    DISABLED -> { }\n\n    // If the user doesn't start your app for a few months, the system will\n    // place restrictions on it. See the API_* constants for details.\n    API_30_BACKPORT, API_30, API_31 -> handleRestrictions(appRestrictionsStatus)\n  }\n}\n\nfun handleRestrictions(appRestrictionsStatus: Int) {\n  // If your app works primarily in the background, you can ask the user\n  // to disable these restrictions. Check if you have already asked the\n  // user to disable these restrictions. If not, you can show a message to\n  // the user explaining why permission auto-reset or app hibernation should be\n  // disabled. Then, redirect the user to the page in system settings where they\n  // can disable the feature.\n  val intent = IntentCompat.createManageUnusedAppRestrictionsIntent(context, packageName)\n\n  // You must use startActivityForResult(), not startActivity(), even if\n  // you don't use the result code returned in onActivityResult().\n  startActivityForResult(intent, REQUEST_CODE)\n}");
        $this$raw.text(StringsKt.trimIndent((String)("\n          For more information about this change, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("App hibernation", "https://developer.android.com/topic/performance/app-hibernation") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$2(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Location permissions must be performed " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("incrementally") + ": that is,\n          you must ask for foreground location access before background location access.\n          If you request a foreground location permission and background location permission at the\n          same time, the system ignores the request and doesn\u2019t grant your app either permission.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you\u2019re requesting both foreground permissions and background permissions in your app,\n          you should check that you\u2019re requesting these permissions incrementally.\n          In the app\u2019s manifest, there will be an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:foregroundServiceType") + "\n          type of " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("location") + " if you\u2019re requesting foreground permissions,\n          and an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:name") + " of " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android.permission.ACCESS_BACKGROUND_LOCATION") + "\n          if you\u2019re requesting background permissions.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The process for performing incremental requests is as follows:\n          " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              At first, your app should guide users to the features\n              that require foreground location access.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              It's recommended that you disable user access to features that require\n              background location access until your app has foreground location access.\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              At a later time, when the user explores functionality that requires background\n              location access, you can\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("request background location", "https://developer.android.com/training/location/permissions#request-background-location") + " access.\n            "))) + "\n          "))) + "\n          For more information about this change, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Request only foreground location initially", "https://developer.android.com/training/location/permissions#request-only-foreground") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$3(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Users must enable background location on a settings page,\n          and not through a system permissions dialog.\n          To help users navigate to this settings page,\n          make sure that you\u2019re following\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("best practices for requesting background location permission", "https://developer.android.com/training/location/permissions#background-dialog-target-android-11") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$4(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          The system makes\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("some apps visible to your app automatically", "https://developer.android.com/training/package-visibility/automatic") + ", and filters out other apps by default.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app needs to interact with apps other than the ones that are automatically visible,\n          add the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("queries")), "https://developer.android.com/guide/topics/manifest/queries-element") + " element in your app's manifest file.\n          Within the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("queries")) + " element, specify the other apps\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("by package name", "https://developer.android.com/training/package-visibility/declaring#package-name") + ",\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("intent signature", "https://developer.android.com/training/package-visibility/declaring#intent-signature") + ", or\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("provider authority", "https://developer.android.com/training/package-visibility/declaring#provider-authority") + ". If you use\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("text-to-speech", "https://developer.android.com/about/versions/11/behavior-changes-11#tts-engines") + " or\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("speech recognition", "https://developer.android.com/about/versions/11/behavior-changes-11#speech-recognition") + " services, add queries elements for services to the manifest file.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information about this change, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Fulfilling common use cases while having limited package visibility", "https://developer.android.com/training/package-visibility/use-cases") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$5(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps can't be installed if they contain a compressed " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resources.arsc") + "\n          file or if this file is not aligned on a 4-byte boundary.\n          This file can't be memory-mapped by the system if either of these conditions is present.\n          Resources tables that can't be memory-mapped must be read into a buffer in RAM,\n          resulting in unnecessary memory pressure on the system and\n          greatly-increased RAM usage on the device.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you\u2019re using a compressed " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resources.arsc") + " file,\n          try alternative strategies instead, such as\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("shrinking app resources", "https://developer.android.com/studio/build/shrink-code#shrink-resources") + " or other methods to\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("shrink, obfuscate, and optimize your app", "https://developer.android.com/studio/build/shrink-code") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information about this change, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Compressed resource files", "https://developer.android.com/about/versions/11/behavior-changes-11#compressed-resource-file") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$6(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps must be signed using\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("APK Signature Scheme v2", "https://source.android.com/security/apksigning/v2") + " or higher.\n          Users can't install or update apps that are only signed with APK Signature Scheme v1\n          on devices that run Android 11.\n          For backward compatibility reasons,\n          developers should also continue to sign with APK Signature Scheme v1.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          To verify that your app is being signed with APK Signature Scheme v2 or higher,\n          you can use either\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android Studio", "https://developer.android.com/studio/publish/app-signing#sign_release") + " or the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("apksigner"), "https://developer.android.com/studio/command-line/apksigner") + " tool on the command line.\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8$lambda$7(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps are not recommended to use non-SDK interfaces,\n          because some non-SDK interfaces are blocked in Android 11.\n          For a comprehensive list of blocked non-SDK interfaces, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Non-SDK interfaces that are now blocked in Android 11", "https://developer.android.com/about/versions/11/non-sdk-11#new-blocked") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$8(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.filtered("Scoped storage", "scopedStorage", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$0));
        $this$par.raw("Auto-reset permissions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$1));
        $this$par.filtered("Incremental location requests", "incrementalLocationRequest", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$2));
        $this$par.filtered("Background location access", "backgroundLocationAccess", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$3));
        $this$par.raw("Package visibility", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$4));
        $this$par.raw("No compressed resource.arsc files", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$5));
        $this$par.raw("APK Signature Scheme v2", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$6));
        $this$par.raw("Non-SDK interface restriction", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$8$lambda$7));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$9(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Make sure to review the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", "https://developer.android.com/about/versions/11/behavior-changes-11") + ".\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11$lambda$10(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n        Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 30.\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api30::steps$lambda$11$lambda$8));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$9));
        $this$seq.filtered("Update the SDK version", "targetSdkVersion30", (Function1<? super ElementListBuilder, Unit>)((Function1)Api30::steps$lambda$11$lambda$10));
        return Unit.INSTANCE;
    }
}

