/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public int handle;
    static final byte[] APPSTARTING_SRC;
    static final byte[] APPSTARTING_MASK;

    static {
        byte[] byArray = new byte[128];
        byArray[8] = 4;
        byArray[12] = 12;
        byArray[16] = 28;
        byArray[20] = 60;
        byArray[24] = 124;
        byArray[28] = -4;
        byArray[32] = -4;
        byArray[33] = 1;
        byArray[36] = -4;
        byArray[37] = 59;
        byArray[40] = 124;
        byArray[41] = 56;
        byArray[44] = 108;
        byArray[45] = 84;
        byArray[48] = -60;
        byArray[49] = -36;
        byArray[52] = -64;
        byArray[53] = 68;
        byArray[56] = -128;
        byArray[57] = 57;
        byArray[60] = -128;
        byArray[61] = 57;
        APPSTARTING_SRC = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[4] = 6;
        byArray2[8] = 14;
        byArray2[12] = 30;
        byArray2[16] = 62;
        byArray2[20] = 126;
        byArray2[24] = -2;
        byArray2[28] = -2;
        byArray2[29] = 1;
        byArray2[32] = -2;
        byArray2[33] = 59;
        byArray2[36] = -2;
        byArray2[37] = 127;
        byArray2[40] = -2;
        byArray2[41] = 127;
        byArray2[44] = -2;
        byArray2[45] = -2;
        byArray2[48] = -18;
        byArray2[49] = -1;
        byArray2[50] = 1;
        byArray2[52] = -28;
        byArray2[53] = -1;
        byArray2[56] = -64;
        byArray2[57] = 127;
        byArray2[60] = -64;
        byArray2[61] = 127;
        byArray2[64] = -128;
        byArray2[65] = 57;
        APPSTARTING_MASK = byArray2;
    }

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n) {
        super(device);
        int n2 = 0;
        switch (n) {
            case 3: {
                break;
            }
            case 0: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 150;
                break;
            }
            case 2: {
                n2 = 30;
                break;
            }
            case 21: {
                n2 = 60;
                break;
            }
            case 4: {
                n2 = 92;
                break;
            }
            case 5: {
                n2 = 52;
                break;
            }
            case 6: {
                n2 = 120;
                break;
            }
            case 7: {
                n2 = 42;
                break;
            }
            case 8: {
                n2 = 120;
                break;
            }
            case 9: {
                n2 = 108;
                break;
            }
            case 10: {
                n2 = 138;
                break;
            }
            case 11: {
                n2 = 16;
                break;
            }
            case 12: {
                n2 = 96;
                break;
            }
            case 13: {
                n2 = 70;
                break;
            }
            case 14: {
                n2 = 136;
                break;
            }
            case 15: {
                n2 = 14;
                break;
            }
            case 16: {
                n2 = 12;
                break;
            }
            case 17: {
                n2 = 134;
                break;
            }
            case 18: {
                n2 = 114;
                break;
            }
            case 19: {
                n2 = 152;
                break;
            }
            case 20: {
                n2 = 0;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = n2 == 0 && n == 3 ? this.createCursor(APPSTARTING_SRC, APPSTARTING_MASK, 32, 32, 2, 2, true) : OS.gdk_cursor_new(n2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        super(device);
        byte by;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        imageData = ImageData.convertMask(imageData);
        imageData2 = ImageData.convertMask(imageData2);
        byte[] byArray = new byte[imageData.data.length];
        byte[] byArray2 = new byte[imageData2.data.length];
        byte[] byArray3 = imageData.data;
        int n3 = 0;
        while (n3 < byArray3.length) {
            by = byArray3[n3];
            byArray[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray[n3] = ~byArray[n3];
            ++n3;
        }
        byArray = ImageData.convertPad(byArray, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
        byArray3 = imageData2.data;
        n3 = 0;
        while (n3 < byArray3.length) {
            by = byArray3[n3];
            byArray2[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray2[n3] = ~byArray2[n3];
            ++n3;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        this.handle = this.createCursor(byArray2, byArray, imageData.width, imageData.height, n, n2, true);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData object, int n, int n2) {
        super(device);
        if (object == null) {
            SWT.error(4);
        }
        if (n >= ((ImageData)object).width || n < 0 || n2 >= ((ImageData)object).height || n2 < 0) {
            SWT.error(5);
        }
        int n3 = 0;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && OS.gdk_display_supports_cursor_color(n3 = OS.gdk_display_get_default())) {
            int n4 = ((ImageData)object).width;
            int n5 = ((ImageData)object).height;
            PaletteData paletteData = ((ImageData)object).palette;
            int n6 = OS.gdk_pixbuf_new(0, true, 8, n4, n5);
            if (n6 == 0) {
                SWT.error(2);
            }
            int n7 = OS.gdk_pixbuf_get_rowstride(n6);
            int n8 = OS.gdk_pixbuf_get_pixels(n6);
            byte[] byArray = ((ImageData)object).data;
            if (!paletteData.isDirect || ((ImageData)object).depth != 24 || n7 != ((ImageData)object).bytesPerLine || paletteData.redMask != -16777216 || paletteData.greenMask != 0xFF0000 || paletteData.blueMask != 65280) {
                int n9;
                int n10;
                Object object2;
                byArray = new byte[((ImageData)object).width * ((ImageData)object).height * 4];
                if (paletteData.isDirect) {
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, -16777216, 0xFF0000, 65280, false, false);
                } else {
                    object2 = paletteData.getRGBs();
                    n10 = ((RGB[])object2).length;
                    byte[] byArray2 = new byte[n10];
                    byte[] byArray3 = new byte[n10];
                    byte[] byArray4 = new byte[n10];
                    n9 = 0;
                    while (n9 < ((RGB[])object2).length) {
                        RGB rGB = object2[n9];
                        if (rGB != null) {
                            byArray2[n9] = (byte)rGB.red;
                            byArray3[n9] = (byte)rGB.green;
                            byArray4[n9] = (byte)rGB.blue;
                        }
                        ++n9;
                    }
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, -16777216, 0xFF0000, 65280, false, false);
                }
                if (((ImageData)object).maskData != null || ((ImageData)object).transparentPixel != -1) {
                    object2 = ((ImageData)object).getTransparencyMask();
                    byte[] byArray5 = object2.data;
                    int n11 = object2.bytesPerLine;
                    int n12 = 3;
                    int n13 = 0;
                    n9 = 0;
                    while (n9 < ((ImageData)object).height) {
                        int n14 = 0;
                        while (n14 < ((ImageData)object).width) {
                            byArray[n12] = (byArray5[n13 + (n14 >> 3)] & 1 << 7 - (n14 & 7)) != 0 ? -1 : 0;
                            n12 += 4;
                            ++n14;
                        }
                        n13 += n11;
                        ++n9;
                    }
                } else if (((ImageData)object).alpha != -1) {
                    byte by = (byte)((ImageData)object).alpha;
                    n10 = 3;
                    while (n10 < byArray.length) {
                        byArray[n10] = by;
                        n10 += 4;
                    }
                } else if (((ImageData)object).alphaData != null) {
                    object2 = ((ImageData)object).alphaData;
                    n10 = 3;
                    while (n10 < byArray.length) {
                        byArray[n10] = (byte)object2[n10 / 4];
                        n10 += 4;
                    }
                }
            }
            OS.memmove(n8, byArray, n7 * n5);
            this.handle = OS.gdk_cursor_new_from_pixbuf(n3, n6, n, n2);
            OS.g_object_unref(n6);
        } else {
            byte[] byArray;
            byte[] byArray6;
            Object object3;
            ImageData imageData = ((ImageData)object).getTransparencyMask();
            if (((ImageData)object).depth > 1) {
                object3 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
                byte[] byArray7 = new byte[2];
                byArray7[1] = -1;
                byArray6 = byArray7;
                byArray = byArray6;
                byte[] byArray8 = byArray6;
                PaletteData paletteData = ((ImageData)object).palette;
                if (paletteData.isDirect) {
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object3).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, byArray6, byArray, byArray8, false, false);
                } else {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n15 = rGBArray.length;
                    byte[] byArray9 = new byte[n15];
                    byte[] byArray10 = new byte[n15];
                    byte[] byArray11 = new byte[n15];
                    int n16 = 0;
                    while (n16 < rGBArray.length) {
                        RGB rGB = rGBArray[n16];
                        if (rGB != null) {
                            byArray9[n16] = (byte)rGB.red;
                            byArray10[n16] = (byte)rGB.green;
                            byArray11[n16] = (byte)rGB.blue;
                        }
                        ++n16;
                    }
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray9, byArray10, byArray11, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object3).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, byArray6, byArray, byArray8, false, false);
                }
                object = object3;
            }
            object3 = new byte[((ImageData)object).data.length];
            byArray6 = new byte[imageData.data.length];
            byArray = ((ImageData)object).data;
            int n17 = 0;
            while (n17 < byArray.length) {
                byte by = byArray[n17];
                object3[n17] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
                ++n17;
            }
            object3 = ImageData.convertPad((byte[])object3, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 1);
            byArray = imageData.data;
            n17 = 0;
            while (n17 < byArray.length) {
                byte by = byArray[n17];
                byArray6[n17] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
                ++n17;
            }
            byArray6 = ImageData.convertPad(byArray6, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
            this.handle = this.createCursor((byte[])object3, byArray6, ((ImageData)object).width, ((ImageData)object).height, n, n2, false);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    int createCursor(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = OS.gdk_bitmap_create_from_data(0, byArray, n, n2);
        int n6 = OS.gdk_bitmap_create_from_data(0, byArray2, n, n2);
        int n7 = 0;
        if (n5 != 0 && n6 != 0) {
            GdkColor gdkColor = new GdkColor();
            if (!bl) {
                gdkColor.blue = (short)-1;
                gdkColor.green = (short)-1;
                gdkColor.red = (short)-1;
            }
            GdkColor gdkColor2 = new GdkColor();
            if (bl) {
                gdkColor2.blue = (short)-1;
                gdkColor2.green = (short)-1;
                gdkColor2.red = (short)-1;
            }
            n7 = OS.gdk_cursor_new_from_pixmap(n5, n6, gdkColor, gdkColor2, n3, n4);
        }
        if (n5 != 0) {
            OS.g_object_unref(n5);
        }
        if (n6 != 0) {
            OS.g_object_unref(n6);
        }
        return n7;
    }

    void destroy() {
        OS.gdk_cursor_unref(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public static Cursor gtk_new(Device device, int n) {
        Cursor cursor = new Cursor(device);
        cursor.handle = n;
        return cursor;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

