/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.event;

import com.android.utils.Pair;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ElementAction {
    private boolean canScrollTo;
    private final List<ElementDescriptor> elementDescriptors = Lists.newLinkedList();

    public ElementDescriptor getElementDescriptor(int index) {
        return this.elementDescriptors.get(index);
    }

    public List<ElementDescriptor> getElementDescriptorList() {
        return ImmutableList.copyOf(this.elementDescriptors);
    }

    public int getElementDescriptorsCount() {
        return this.elementDescriptors.size();
    }

    public void addElementDescriptor(ElementDescriptor descriptor) {
        this.elementDescriptors.add(descriptor);
    }

    public boolean canScrollTo() {
        return this.canScrollTo;
    }

    public void setCanScrollTo(boolean canScrollTo) {
        this.canScrollTo = canScrollTo;
    }

    public String getRendererString() {
        String displayText = this.getDisplayText();
        if (!displayText.isEmpty()) {
            return this.getRendererString(displayText);
        }
        String displayContentDescription = this.getDisplayContentDescription();
        if (!displayContentDescription.isEmpty()) {
            return this.getRendererString(displayContentDescription);
        }
        String displayResourceId = this.getDisplayResourceId();
        if (!displayResourceId.isEmpty()) {
            return this.getRendererString(displayResourceId);
        }
        int childPosition = this.getElementRecyclerViewChildPosition();
        if (childPosition == -1) {
            childPosition = this.getElementAdapterViewChildPosition();
        }
        if (childPosition == -1) {
            childPosition = this.getElementGroupViewChildPosition();
        }
        if (childPosition != -1) {
            return this.getRendererString(this.getIdAttributeDisplayPresentation("child position", String.valueOf(childPosition)));
        }
        String className = this.getElementClassName();
        if (!Strings.isNullOrEmpty((String)className)) {
            return StringHelper.getClassName(className);
        }
        return "unidentified element";
    }

    protected String getDisplayResourceId() {
        String resourceId = this.getElementResourceId();
        if (!resourceId.isEmpty()) {
            Pair<String, String> parsedId = StringHelper.parseId(resourceId);
            return this.getIdAttributeDisplayPresentation("ID", parsedId == null ? resourceId : (String)parsedId.getSecond());
        }
        return "";
    }

    protected String getDisplayText() {
        String text = this.getElementText();
        if (!text.isEmpty()) {
            return this.getIdAttributeDisplayPresentation("text", StringUtil.escapeStringCharacters((String)text));
        }
        return "";
    }

    protected String getDisplayContentDescription() {
        String contentDescription = this.getElementContentDescription();
        if (!contentDescription.isEmpty()) {
            return this.getIdAttributeDisplayPresentation("content description", contentDescription);
        }
        return "";
    }

    protected String getIdAttributeDisplayPresentation(String idAttributeKind, String idAttributeValue) {
        String idTextColor = !JBColor.isBright() ? "#eeeeee" : "#111111";
        return idAttributeKind + " <span style='color: " + idTextColor + "; font-weight: bold;'>" + idAttributeValue + "</span>";
    }

    @NotNull
    protected String getRendererString(String displayElementAttribute) {
        String elementClassName = this.getElementClassName();
        String displayElementType = Strings.isNullOrEmpty((String)elementClassName) ? "element" : StringHelper.getClassName(elementClassName);
        return displayElementType + " with " + displayElementAttribute;
    }

    public String getElementClassName() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getClassName();
        }
        return "";
    }

    public int getElementRecyclerViewChildPosition() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getRecyclerViewChildPosition();
        }
        return -1;
    }

    public int getElementAdapterViewChildPosition() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getAdapterViewChildPosition();
        }
        return -1;
    }

    public int getElementGroupViewChildPosition() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getGroupViewChildPosition();
        }
        return -1;
    }

    public String getElementResourceId() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getResourceId();
        }
        return "";
    }

    public String getElementText() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getText();
        }
        return "";
    }

    public String getElementContentDescription() {
        if (!this.elementDescriptors.isEmpty()) {
            return this.elementDescriptors.get(0).getContentDescription();
        }
        return "";
    }
}

