/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.run;

import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.activity.launch.DefaultActivityLaunch;
import com.android.tools.idea.run.activity.launch.LaunchOptionState;
import com.android.tools.idea.run.activity.launch.SpecificActivityLaunch;
import com.google.gct.testrecorder.run.TestRecorderRunConfigurationProxy;
import com.google.gct.testrecorder.util.EspressoSetupToken;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;

public class TestRecorderAndroidRunConfigurationProxy
implements TestRecorderRunConfigurationProxy {
    private final AndroidRunConfiguration myBaseConfiguration;

    public TestRecorderAndroidRunConfigurationProxy(AndroidRunConfiguration baseConfiguration) {
        this.myBaseConfiguration = baseConfiguration;
    }

    @Override
    public boolean isNativeProject() {
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)this.myBaseConfiguration.getProject());
        EspressoSetupToken token = EspressoSetupToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token != null) {
            return token.isNativeProject(projectSystem, this.getModule());
        }
        return false;
    }

    @Override
    public Module getModule() {
        return ((AndroidRunConfigurationModule)this.myBaseConfiguration.getConfigurationModule()).getModule();
    }

    @Override
    public boolean isLaunchActivitySupported() {
        LaunchOptionState activityLaunchOptionState = this.myBaseConfiguration.getLaunchOptionState(this.myBaseConfiguration.MODE);
        return activityLaunchOptionState instanceof DefaultActivityLaunch.State || activityLaunchOptionState instanceof SpecificActivityLaunch.State;
    }
}

