/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.UiNode;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.event.TestRecorderEventListener;
import com.google.gct.testrecorder.roboscript.ContextualRoboscript;
import com.google.gct.testrecorder.roboscript.RoboscriptConfiguration;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.ui.ScreenshotPanel;
import com.google.gct.testrecorder.ui.TestClassNameInputDialog;
import com.google.gct.testrecorder.ui.TestRecorderAction;
import com.google.gct.testrecorder.ui.TestRecorderListRenderer;
import com.google.gct.testrecorder.ui.TestRecorderScreenshotTask;
import com.google.gct.testrecorder.util.ClassHelper;
import com.google.gct.testrecorder.util.GenerateTestHelperKt;
import com.google.gct.testrecorder.util.ImageHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.google.gct.testrecorder.util.UiAutomatorNodeHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.request.BreakpointRequest;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordingDialog
extends DialogWrapper
implements TestRecorderEventListener {
    private static final String TEST_RECORDING_DIALOG_TITLE = "Record Your Test";
    private static final String SCRIPT_RECORDING_DIALOG_TITLE = "Record Your Robo Script";
    private static final String DEFAULT_MESSAGE = "Select an element from screenshot";
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final IDevice myDevice;
    private final String myPackageName;
    private final String myLaunchedActivityName;
    private final boolean myIsRecordingTest;
    private String myTestClassName;
    private PsiDirectory myTestClassParent;
    private Module myTestClassModule;
    private String mySelectedLanguage;
    private DebuggerSession myDebuggerSession;
    private boolean myAssertionMode;
    private int myAssertionIndex;
    private LinkedHashMap<BasicTreeNode, Integer> myNodeIndentMap;
    private DefaultComboBoxModel myElementComboBoxModel;
    private final DefaultListModel<ElementAction> myActionListModel;
    private boolean myIsRecording = true;
    private boolean myWasEverPaused = false;
    private JPanel myRootPanel;
    private ScreenshotPanel myScreenshotPanel;
    private JPanel myActionListPanel;
    private JBScrollPane myScrollPane;
    private JBList<ElementAction> myActionList;
    private JPanel myAssertionPanel;
    private JPanel myButtonsPanel;
    private JButton myAddAssertionButton;
    private JButton myTakeScreenshotButton;
    private JPanel myEditAssertionPanel;
    private JComboBox myAssertionElementComboBox;
    private JComboBox myAssertionRuleComboBox;
    private JPanel myTextFieldWrapper;
    private JTextField myAssertionTextField;
    private JButton mySaveAssertionButton;
    private JButton myCancelButton;
    private JButton mySaveAssertionAndAddAnotherButton;
    private JPanel myRecordingPanel;
    private JButton myRecordPauseButton;
    private CountDownLatch myCountDownLatch;

    public RecordingDialog(AndroidFacet facet, IDevice device, String packageName, String launchedActivityName, boolean isRecordingTest, CountDownLatch latch) {
        super(facet.getModule().getProject(), true, DialogWrapper.IdeModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myDevice = device;
        this.myPackageName = packageName;
        this.myLaunchedActivityName = launchedActivityName;
        this.myIsRecordingTest = isRecordingTest;
        this.myAssertionMode = false;
        this.myCountDownLatch = latch;
        this.init();
        this.setTitle(this.myIsRecordingTest ? TEST_RECORDING_DIALOG_TITLE : SCRIPT_RECORDING_DIALOG_TITLE);
        this.getRootPane().setDefaultButton(this.getButton(this.getOKAction()));
        this.myTakeScreenshotButton.setVisible(false);
        this.myActionList.setEmptyText("No actions recorded yet.");
        this.myActionListModel = new DefaultListModel();
        this.myActionList.setModel(this.myActionListModel);
        this.myActionList.setCellRenderer((ListCellRenderer)new TestRecorderListRenderer());
        if (!this.myIsRecordingTest) {
            this.myAssertionPanel.setVisible(false);
            this.myRecordPauseButton.setVisible(false);
        } else {
            this.myRecordPauseButton.setVisible(TestRecorderSettings.getInstance().ENABLE_TEST_FRAGMENT_RECORDING);
        }
        this.myRecordPauseButton.setIcon(AllIcons.Actions.Pause);
        this.myRecordPauseButton.addActionListener(e -> {
            this.myWasEverPaused = true;
            this.myIsRecording = !this.myIsRecording;
            this.updateRecordPauseButton();
            this.toggleDebugging();
        });
        this.myAddAssertionButton.addActionListener(actionEvent -> new TestRecorderScreenshotTask(this.myProject, this.myDevice, this.myPackageName, (initialImage, model) -> {
            this.myAssertionMode = true;
            this.getRootPane().setDefaultButton(this.mySaveAssertionAndAddAnotherButton);
            BasicTreeNode root = model.getXmlRootNode();
            String applicationId = GenerateTestHelperKt.getApplicationId(this.myFacet, "");
            if (!applicationId.isEmpty() && !applicationId.equals(UiAutomatorNodeHelper.getAppPackageName(root))) {
                Messages.showMessageDialog((Component)this.myRootPanel, (String)"Out-of-app assertions are not supported and will break the generated Espresso test.", (String)"Warning: adding an out-of-app assertion", null);
            }
            BufferedImage preparedImage = ImageHelper.rotateImage(initialImage, UiAutomatorNodeHelper.getRotation(root));
            this.myScreenshotPanel.updateScreenShot(preparedImage, model);
            this.myNodeIndentMap = UiAutomatorNodeHelper.createElementLevelMap(root);
            this.myElementComboBoxModel = new DefaultComboBoxModel<Object>(this.myNodeIndentMap.keySet().toArray());
            this.myElementComboBoxModel.insertElementAt(DEFAULT_MESSAGE, 0);
            CardLayout cardLayout = (CardLayout)this.myAssertionPanel.getLayout();
            cardLayout.show(this.myAssertionPanel, "myEditAssertionPanel");
            this.setUpEmptyAssertionPanel();
            this.myAssertionIndex = this.myActionListModel.size();
            this.revealScreenshotPanel(preparedImage.getWidth(), preparedImage.getHeight());
        }).queue());
        this.myTakeScreenshotButton.addActionListener(actionEvent -> {});
        this.mySaveAssertionButton.addActionListener(actionEvent -> {
            this.exitAssertionMode(true);
            this.hideScreenshotPanel();
        });
        this.mySaveAssertionAndAddAnotherButton.addActionListener(actionEvent -> {
            this.myActionListModel.add(this.myAssertionIndex, this.buildAssertionForCurrentSelection());
            this.myActionList.ensureIndexIsVisible(this.myAssertionIndex);
            ++this.myAssertionIndex;
        });
        this.myCancelButton.addActionListener(actionEvent -> {
            this.exitAssertionMode(false);
            this.hideScreenshotPanel();
        });
        this.myAssertionElementComboBox.addItemListener(itemEvent -> {
            Object element = this.myAssertionElementComboBox.getSelectedItem();
            if (element instanceof BasicTreeNode) {
                BasicTreeNode node = (BasicTreeNode)element;
                this.myScreenshotPanel.setSelectedNodeAndRepaint(node);
                if (UiAutomatorNodeHelper.isTextView(node)) {
                    CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
                    cardLayout.show(this.myTextFieldWrapper, "myAssertionTextField");
                    this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
                    this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
                } else {
                    CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
                    cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
                    this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
                }
                this.mySaveAssertionButton.setEnabled(true);
                this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
                this.myAssertionTextField.setForeground((Color)JBColor.BLACK);
            } else {
                this.myScreenshotPanel.clearSelectionAndRepaint();
            }
        });
        this.myAssertionElementComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof BasicTreeNode) {
                    String resourceId;
                    BasicTreeNode node = (BasicTreeNode)value;
                    int indent = RecordingDialog.this.myNodeIndentMap.get(node);
                    String prefix = StringUtil.repeat((String)"  ", (int)indent);
                    if (index == -1) {
                        prefix = "";
                    }
                    String nodeString = (resourceId = UiAutomatorNodeHelper.getResourceId(node)).isEmpty() ? UiAutomatorNodeHelper.getClassName(node) : resourceId;
                    return super.getListCellRendererComponent((JList<?>)list, prefix + nodeString, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.myAssertionRuleComboBox.addItemListener(itemEvent -> {
            Object selectedItem = this.myAssertionRuleComboBox.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String rule = selectedItem.toString();
            CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
            if ("text is".equals(rule)) {
                cardLayout.show(this.myTextFieldWrapper, "myAssertionTextField");
            } else {
                cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
            }
        });
    }

    public void setDebuggerSession(DebuggerSession debuggerSession) {
        this.myDebuggerSession = debuggerSession;
        this.myIsRecording = this.myDebuggerSession != null;
        this.myRecordPauseButton.setEnabled(this.myIsRecording);
        this.updateRecordPauseButton();
    }

    public String getTestClassName() {
        return this.myTestClassName;
    }

    public PsiDirectory getTestClassParent() {
        return this.myTestClassParent;
    }

    public JPanel getRootPanel() {
        return this.myRootPanel;
    }

    public List<ElementAction> getAllModelActions() {
        return Collections.list(this.myActionListModel.elements());
    }

    public String getLaunchedActivityName() {
        return this.myLaunchedActivityName;
    }

    public Boolean getWasEverPaused() {
        return this.myWasEverPaused;
    }

    public String getSelectedLanguage() {
        return this.mySelectedLanguage;
    }

    private void updateRecordPauseButton() {
        if (this.myIsRecording) {
            this.myRecordPauseButton.setText("Pause");
            this.myRecordPauseButton.setIcon(AllIcons.Actions.Pause);
        } else {
            this.myRecordPauseButton.setText("Resume");
            this.myRecordPauseButton.setIcon(TestRecorderAction.TEST_RECORDER_ICON);
        }
    }

    private void toggleDebugging() {
        if (this.myDebuggerSession != null) {
            List<BreakpointRequest> requests = this.myDebuggerSession.getProcess().getRequestsManager().getVMRequestManager().breakpointRequests();
            for (BreakpointRequest request : requests) {
                request.setEnabled(this.myIsRecording);
            }
        }
    }

    public void doCancelAction() {
        if (this.myCountDownLatch.getCount() > 0L) {
            this.myCountDownLatch.countDown();
        }
        super.doCancelAction();
    }

    static String getJsonForActions(Project project, List<ElementAction> actions) {
        ArrayList<TestRecorderEvent> testRecorderEvents = new ArrayList<TestRecorderEvent>();
        for (ElementAction action : actions) {
            if (!(action instanceof TestRecorderEvent)) continue;
            testRecorderEvents.add((TestRecorderEvent)action);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ElementDescriptor.class, (Object)new ElementDescriptorSerializer(project));
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        RoboscriptConfiguration roboscriptConfiguration = new RoboscriptConfiguration(false, false);
        String roboscriptHeader = "\"roboscript\": " + gson.toJson((Object)roboscriptConfiguration) + "\n";
        ArrayList<ContextualRoboscript> contextualRoboscripts = new ArrayList<ContextualRoboscript>();
        contextualRoboscripts.add(new ContextualRoboscript(testRecorderEvents));
        return roboscriptHeader + gson.toJson(contextualRoboscripts);
    }

    @NotNull
    protected String getHelpId() {
        return this.myIsRecordingTest ? "https://developer.android.com/r/studio-ui/test-recorder.html" : "https://firebase.google.com/docs/test-lab/robo-ux-test#scripting";
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)this.getHelpId());
    }

    protected void doOKAction() {
        if (this.myIsRecordingTest) {
            TestClassNameInputDialog chooser = new TestClassNameInputDialog(this.myFacet.getModule(), this.myLaunchedActivityName);
            if (!chooser.showAndGet()) {
                return;
            }
            this.myTestClassName = chooser.getTestClassName();
            this.myTestClassParent = chooser.getTestClassParent();
            this.mySelectedLanguage = chooser.getSelectedLanguage();
            super.doOKAction();
            this.myCountDownLatch.countDown();
        } else {
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Robo Script", "Save Robo script to a file", new String[]{"json"});
            FileSaverDialogImpl fileSaverDialog = new FileSaverDialogImpl(descriptor, this.myProject);
            VirtualFileWrapper fileWrapper = fileSaverDialog.save((VirtualFile)null, StringHelper.getClassName(this.myLaunchedActivityName) + "_robo_script");
            if (fileWrapper != null) {
                try {
                    FileUtils.write((File)fileWrapper.getFile(), (CharSequence)RecordingDialog.getJsonForActions(this.myProject, this.getAllModelActions()));
                }
                catch (Exception ex) {
                    String message = StringUtil.isEmpty((String)ex.getMessage()) ? "Unknown error" : ex.getMessage();
                    Messages.showMessageDialog((Component)this.myRootPanel, (String)message, (String)"Could not save Robo script to a file", null);
                }
            }
            if (fileSaverDialog.isOK()) {
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_SAVE_ROBO_SCRIPT), (Project)this.myProject));
                super.doOKAction();
                this.myCountDownLatch.countDown();
            }
        }
    }

    private void exitAssertionMode(boolean shouldAddAssertion) {
        this.myAssertionMode = false;
        this.getRootPane().setDefaultButton(this.getButton(this.getOKAction()));
        CardLayout cardLayout = (CardLayout)this.myAssertionPanel.getLayout();
        cardLayout.show(this.myAssertionPanel, "myButtonsPanel");
        if (shouldAddAssertion) {
            this.myActionListModel.add(this.myAssertionIndex, this.buildAssertionForCurrentSelection());
            this.myActionList.ensureIndexIsVisible(this.myAssertionIndex);
        } else {
            this.myActionList.ensureIndexIsVisible(this.myActionListModel.size() - 1);
        }
    }

    private void revealScreenshotPanel(int imageWidth, int imageHeight) {
        this.myRecordingPanel.setMinimumSize(new Dimension(this.myRecordingPanel.getWidth(), this.myRecordingPanel.getHeight()));
        this.myScreenshotPanel.setVisible(true);
        int screenshotPanelTotalHeight = this.myRootPanel.getHeight();
        int scaledImageWidth = imageHeight <= screenshotPanelTotalHeight ? imageWidth : (int)((double)(imageWidth * screenshotPanelTotalHeight) / (double)imageHeight);
        int screenshotPanelTotalWidth = scaledImageWidth > screenshotPanelTotalHeight ? screenshotPanelTotalHeight : scaledImageWidth;
        this.myScreenshotPanel.setMinimumSize(new Dimension(screenshotPanelTotalWidth, screenshotPanelTotalHeight));
        this.myScreenshotPanel.clearSelectionAndRepaint();
        this.getWindow().pack();
        this.myAssertionElementComboBox.requestFocusInWindow();
    }

    private void hideScreenshotPanel() {
        int screenshotPanelInitialWidth = this.myScreenshotPanel.getWidth();
        int marginWidth = ((FlowLayout)this.myScreenshotPanel.getLayout()).getHgap() * 2;
        int windowInitialWidth = this.getWindow().getWidth();
        this.myScreenshotPanel.setVisible(false);
        this.myScreenshotPanel.setMinimumSize(new Dimension(0, 0));
        this.getWindow().setMinimumSize(new Dimension(windowInitialWidth - screenshotPanelInitialWidth - marginWidth, this.getWindow().getHeight()));
        this.myScreenshotPanel.clearSelectionAndRepaint();
        this.getWindow().pack();
    }

    private void createUIComponents() {
        this.myScreenshotPanel = new ScreenshotPanel(this);
        this.myScreenshotPanel.setPreferredSize(new Dimension(0, 0));
        this.myScreenshotPanel.setVisible(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBDimension initialSize = JBUI.size((int)450, (int)600);
        this.myRootPanel.setPreferredSize((Dimension)initialSize);
        this.myRecordingPanel.setMinimumSize((Dimension)initialSize);
        return this.myRootPanel;
    }

    private TestRecorderAssertion buildAssertionForCurrentSelection() {
        UiNode node = (UiNode)this.myAssertionElementComboBox.getSelectedItem();
        String rule = "exists";
        Object assertionRuleSelectedItem = this.myAssertionRuleComboBox.getSelectedItem();
        if (assertionRuleSelectedItem != null) {
            rule = assertionRuleSelectedItem.toString();
        }
        TestRecorderAssertion assertion = new TestRecorderAssertion(rule);
        this.addElementDescriptors(assertion, node);
        if ("text is".equals(rule)) {
            assertion.setText(this.myAssertionTextField.getText());
        }
        return assertion;
    }

    private void addElementDescriptors(TestRecorderAssertion assertion, UiNode node) {
        if (node == null || assertion.getElementDescriptorsCount() >= TestRecorderSettings.getInstance().ASSERTION_DEPTH) {
            return;
        }
        String className = UiAutomatorNodeHelper.getClassName((BasicTreeNode)node);
        String resourceId = UiAutomatorNodeHelper.getResourceId((BasicTreeNode)node);
        String text = UiAutomatorNodeHelper.getText((BasicTreeNode)node);
        String contentDescription = UiAutomatorNodeHelper.getContentDescription((BasicTreeNode)node);
        int viewGroupChildPosition = UiAutomatorNodeHelper.getViewGroupChildPosition((BasicTreeNode)node);
        if (!(className.isEmpty() && resourceId.isEmpty() && text.isEmpty() && contentDescription.isEmpty() && viewGroupChildPosition == -1)) {
            assertion.addElementDescriptor(new ElementDescriptor(className, -1, -1, viewGroupChildPosition, resourceId, contentDescription, text));
            if (node.getParent() instanceof UiNode) {
                this.addElementDescriptors(assertion, (UiNode)node.getParent());
            }
        }
    }

    protected void setUpEmptyAssertionPanel() {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedIndex(0);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel());
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
        this.mySaveAssertionButton.setEnabled(false);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(false);
    }

    protected void setUpAssertionPanel(BasicTreeNode node) {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedItem(node);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.mySaveAssertionButton.setEnabled(true);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        if (UiAutomatorNodeHelper.isTextView(node)) {
            cardLayout.show(this.myTextFieldWrapper, "myAssertionTextField");
            this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
        } else {
            cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
        }
    }

    public boolean isAssertionMode() {
        return this.myAssertionMode;
    }

    @Override
    public void onEvent(TestRecorderEvent event) {
        if (!TestRecorderEvent.SUPPORTED_EVENTS.contains(event.getEventType())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myActionListModel.isEmpty()) {
                this.myActionListModel.addElement(event);
            } else {
                ElementAction lastAction = this.myActionListModel.lastElement();
                if (lastAction instanceof TestRecorderEvent && ((TestRecorderEvent)lastAction).canMerge(event)) {
                    ((TestRecorderEvent)lastAction).merge(event);
                    this.myActionList.repaint();
                } else {
                    this.myActionListModel.addElement(event);
                }
            }
            this.myActionList.ensureIndexIsVisible(this.myActionList.getItemsCount() - 1);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JComboBox jComboBox2;
        JPanel jPanel2;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel3;
        JPanel jPanel4;
        JButton jButton6;
        JBList jBList;
        JBScrollPane jBScrollPane;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        this.myRecordingPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(596, 306), null));
        this.myActionListPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(539, 132), null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(238, 128), null));
        this.myActionList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myRecordPauseButton = jButton6 = new JButton();
        jButton6.setHideActionText(false);
        jButton6.setText("Pause");
        jPanel5.add((Component)jButton6, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(0, 40), null));
        this.myAssertionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 0, null, new Dimension(539, 150), null));
        this.myButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel3, "myButtonsPanel");
        ((CardLayout)jPanel4.getLayout()).show(jPanel4, "myButtonsPanel");
        this.myAddAssertionButton = jButton5 = new JButton();
        jButton5.setText("Add Assertion");
        jPanel3.add((Component)jButton5, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTakeScreenshotButton = jButton4 = new JButton();
        jButton4.setText("Take Screenshot");
        jPanel3.add((Component)jButton4, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 5, 1, 1, 3, 0, new Dimension(0, 5), new Dimension(0, 5), new Dimension(0, 5)));
        this.myEditAssertionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel2, "myEditAssertionPanel");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Edit assertion", 0, 0, null, null));
        this.myAssertionRuleComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 35), null));
        this.mySaveAssertionButton = jButton3 = new JButton();
        jButton3.setText("Save Assertion");
        jPanel9.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySaveAssertionAndAddAnotherButton = jButton2 = new JButton();
        jButton2.setText("Save and Add Another");
        jPanel9.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCancelButton = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel9.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTextFieldWrapper = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 24), null));
        this.myAssertionTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, "myAssertionTextField");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel10, "myPlaceHolder");
        this.myAssertionElementComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        ScreenshotPanel screenshotPanel = this.myScreenshotPanel;
        jPanel7.add((Component)screenshotPanel, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class ElementDescriptorSerializer
    implements JsonSerializer<ElementDescriptor> {
        private final Project myProject;

        public ElementDescriptorSerializer(Project project) {
            this.myProject = project;
        }

        public JsonElement serialize(ElementDescriptor elementDescriptor, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("className", ClassHelper.getInternalName(this.myProject, elementDescriptor.getClassName()));
            jsonObject.addProperty("recyclerViewChildPosition", (Number)elementDescriptor.getRecyclerViewChildPosition());
            jsonObject.addProperty("adapterViewChildPosition", (Number)elementDescriptor.getAdapterViewChildPosition());
            jsonObject.addProperty("groupViewChildPosition", (Number)elementDescriptor.getGroupViewChildPosition());
            jsonObject.addProperty("resourceId", elementDescriptor.getResourceId());
            jsonObject.addProperty("contentDescription", elementDescriptor.getContentDescription());
            jsonObject.addProperty("text", elementDescriptor.getText());
            return jsonObject;
        }
    }
}

