/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.CommonTestType;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gct.testrecorder.util.EspressoSetupToken;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class TestClassNameInputDialog
extends DialogWrapper {
    private static final String JAVA_LANGUAGE_NAME = "Java";
    private final Project myProject;
    private final String myLaunchedActivityName;
    private Module myTestClassModule;
    private PsiDirectory myTestClassParent;
    private PsiClass myTestClass;
    private String myClassName;
    private String mySelectedLanguage;
    private JPanel myRootPanel;
    private JTextArea myClassNameArea;
    private JLabel myErrorMessageLabel;
    private JComboBox<String> myClassLanguageComboBox;

    protected TestClassNameInputDialog(Module launchedModule, String launchedActivityName) {
        super(launchedModule.getProject(), true);
        this.$$$setupUI$$$();
        this.myProject = launchedModule.getProject();
        this.myLaunchedActivityName = launchedActivityName;
        this.myTestClassModule = launchedModule;
        this.init();
        this.setTitle("Specify a test class for your test");
        this.myClassLanguageComboBox.addItem(JAVA_LANGUAGE_NAME);
        this.myClassLanguageComboBox.addItem("Kotlin");
        this.prepareEnvironment();
        if (this.myClassLanguageComboBox.getSelectedIndex() < 1 && !this.hasKotlinPlugin()) {
            this.myClassLanguageComboBox.removeItemAt(1);
        }
        SwingUtilities.invokeLater(this::updateOKButton);
    }

    public String getTestClassName() {
        return this.myClassName;
    }

    public PsiDirectory getTestClassParent() {
        return this.myTestClassParent;
    }

    public String getSelectedLanguage() {
        return this.mySelectedLanguage;
    }

    private boolean hasKotlinPlugin() {
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)this.myProject);
        EspressoSetupToken token = EspressoSetupToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token != null) {
            return token.supportsKotlin(projectSystem, this.myTestClassModule);
        }
        return false;
    }

    private void prepareEnvironment() {
        VirtualFile testSourceDirectory = this.detectOrCreateTestSourceDirectoryAndDefaultOutputLanguage();
        if (testSourceDirectory == null) {
            throw new RuntimeException("Could not detect or create the test source directory!");
        }
        String[] activityNameFragments = this.myLaunchedActivityName.split("\\.");
        VirtualFile testFileParent = this.getOrCreateSubdirectory(testSourceDirectory, activityNameFragments, false);
        String activityTestNameBase = activityNameFragments[activityNameFragments.length - 1] + "Test";
        this.myTestClassParent = PsiManager.getInstance((Project)this.myProject).findDirectory(testFileParent);
        this.myClassName = activityTestNameBase;
        int counter = 2;
        while (this.doesClassExist()) {
            this.myClassName = activityTestNameBase + counter++;
        }
        this.myClassNameArea.setText(this.myClassName);
        this.myClassNameArea.setBorder(BorderFactory.createCompoundBorder(new JTextField().getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    private VirtualFile detectOrCreateTestSourceDirectoryAndDefaultOutputLanguage() {
        String launchedActivityPath = this.myLaunchedActivityName.replace('.', '/');
        VirtualFile launchedActivitySourceRoot = this.getContainingSourceRoot(TestClassNameInputDialog.appendJavaExtension(launchedActivityPath));
        if (launchedActivitySourceRoot == null && (launchedActivitySourceRoot = this.getContainingSourceRoot(TestClassNameInputDialog.appendKotlinExtension(launchedActivityPath))) != null) {
            this.myClassLanguageComboBox.setSelectedIndex(1);
        }
        if (launchedActivitySourceRoot == null) {
            throw new RuntimeException("Failed to obtain launched activity source root.");
        }
        List<VirtualFile> existingAndroidTestSourceRoots = this.getExistingAndroidTestSourceRoots();
        if (existingAndroidTestSourceRoots.isEmpty()) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_MISSING_INSTRUMENTATION_TEST_FOLDER), (Project)this.myProject));
            VirtualFile closestContentRoot = this.getClosestContentRoot(launchedActivitySourceRoot);
            List<String> androidTestSourceRoots = this.getAndroidTestSourceRoots();
            if (androidTestSourceRoots.isEmpty()) {
                VirtualFile contentRootParent = closestContentRoot.getParent();
                if (contentRootParent != null && contentRootParent.getName().equals("src")) {
                    return this.getOrCreateSubdirectory(contentRootParent, new String[]{"androidTest", "java"}, true);
                }
                return this.getOrCreateSubdirectory(closestContentRoot, new String[]{"src", "androidTest", "java"}, true);
            }
            Object closestAndroidTestSourcePath = androidTestSourceRoots.get(TestClassNameInputDialog.findClosestAndroidTestSourceRootIndex(launchedActivitySourceRoot, androidTestSourceRoots));
            closestAndroidTestSourcePath = TestClassNameInputDialog.getFilePathPrefix(launchedActivitySourceRoot.getCanonicalPath(), (String)closestAndroidTestSourcePath) + (String)closestAndroidTestSourcePath;
            VirtualFile parentDirectory = closestContentRoot;
            if (!(closestContentRoot.getCanonicalPath() != null && ((String)closestAndroidTestSourcePath).startsWith(closestContentRoot.getCanonicalPath()) || (parentDirectory = this.findContainingDirectory(launchedActivitySourceRoot, (String)closestAndroidTestSourcePath)) != null)) {
                throw new RuntimeException("Failed to find a parent directory for android test source path: " + (String)closestAndroidTestSourcePath + " and launched activity source root: " + launchedActivitySourceRoot.getCanonicalPath());
            }
            return this.getOrCreateSubdirectory(parentDirectory, ((String)closestAndroidTestSourcePath).substring(parentDirectory.getCanonicalPath().length() + 1).split("/"), true);
        }
        return existingAndroidTestSourceRoots.get(TestClassNameInputDialog.findClosestAndroidTestSourceRootIndex(launchedActivitySourceRoot, TestClassNameInputDialog.getCanonicalPaths(existingAndroidTestSourceRoots)));
    }

    private VirtualFile getClosestContentRoot(@Nullable VirtualFile launchedActivitySourceRoot) {
        @NotNull VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)this.myTestClassModule).getContentRoots();
        if (contentRoots.length == 0) {
            throw new RuntimeException("Could not find any content roots");
        }
        if (contentRoots.length == 1 || launchedActivitySourceRoot == null || launchedActivitySourceRoot.getCanonicalPath() == null) {
            return contentRoots[0];
        }
        for (VirtualFile contentRoot : contentRoots) {
            if (contentRoot.getCanonicalPath() == null || !launchedActivitySourceRoot.getCanonicalPath().startsWith(contentRoot.getCanonicalPath())) continue;
            return contentRoot;
        }
        return contentRoots[0];
    }

    private VirtualFile findContainingDirectory(VirtualFile currentDirectory, String path) {
        if (currentDirectory == null || path.startsWith(currentDirectory.getCanonicalPath())) {
            return currentDirectory;
        }
        return this.findContainingDirectory(currentDirectory.getParent(), path);
    }

    private List<String> getAndroidTestSourceRoots() {
        AndroidFacet facet = AndroidFacet.getInstance((Module)this.myTestClassModule);
        if (facet == null) {
            return Collections.emptyList();
        }
        SourceProviders sourceProviders = SourceProviders.getInstance((AndroidFacet)facet);
        IdeaSourceProvider androidSourceProvider = (IdeaSourceProvider)sourceProviders.getDeviceTestSources().get(CommonTestType.ANDROID_TEST);
        if (androidSourceProvider == null) {
            return Collections.emptyList();
        }
        List<String> androidTestSourceRoots = Streams.stream((Iterable)Iterables.concat((Iterable)androidSourceProvider.getJavaDirectories(), (Iterable)androidSourceProvider.getKotlinDirectories())).map(VirtualFile::getCanonicalPath).collect(Collectors.toList());
        if (!androidTestSourceRoots.isEmpty()) {
            return androidTestSourceRoots;
        }
        return Streams.stream((Iterable)Iterables.concat((Iterable)androidSourceProvider.getJavaDirectoryUrls(), (Iterable)androidSourceProvider.getKotlinDirectoryUrls())).map(TestClassNameInputDialog::getURLPath).collect(Collectors.toList());
    }

    private static String getURLPath(String url) {
        try {
            return new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private static List<String> getCanonicalPaths(List<VirtualFile> virtualFiles) {
        ArrayList canonicalPaths = Lists.newArrayList();
        for (VirtualFile virtualFile : virtualFiles) {
            canonicalPaths.add(virtualFile.getCanonicalPath());
        }
        return canonicalPaths;
    }

    private VirtualFile getOrCreateSubdirectory(final VirtualFile parentDirectory, final String[] subdirectoriesPath, final boolean includeLastPathElement) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile currentDirectory = parentDirectory;
                int subdirectoriesPathLength = includeLastPathElement ? subdirectoriesPath.length : subdirectoriesPath.length - 1;
                for (int i = 0; i < subdirectoriesPathLength; ++i) {
                    String subdirectory = subdirectoriesPath[i];
                    VirtualFile child = currentDirectory.findChild(subdirectory);
                    if (child == null) {
                        try {
                            currentDirectory = currentDirectory.createChildDirectory((Object)this, subdirectory);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to create subdirectory " + subdirectory, e);
                        }
                    }
                    currentDirectory = child;
                }
                return currentDirectory;
            }
        });
    }

    private static int findClosestAndroidTestSourceRootIndex(@Nullable VirtualFile sourceRoot, List<String> androidTestSourceRootPaths) {
        if (sourceRoot == null) {
            return 0;
        }
        String sourceRootCanonicalPath = sourceRoot.getCanonicalPath();
        int closestAndroidTestSourceIndex = 0;
        String closestAndroidTestSourceRootPath = androidTestSourceRootPaths.get(closestAndroidTestSourceIndex);
        int maxOverlapSize = TestClassNameInputDialog.computeOverlapSize(sourceRootCanonicalPath, closestAndroidTestSourceRootPath);
        for (int i = 1; i < androidTestSourceRootPaths.size(); ++i) {
            int overlapSize = TestClassNameInputDialog.computeOverlapSize(sourceRootCanonicalPath, androidTestSourceRootPaths.get(i));
            if (overlapSize <= maxOverlapSize) continue;
            maxOverlapSize = overlapSize;
            closestAndroidTestSourceIndex = i;
        }
        return closestAndroidTestSourceIndex;
    }

    private static int computeOverlapSize(String sourceRootPath, String androidTestPath) {
        androidTestPath = TestClassNameInputDialog.getFilePathPrefix(sourceRootPath, (String)androidTestPath) + (String)androidTestPath;
        char[] pathChars1 = sourceRootPath.toCharArray();
        char[] pathChars2 = ((String)androidTestPath).toCharArray();
        int overlapSize = 0;
        for (int i = 0; i < Math.min(pathChars1.length, pathChars2.length) && pathChars1[i] == pathChars2[i]; ++i) {
            ++overlapSize;
        }
        return overlapSize;
    }

    private static String getFilePathPrefix(String sourceRootPath, String androidTestPath) {
        String prefixMarker = ":/";
        int prefixIndex = sourceRootPath.indexOf(":/");
        if (prefixIndex != -1 && !androidTestPath.contains(":/")) {
            return sourceRootPath.substring(0, prefixIndex + 1);
        }
        return "";
    }

    private static void collectModulesClosure(@NotNull Module module, List<Module> result) {
        if (result.contains(module)) {
            return;
        }
        result.add(module);
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            TestClassNameInputDialog.collectModulesClosure(depModule, result);
        }
    }

    @Nullable
    private VirtualFile getContainingSourceRoot(String fileRelativePath) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)this.myTestClassModule);
        if (facet == null) {
            return null;
        }
        NamedIdeaSourceProvider mainIdeaSourceProvider = SourceProviders.getInstance((AndroidFacet)facet).getMainIdeaSourceProvider();
        Iterator iterator = mainIdeaSourceProvider.getJavaDirectories().iterator();
        if (!iterator.hasNext()) {
            iterator = mainIdeaSourceProvider.getKotlinDirectories().iterator();
        }
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            VirtualFile sourceRoot = (VirtualFile)iterator.next();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)sourceRoot, (Project)this.myProject) || sourceRoot.findFileByRelativePath(fileRelativePath) == null) continue;
            return sourceRoot;
        }
        return null;
    }

    private List<VirtualFile> getExistingAndroidTestSourceRoots() {
        ArrayList existingAndroidTestSourceRoots = Lists.newArrayList();
        for (VirtualFile testSourceRoot : ModuleRootManager.getInstance((Module)this.myTestClassModule).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            TestArtifactSearchScopes searchScopes;
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)testSourceRoot, (Project)this.myProject) || (searchScopes = TestArtifactSearchScopes.getInstance((Module)this.myTestClassModule)) == null || !searchScopes.isAndroidTestSource(testSourceRoot)) continue;
            existingAndroidTestSourceRoots.add(testSourceRoot);
        }
        return existingAndroidTestSourceRoots;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myErrorMessageLabel.setText("");
        this.myErrorMessageLabel.setForeground((Color)JBColor.RED);
        this.myClassNameArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                TestClassNameInputDialog.this.myClassName = TestClassNameInputDialog.this.myClassNameArea.getText().trim();
                TestClassNameInputDialog.this.updateOKButton();
            }
        });
        return this.myRootPanel;
    }

    private void updateOKButton() {
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myClassName));
    }

    public PsiClass getTestClass() {
        return this.myTestClass;
    }

    public boolean isKotlinTestClass() {
        return "Kotlin".equals(this.mySelectedLanguage);
    }

    public Module getTestClassModule() {
        return this.myTestClassModule;
    }

    protected void doOKAction() {
        this.mySelectedLanguage = (String)this.myClassLanguageComboBox.getSelectedItem();
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return TestClassNameInputDialog.this.doesClassExist();
            }
        })).booleanValue()) {
            this.myErrorMessageLabel.setText("File already exists.");
            return;
        }
        super.doOKAction();
    }

    private boolean doesClassExist() {
        return this.myTestClassParent.findFile(TestClassNameInputDialog.appendJavaExtension(this.myClassName)) != null || this.myTestClassParent.findFile(TestClassNameInputDialog.appendKotlinExtension(this.myClassName)) != null;
    }

    @NotNull
    private static String appendJavaExtension(String appendToString) {
        return appendToString + ".java";
    }

    @NotNull
    private static String appendKotlinExtension(String appendToString) {
        return appendToString + ".kt";
    }

    public void doCancelAction() {
        this.myClassName = null;
        this.myTestClass = null;
        super.doCancelAction();
    }

    public void dispose() {
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.google.gct.testrecorder.ui.TestClassNameInputDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameArea;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setInheritsPopupMenu(false);
        jPanel.setMinimumSize(new Dimension(450, 85));
        jPanel.setOpaque(true);
        jPanel.setPreferredSize(new Dimension(450, 85));
        this.myErrorMessageLabel = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setHorizontalAlignment(4);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("ERROR");
        jPanel.add((Component)jLabel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setMinimumSize(new Dimension(450, 66));
        jPanel2.setOpaque(true);
        jPanel2.setPreferredSize(new Dimension(450, 66));
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setMinimumSize(new Dimension(450, 27));
        jPanel3.setPreferredSize(new Dimension(450, 27));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel2 = new JLabel();
        jLabel2.setOpaque(true);
        jLabel2.setText("Test class name:");
        jPanel3.add((Component)jLabel2, "West");
        this.myClassNameArea = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(320, 27));
        jTextArea.setOpaque(true);
        jTextArea.setPreferredSize(new Dimension(320, 27));
        jPanel3.add((Component)jTextArea, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel4.setMinimumSize(new Dimension(450, 29));
        jPanel4.setPreferredSize(new Dimension(450, 29));
        jPanel2.add((Component)jPanel4, "South");
        JLabel jLabel3 = new JLabel();
        jLabel3.setOpaque(true);
        jLabel3.setText("Test class language:");
        jPanel4.add((Component)jLabel3, "West");
        JComboBox jComboBox = new JComboBox();
        this.myClassLanguageComboBox = jComboBox;
        jComboBox.setMaximumSize(new Dimension(320, 29));
        jComboBox.setMinimumSize(new Dimension(320, 29));
        jComboBox.setOpaque(true);
        jComboBox.setPopupVisible(false);
        jComboBox.setPreferredSize(new Dimension(320, 29));
        jPanel4.add(jComboBox, "East");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

