/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;

public class ClassHelper {
    public static String getInternalName(Project project, String className) {
        DefaultJavaEvaluator evaluator;
        String internalName;
        PsiClass psiClass = ClassHelper.getPsiClass(project, className);
        if (psiClass != null && (internalName = (evaluator = new DefaultJavaEvaluator(project, null)).getInternalName(psiClass)) != null) {
            return internalName.replace('/', '.');
        }
        String[] nameFragments = className.split("\\.");
        StringBuilder resultClassName = new StringBuilder();
        for (int i = 0; i < nameFragments.length - 1; ++i) {
            String fragment = nameFragments[i];
            resultClassName.append(fragment).append(Character.isUpperCase(fragment.charAt(0)) ? "$" : ".");
        }
        resultClassName.append(nameFragments[nameFragments.length - 1]);
        return resultClassName.toString();
    }

    private static PsiClass getPsiClass(Project project, String className) {
        try {
            return JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }
}

