/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.dependencies.DependenciesHelper;
import com.android.tools.idea.gradle.dependencies.DependencyMatcher;
import com.android.tools.idea.gradle.dependencies.ExactDependencyMatcher;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.google.common.collect.ImmutableList;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.util.EspressoSetupToken;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EspressoSetupGradleToken
implements EspressoSetupToken<GradleProjectSystem>,
GradleToken {
    @Override
    public boolean ensureSetup(@NotNull GradleProjectSystem projectSystem, @NotNull Module testClassModule, @NotNull AndroidFacet facet, @NotNull JPanel rootPanel, @NotNull List<ElementAction> elementActions) {
        return new SetupEnsurer(projectSystem, testClassModule, facet, rootPanel, elementActions).setup();
    }

    @Override
    public boolean supportsKotlin(@NotNull GradleProjectSystem projectSystem, @NotNull Module testClassModule) {
        GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)testClassModule);
        if (gradleBuildModel == null) {
            return false;
        }
        List pluginNames = PluginModel.extractNames((List)gradleBuildModel.plugins());
        return pluginNames.contains("kotlin-android") || pluginNames.contains("org.jetbrains.kotlin.android");
    }

    @Override
    public boolean isNativeProject(@NotNull GradleProjectSystem projectSystem, @NotNull Module module) {
        return GradleBuildModel.get((Module)module) != null && GradleBuildModel.get((Module)module).android().externalNativeBuild().cmake().version().getValueType() != GradlePropertyModel.ValueType.NONE;
    }

    private static class SetupEnsurer {
        GradleProjectSystem projectSystem;
        Module testClassModule;
        AndroidFacet facet;
        JPanel rootPanel;
        List<ElementAction> elementActions;
        private boolean myNeedsContribDependency = false;
        private boolean myUsesAnyEspressoDependency = false;
        private boolean myUsesAndroidxDependency = false;
        private boolean myUsesGrantPermissionRule = false;
        private Version myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST;
        private final Version myMinAndroidxEspressoCoreVersion = MIN_ANDROIDX_ESPRESSO_CORE_VERSION;
        private Version myMinRulesVersion = MIN_RULES_VERSION_FOR_LARGE_TEST;
        private final Version myMinAndroidxRulesVersion = MIN_ANDROIDX_RULES_VERSION;
        private final Version myMinAndroidxExtJunitVersion = MIN_ANDROIDX_EXT_JUNIT_VERSION;
        public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_CORE_EXCLUDES = ImmutableList.of((Object)SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS, null));
        public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_CONTRIB_EXCLUDES = ImmutableList.of((Object)SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS, null), (Object)SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_V4, null), (Object)SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.DESIGN, null), (Object)SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.RECYCLERVIEW_V7, null));
        private static final String ESPRESSO_CORE_CUSTOM_ARTIFACT_NAME = "espresso";
        private static final String ESPRESSO_CORE_CUSTOM_GROUP_NAME = "com.jakewharton.espresso";
        public static final String TEST_INSTRUMENTATION_RUNNER = "android.support.test.runner.AndroidJUnitRunner";
        public static final String ANDROIDX_TEST_INSTRUMENTATION_RUNNER = "androidx.test.runner.AndroidJUnitRunner";
        private static final Version MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST = Version.parse((String)"2.2.2");
        private static final Version MIN_RULES_VERSION_FOR_LARGE_TEST = Version.parse((String)"0.5");
        private static final Version MIN_ESPRESSO_CORE_VERSION_FOR_GRANT_PERMISSION_RULE = Version.parse((String)"3.0.0");
        private static final Version MIN_RULES_VERSION_FOR_GRANT_PERMISSION_RULE = Version.parse((String)"1.0.0");
        private static final Version MIN_ANDROIDX_ESPRESSO_CORE_VERSION = Version.parse((String)"3.5.0");
        private static final Version MIN_ANDROIDX_RULES_VERSION = Version.parse((String)"1.5.0");
        private static final Version MIN_ANDROIDX_EXT_JUNIT_VERSION = Version.parse((String)"1.1.5");
        private static String espressoCoreVersion = null;
        private static String androidxEspressoCoreVersion = null;
        private static String rulesVersion = null;
        private static String androidxRulesVersion = null;
        private static String androidxExtJunitVersion = null;

        SetupEnsurer(GradleProjectSystem projectSystem, Module testClassModule, AndroidFacet facet, JPanel rootPanel, List<ElementAction> elementActions) {
            this.projectSystem = projectSystem;
            this.testClassModule = testClassModule;
            this.rootPanel = rootPanel;
            this.facet = facet;
            this.elementActions = elementActions;
            this.initializeDependencyRequirements();
        }

        private boolean setup() {
            AndroidModel androidModel;
            Project project = this.projectSystem.getProject();
            ProjectBuildModel projectModel = ProjectBuildModel.get((Project)project);
            GradleBuildModel gradleBuildModel = projectModel.getModuleBuildModel(this.testClassModule);
            if (gradleBuildModel != null && !this.hasAllRequiredEspressoDependencies(androidModel = gradleBuildModel.android(), ProjectSystemUtil.getModuleSystem((Module)this.testClassModule))) {
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_MISSING_ESPRESSO_DEPENDENCIES), (Project)project));
                if (((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Missing or obsolete Espresso dependencies", (String)"Some dependencies for running Espresso tests are missing or obsolete.\nWould you like to automatically add/update Espresso dependencies for this app?\nTo complete the set up, Gradle might ask you to install the missing libraries.\nPlease click on the corresponding link(s) to install them.").icon(null)).ask((Component)this.rootPanel)) {
                    this.setupEspresso(projectModel, gradleBuildModel);
                }
            }
            return this.myUsesAndroidxDependency;
        }

        private boolean hasAllRequiredEspressoDependencies(@NotNull AndroidModel androidModel, @NotNull AndroidModuleSystem androidModuleSystem) {
            this.initializeDependencyRequirements();
            return !(!this.hasUptodateEspressoCoreDependency(androidModuleSystem) || !this.hasUptodateRulesDependency(androidModuleSystem) || this.myNeedsContribDependency && !this.hasUptodateEspressoContribDependency(androidModuleSystem) || this.myUsesAndroidxDependency && this.myUsesGrantPermissionRule && !this.hasUptodateAndroidxRulesDependency(androidModuleSystem) || !SetupEnsurer.hasSetInstrumentationRunner(androidModel));
        }

        private void initializeDependencyRequirements() {
            this.myNeedsContribDependency = false;
            this.myUsesAnyEspressoDependency = false;
            this.myUsesAndroidxDependency = false;
            this.myUsesGrantPermissionRule = false;
            this.myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST;
            this.myMinRulesVersion = MIN_RULES_VERSION_FOR_LARGE_TEST;
            for (ElementAction action : this.elementActions) {
                if (!(action instanceof TestRecorderEvent)) continue;
                TestRecorderEvent testRecorderEvent = (TestRecorderEvent)action;
                if (testRecorderEvent.getElementRecyclerViewChildPosition() != -1) {
                    this.myNeedsContribDependency = true;
                    continue;
                }
                if (!testRecorderEvent.isPermissionsRequest()) continue;
                this.myUsesGrantPermissionRule = true;
                this.myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_GRANT_PERMISSION_RULE;
                this.myMinRulesVersion = MIN_RULES_VERSION_FOR_GRANT_PERMISSION_RULE;
            }
        }

        private boolean hasUptodateEspressoCoreDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
            return this.hasUptodateDependency(androidModuleSystem, GoogleMavenArtifactId.ESPRESSO_CORE, GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE, this.myMinEspressoCoreVersion, this.myMinAndroidxEspressoCoreVersion);
        }

        private boolean hasUptodateRulesDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
            return this.hasUptodateDependency(androidModuleSystem, GoogleMavenArtifactId.TEST_RULES, GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT, this.myMinRulesVersion, this.myMinAndroidxExtJunitVersion);
        }

        private boolean hasUptodateEspressoContribDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
            return this.hasUptodateDependency(androidModuleSystem, GoogleMavenArtifactId.ESPRESSO_CONTRIB, GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB, this.myMinEspressoCoreVersion, this.myMinAndroidxEspressoCoreVersion);
        }

        private boolean hasUptodateAndroidxRulesDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
            return this.hasUptodateDependency(androidModuleSystem, null, GoogleMavenArtifactId.ANDROIDX_TEST_RULES, this.myMinRulesVersion, this.myMinAndroidxRulesVersion);
        }

        private static boolean hasSetInstrumentationRunner(@NotNull AndroidModel androidModel) {
            String testInstrumentationRunner = (String)androidModel.defaultConfig().testInstrumentationRunner().getValue(GradlePropertyModel.STRING_TYPE);
            return testInstrumentationRunner != null && !testInstrumentationRunner.isEmpty();
        }

        private boolean hasUptodateDependency(@NotNull AndroidModuleSystem androidModuleSystem, @Nullable GoogleMavenArtifactId artifact, @Nullable GoogleMavenArtifactId androidxArtifact, @NotNull Version minVersion, @NotNull Version androidxMinVersion) {
            Version dependencyVersion = SetupEnsurer.getDependencyVersion(androidModuleSystem, artifact);
            if (dependencyVersion != null) {
                this.myUsesAnyEspressoDependency = true;
                return dependencyVersion.compareTo(minVersion) >= 0;
            }
            Version androidxDependencyVersion = SetupEnsurer.getDependencyVersion(androidModuleSystem, androidxArtifact);
            if (androidxDependencyVersion != null) {
                this.myUsesAnyEspressoDependency = true;
                this.myUsesAndroidxDependency = true;
                return androidxDependencyVersion.compareTo(androidxMinVersion) >= 0;
            }
            return false;
        }

        @Nullable
        private static Version getDependencyVersion(@NotNull AndroidModuleSystem androidModuleSystem, @Nullable GoogleMavenArtifactId artifact) {
            if (artifact == null) {
                return null;
            }
            GradleCoordinate resolvedDependency = androidModuleSystem.getResolvedDependency(artifact, DependencyScopeType.ANDROID_TEST);
            if (resolvedDependency == null) {
                return null;
            }
            return resolvedDependency.getLowerBoundVersion();
        }

        private void setupEspresso(final @NotNull ProjectBuildModel projectModel, final @NotNull GradleBuildModel gradleBuildModel) {
            if (!this.myUsesAnyEspressoDependency) {
                AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)this.facet.getModule());
                for (GoogleMavenArtifactId artifactId : GoogleMavenArtifactId.values()) {
                    GradleCoordinate coordinate;
                    if (!artifactId.getMavenGroupId().startsWith("androidx.") && !artifactId.getMavenGroupId().equals("com.google.android.material") || (coordinate = moduleSystem.getResolvedDependency(artifactId)) == null) continue;
                    this.myUsesAndroidxDependency = true;
                    break;
                }
            }
            new Task.Modal(this.projectSystem.getProject(), "Setting up Espresso", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicator.setText("Adding Espresso dependencies");
                    indicator.setIndeterminate(true);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                        AndroidModel androidModel;
                        this.addOrUpdateEspressoCoreDependency();
                        this.addOrUpdateRulesDependency();
                        if (myNeedsContribDependency) {
                            this.addOrUpdateEspressoContribDependency();
                        }
                        if (myUsesAndroidxDependency && myUsesGrantPermissionRule) {
                            this.addOrUpdateAndroidxRulesDependency();
                        }
                        if ((androidModel = gradleBuildModel.android()) != null && !SetupEnsurer.hasSetInstrumentationRunner(androidModel)) {
                            androidModel.defaultConfig().testInstrumentationRunner().setValue((Object)(myUsesAndroidxDependency ? SetupEnsurer.ANDROIDX_TEST_INSTRUMENTATION_RUNNER : SetupEnsurer.TEST_INSTRUMENTATION_RUNNER));
                        }
                        projectModel.applyChanges();
                        if (this.myProject != null) {
                            ProjectSystemUtil.getProjectSystem((Project)this.myProject).getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_ESPRESSO_SETUP));
                        }
                    });
                }

                private void addOrUpdateEspressoCoreDependency() {
                    boolean hasUpdatedEspressoCoreVersion = false;
                    for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                        if (SetupEnsurer.ESPRESSO_CORE_CUSTOM_GROUP_NAME.equals(artifact.group().toString()) && SetupEnsurer.ESPRESSO_CORE_CUSTOM_ARTIFACT_NAME.equals(artifact.name().forceString())) {
                            gradleBuildModel.dependencies().remove((DependencyModel)artifact);
                            continue;
                        }
                        if (this.isMatchingArtifact(artifact, this.getEspressoArtifactId())) {
                            artifact.version().setValue((Object)this.getEspressoArtifactUpdateVersion());
                            hasUpdatedEspressoCoreVersion = true;
                            continue;
                        }
                        if (this.isMatchingArtifact(artifact, this.getEspressoContribArtifactId())) {
                            artifact.version().setValue((Object)this.getEspressoArtifactUpdateVersion());
                            continue;
                        }
                        if (this.isMatchingArtifact(artifact, this.getTestRulesArtifactId())) {
                            artifact.version().setValue((Object)this.getTestRulesArtifactUpdateVersion());
                            continue;
                        }
                        if (!this.isMatchingArtifact(artifact, GoogleMavenArtifactId.ANDROIDX_TEST_RULES)) continue;
                        artifact.version().setValue((Object)SetupEnsurer.getAndroidxRulesVersion());
                    }
                    if (!hasUpdatedEspressoCoreVersion) {
                        if (myUsesAndroidxDependency) {
                            this.addArtifact(SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE, SetupEnsurer.getAndroidxEspressoCoreVersion()), (List<ArtifactDependencySpec>)ImmutableList.of());
                        } else {
                            this.addArtifact(SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ESPRESSO_CORE, SetupEnsurer.getEspressoCoreVersion()), (List<ArtifactDependencySpec>)ESPRESSO_CORE_EXCLUDES);
                        }
                    }
                }

                private void addOrUpdateRulesDependency() {
                    for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                        if (!this.isMatchingArtifact(artifact, this.getTestRulesArtifactId())) continue;
                        artifact.version().setValue((Object)this.getTestRulesArtifactUpdateVersion());
                        return;
                    }
                    this.addArtifact(SetupEnsurer.createArtifactDependencySpec(this.getTestRulesArtifactId(), this.getTestRulesArtifactUpdateVersion()), (List<ArtifactDependencySpec>)ImmutableList.of());
                }

                private void addOrUpdateAndroidxRulesDependency() {
                    for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                        if (!this.isMatchingArtifact(artifact, GoogleMavenArtifactId.ANDROIDX_TEST_RULES)) continue;
                        artifact.version().setValue((Object)SetupEnsurer.getAndroidxRulesVersion());
                        return;
                    }
                    this.addArtifact(SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_TEST_RULES, SetupEnsurer.getAndroidxRulesVersion()), (List<ArtifactDependencySpec>)ImmutableList.of());
                }

                private void addOrUpdateEspressoContribDependency() {
                    for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                        if (!this.isMatchingArtifact(artifact, this.getEspressoContribArtifactId())) continue;
                        artifact.version().setValue((Object)this.getEspressoArtifactUpdateVersion());
                        return;
                    }
                    if (myUsesAndroidxDependency) {
                        ArtifactDependencySpec spec = SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB, SetupEnsurer.getAndroidxEspressoCoreVersion());
                        this.addArtifact(SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB, SetupEnsurer.getAndroidxEspressoCoreVersion()), (List<ArtifactDependencySpec>)ImmutableList.of());
                    } else {
                        this.addArtifact(SetupEnsurer.createArtifactDependencySpec(GoogleMavenArtifactId.ESPRESSO_CONTRIB, SetupEnsurer.getEspressoCoreVersion()), (List<ArtifactDependencySpec>)ESPRESSO_CONTRIB_EXCLUDES);
                    }
                }

                private boolean isMatchingArtifact(ArtifactDependencyModel artifact, GoogleMavenArtifactId artifactId) {
                    return artifactId.getMavenGroupId().equals(artifact.group().toString()) && artifactId.getMavenArtifactId().equals(artifact.name().forceString());
                }

                private void addArtifact(@NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
                    String compactNotation = dependency.compactNotation();
                    DependenciesHelper.withModel((ProjectBuildModel)projectModel).addDependency("androidTestImplementation", compactNotation, excludes, gradleBuildModel, (DependencyMatcher)new ExactDependencyMatcher("androidTestImplementation", compactNotation), null);
                }
            }.queue();
        }

        private GoogleMavenArtifactId getEspressoArtifactId() {
            return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE : GoogleMavenArtifactId.ESPRESSO_CORE;
        }

        private String getEspressoArtifactUpdateVersion() {
            return this.myUsesAndroidxDependency ? SetupEnsurer.getAndroidxEspressoCoreVersion() : SetupEnsurer.getEspressoCoreVersion();
        }

        private GoogleMavenArtifactId getEspressoContribArtifactId() {
            return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB : GoogleMavenArtifactId.ESPRESSO_CONTRIB;
        }

        private GoogleMavenArtifactId getTestRulesArtifactId() {
            return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT : GoogleMavenArtifactId.TEST_RULES;
        }

        private String getTestRulesArtifactUpdateVersion() {
            return this.myUsesAndroidxDependency ? SetupEnsurer.getAndroidxExtJunitVersion() : SetupEnsurer.getRulesVersion();
        }

        private static String getEspressoCoreVersion() {
            if (espressoCoreVersion == null) {
                espressoCoreVersion = SetupEnsurer.getLatestDependencyVersion(GoogleMavenArtifactId.ESPRESSO_CORE, "3.0.2");
            }
            return espressoCoreVersion;
        }

        private static String getAndroidxEspressoCoreVersion() {
            if (androidxEspressoCoreVersion == null) {
                androidxEspressoCoreVersion = SetupEnsurer.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE, "3.5.0");
            }
            return androidxEspressoCoreVersion;
        }

        private static String getRulesVersion() {
            if (rulesVersion == null) {
                rulesVersion = SetupEnsurer.getLatestDependencyVersion(GoogleMavenArtifactId.TEST_RULES, "1.0.2");
            }
            return rulesVersion;
        }

        private static String getAndroidxRulesVersion() {
            if (androidxRulesVersion == null) {
                androidxRulesVersion = SetupEnsurer.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_TEST_RULES, "1.5.0");
            }
            return androidxRulesVersion;
        }

        private static String getAndroidxExtJunitVersion() {
            if (androidxExtJunitVersion == null) {
                androidxExtJunitVersion = SetupEnsurer.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT, "1.1.5");
            }
            return androidxExtJunitVersion;
        }

        private static String getLatestDependencyVersion(GoogleMavenArtifactId artifactId, String fallbackVersion) {
            com.android.ide.common.gradle.Component latestComponent = RepositoryUrlManager.get().getArtifactComponent(artifactId, true);
            if (latestComponent != null) {
                return latestComponent.getVersion().toString();
            }
            return fallbackVersion;
        }

        @NotNull
        private static ArtifactDependencySpec createArtifactDependencySpec(@NotNull GoogleMavenArtifactId artifactId, @Nullable String version) {
            return ArtifactDependencySpec.create((String)artifactId.getMavenArtifactId(), (String)artifactId.getMavenGroupId(), (String)version);
        }
    }
}

